/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ProtocolUtils;

public class ServuxProtocol {
    public static final String PROTOCOL_ID = "servux";
    public static final int PROTOCOL_VERSION = 1;
    public static final int PACKET_METADATA = 1;
    public static final int PACKET_STRUCTURE_DATA = 2;
    public static final MinecraftKey CHANNEL = ServuxProtocol.id("structures");
    private static final Map<Integer, EntityPlayer> players = new ConcurrentHashMap<Integer, EntityPlayer>();
    private static final Map<Integer, Set<StructureBoundingBox>> playerBoundingBoxesCache = new HashMap<Integer, Set<StructureBoundingBox>>();
    private static final Map<MinecraftKey, Map<StructureBoundingBox, NBTTagCompound>> dimensionCache = new ConcurrentHashMap<MinecraftKey, Map<StructureBoundingBox, NBTTagCompound>>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    public static void onPlayerSubscribed(@NotNull EntityPlayer player) {
        if (LeavesConfig.servuxProtocol) {
            players.put(player.af(), player);
            NBTTagCompound tag = new NBTTagCompound();
            tag.a("version", 1);
            tag.a("id", CHANNEL.toString());
            tag.a("timeout", 0x7FFFFF37);
            ServuxProtocol.sendNBTPacket(player, 1, tag);
        }
    }

    public static void onPlayerLoggedOut(@NotNull EntityPlayer player) {
        if (LeavesConfig.servuxProtocol) {
            players.remove(player.af());
            playerBoundingBoxesCache.remove(player.af());
        }
    }

    public static void onChunkLoaded(@NotNull Chunk chunk) {
        if (LeavesConfig.servuxProtocol) {
            ArrayList<StructureStart> structures = new ArrayList<StructureStart>();
            IRegistry<Structure> structureFeatureRegistry = chunk.F().B_().d(Registries.az);
            for (Map.Entry<Structure, StructureStart> es : chunk.g().entrySet()) {
                Optional<ResourceKey<Structure>> optional = structureFeatureRegistry.c(es.getKey());
                optional.ifPresent(key -> structures.add((StructureStart)es.getValue()));
            }
            if (!structures.isEmpty()) {
                ServuxProtocol.onStructuresLoaded((WorldServer)chunk.F(), structures);
            }
        }
    }

    public static void onStructuresLoaded(@NotNull WorldServer level, @NotNull List<StructureStart> structures) {
        Map<StructureBoundingBox, NBTTagCompound> cache = ServuxProtocol.getOrCreateCache(level.ac().a());
        for (StructureStart structureStart : structures) {
            if (structureStart == null) {
                return;
            }
            StructurePieceSerializationContext ctx = StructurePieceSerializationContext.a(level);
            StructureBoundingBox boundingBox = structureStart.a();
            if (cache.containsKey(boundingBox)) {
                return;
            }
            cache.put(boundingBox, structureStart.a(ctx, structureStart.c()));
        }
    }

    private static void sendBoundingToPlayer(int id, EntityPlayer player) {
        Map<StructureBoundingBox, NBTTagCompound> boundingBoxMap = dimensionCache.get(player.dI().ac().a());
        if (boundingBoxMap == null) {
            return;
        }
        Set playerBoundingBoxes = playerBoundingBoxesCache.computeIfAbsent(id, k2 -> new HashSet());
        NBTTagList listTag = new NBTTagList();
        for (StructureBoundingBox key : boundingBoxMap.keySet()) {
            if (listTag.size() >= 50) break;
            if (playerBoundingBoxes.contains(key)) continue;
            NBTTagCompound boundingBoxes = boundingBoxMap.get(key);
            if (boundingBoxes != null) {
                listTag.add(boundingBoxes);
            }
            playerBoundingBoxes.add(key);
        }
        if (!listTag.isEmpty()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.a("Structures", listTag);
            ServuxProtocol.sendNBTPacket(player, 2, tag);
        }
    }

    public static void tick() {
        if (LeavesConfig.servuxProtocol) {
            for (Map.Entry<Integer, EntityPlayer> playerEntry : players.entrySet()) {
                ServuxProtocol.sendBoundingToPlayer(playerEntry.getKey(), playerEntry.getValue());
            }
        }
    }

    private static Map<StructureBoundingBox, NBTTagCompound> getOrCreateCache(MinecraftKey dimensionId) {
        return dimensionCache.computeIfAbsent(dimensionId, dt -> new ConcurrentHashMap());
    }

    public static void sendNBTPacket(EntityPlayer player, int packetType, NBTTagCompound data) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.d(packetType);
        buf.a(data);
        int len = buf.writerIndex();
        buf.readerIndex(0);
        PacketDataSerializer buf1 = new PacketDataSerializer(Unpooled.buffer((int)len));
        buf1.d(len);
        buf1.writeBytes(buf, len);
        ProtocolUtils.sendPayloadPacket(player, CHANNEL, buf1);
        buf.release();
    }
}

