/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.bladeren;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ProtocolUtils;

public class LeavesProtocol {
    public static final String PROTOCOL_ID = "bladeren";
    public static final String PROTOCOL_VERSION = "1.0.0";
    private static final MinecraftKey HELLO_ID = LeavesProtocol.id("hello");
    private static final MinecraftKey FEATURE_MODIFY_ID = LeavesProtocol.id("feature_modify");
    private static final Map<String, BiConsumer<EntityPlayer, NBTTagCompound>> registeredFeatures = new HashMap<String, BiConsumer<EntityPlayer, NBTTagCompound>>();
    private static final Map<MinecraftKey, BiConsumer<EntityPlayer, PacketDataSerializer>> registeredPackets = new HashMap<MinecraftKey, BiConsumer<EntityPlayer, PacketDataSerializer>>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    public static void registerFeature(String name, BiConsumer<EntityPlayer, NBTTagCompound> consumer) {
        registeredFeatures.put(name, consumer);
    }

    public static void registerPacket(MinecraftKey id, BiConsumer<EntityPlayer, PacketDataSerializer> consumer) {
        registeredPackets.put(id, consumer);
    }

    public static void handlePacket(EntityPlayer player, @NotNull PacketPlayInCustomPayload packet) {
        if (packet.c.equals(HELLO_ID)) {
            LeavesProtocol.handleHello(player, packet.d);
        } else if (packet.c.equals(FEATURE_MODIFY_ID)) {
            LeavesProtocol.handleModify(player, packet.d);
        } else if (registeredPackets.containsKey(packet.c)) {
            registeredPackets.get(packet.c).accept(player, packet.d);
        }
    }

    private static void handleModify(@NotNull EntityPlayer player, @NotNull PacketDataSerializer data) {
        String name = data.s();
        NBTTagCompound tag = data.p();
        if (registeredFeatures.containsKey(name)) {
            registeredFeatures.get(name).accept(player, tag);
        }
    }

    private static void handleHello(@NotNull EntityPlayer player, @NotNull PacketDataSerializer data) {
        String clientVersion = data.e(64);
        NBTTagCompound tag = data.p();
        if (tag != null) {
            NBTTagCompound featureNbt = tag.p("Features");
            for (String name : featureNbt.e()) {
                if (!registeredFeatures.containsKey(name)) continue;
                registeredFeatures.get(name).accept(player, featureNbt.p(name));
            }
        }
    }

    public static void onPlayerJoin(@NotNull EntityPlayer player) {
        if (LeavesConfig.bladerenLeavesProtocol) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a(PROTOCOL_VERSION);
            NBTTagCompound tag = new NBTTagCompound();
            LeavesFeatureSet.writeNBT(tag);
            buf.a(tag);
            ProtocolUtils.sendPayloadPacket(player, HELLO_ID, buf);
        }
    }

    public static class LeavesFeatureSet {
        private static final Map<String, LeavesFeature> features = new HashMap<String, LeavesFeature>();

        public static void writeNBT(@NotNull NBTTagCompound tag) {
            NBTTagCompound featureNbt = new NBTTagCompound();
            features.values().forEach(feature -> feature.writeNBT(featureNbt));
            tag.a("Features", featureNbt);
        }

        public static void register(LeavesFeature feature) {
            features.put(feature.name, feature);
        }
    }

    public record LeavesFeature(String name, String value) {
        @NotNull
        @Contract(value="_, _ -> new")
        public static LeavesFeature of(String name, boolean value) {
            return new LeavesFeature(name, Boolean.toString(value));
        }

        public void writeNBT(@NotNull NBTTagCompound rules) {
            NBTTagCompound rule = new NBTTagCompound();
            rule.a("Feature", this.name);
            rule.a("Value", this.value);
            rules.a(this.name, rule);
        }
    }
}

