/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.bladeren;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.bladeren.LeavesProtocol;
import top.leavesmc.leaves.util.ProtocolUtils;
import top.leavesmc.leaves.util.TickStatus;

public class MsptSyncProtocol {
    public static final String PROTOCOL_ID = "bladeren";
    private static final MinecraftKey MSPT_SYNC = MsptSyncProtocol.id("mspt_sync");
    private static final List<EntityPlayer> players = new ArrayList<EntityPlayer>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    public static void init() {
        LeavesProtocol.registerFeature("mspt_sync", (player, compoundTag) -> {
            if (compoundTag.l("Value").equals("true")) {
                MsptSyncProtocol.onPlayerSubmit(player);
            } else {
                MsptSyncProtocol.onPlayerLoggedOut(player);
            }
        });
    }

    public static void onPlayerSubmit(@NotNull EntityPlayer player) {
        if (LeavesConfig.msptSyncProtocol) {
            players.add(player);
        }
    }

    public static void onPlayerLoggedOut(@NotNull EntityPlayer player) {
        if (LeavesConfig.msptSyncProtocol) {
            players.remove(player);
        }
    }

    public static void tick(MinecraftServer server) {
        if (LeavesConfig.msptSyncProtocol) {
            if (players.isEmpty()) {
                return;
            }
            if (server.ag() % LeavesConfig.msptSyncTickInterval == 0) {
                PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                double mspt = Arrays.stream(server.k).average().getAsDouble() * 1.0E-6;
                double tps = 1000.0 / Math.max(mspt, 50.0);
                buf.writeDouble(mspt);
                buf.writeDouble(tps);
                players.forEach(player -> ProtocolUtils.sendPayloadPacket(player, MSPT_SYNC, buf));
            } else if (MinecraftServer.tickStatus == TickStatus.FREEZE) {
                PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                buf.writeDouble(0.0);
                buf.writeDouble(0.0);
                players.forEach(player -> ProtocolUtils.sendPayloadPacket(player, MSPT_SYNC, buf));
            }
        }
    }
}

