/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.Feature;
import top.leavesmc.leaves.protocol.syncmatica.LocalLitematicState;
import top.leavesmc.leaves.protocol.syncmatica.MessageType;
import top.leavesmc.leaves.protocol.syncmatica.PacketType;
import top.leavesmc.leaves.protocol.syncmatica.PlayerIdentifier;
import top.leavesmc.leaves.protocol.syncmatica.PlayerIdentifierProvider;
import top.leavesmc.leaves.protocol.syncmatica.ServerPlacement;
import top.leavesmc.leaves.protocol.syncmatica.SubRegionData;
import top.leavesmc.leaves.protocol.syncmatica.SubRegionPlacementModification;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.protocol.syncmatica.exchange.DownloadExchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.Exchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ModifyExchangeServer;
import top.leavesmc.leaves.protocol.syncmatica.exchange.UploadExchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.VersionHandshakeServer;

public class CommunicationManager {
    private final Map<UUID, List<ServerPlacement>> downloadingFile = new HashMap<UUID, List<ServerPlacement>>();
    private final Map<ExchangeTarget, EntityPlayer> playerMap = new HashMap<ExchangeTarget, EntityPlayer>();
    protected final Collection<ExchangeTarget> broadcastTargets = new ArrayList<ExchangeTarget>();
    protected final Map<UUID, Boolean> downloadState = new HashMap<UUID, Boolean>();
    protected final Map<UUID, Exchange> modifyState = new HashMap<UUID, Exchange>();
    protected static final EnumBlockRotation[] rotOrdinals = EnumBlockRotation.values();
    protected static final EnumBlockMirror[] mirOrdinals = EnumBlockMirror.values();

    public GameProfile getGameProfile(ExchangeTarget exchangeTarget) {
        return this.playerMap.get(exchangeTarget).fM();
    }

    public void sendMessage(@NotNull ExchangeTarget client, MessageType type, String identifier) {
        if (client.getFeatureSet().hasFeature(Feature.MESSAGE)) {
            PacketDataSerializer newPacketBuf = new PacketDataSerializer(Unpooled.buffer());
            newPacketBuf.a(type.toString());
            newPacketBuf.a(identifier);
            client.sendPacket(PacketType.MESSAGE.identifier, newPacketBuf);
        } else if (this.playerMap.containsKey(client)) {
            EntityPlayer player = this.playerMap.get(client);
            player.a(IChatBaseComponent.b("Syncmatica " + type.toString() + " " + identifier));
        }
    }

    public void onPlayerJoin(ExchangeTarget newPlayer, EntityPlayer player) {
        VersionHandshakeServer hi = new VersionHandshakeServer(newPlayer);
        this.playerMap.put(newPlayer, player);
        GameProfile profile = player.fM();
        SyncmaticaProtocol.getPlayerIdentifierProvider().updateName(profile.getId(), profile.getName());
        this.startExchangeUnchecked(hi);
    }

    public void onPlayerLeave(@NotNull ExchangeTarget oldPlayer) {
        Collection<Exchange> potentialMessageTarget = oldPlayer.getExchanges();
        if (potentialMessageTarget != null) {
            for (Exchange target : potentialMessageTarget) {
                target.close(false);
                this.handleExchange(target);
            }
        }
        this.broadcastTargets.remove(oldPlayer);
        this.playerMap.remove(oldPlayer);
    }

    public void onPacketGet(@NotNull PacketPlayInCustomPayload packet, @NotNull PlayerConnection impl) {
        this.onPacket(impl.exchangeTarget, packet.c, packet.d);
    }

    public void onPacket(@NotNull ExchangeTarget source, MinecraftKey id, PacketDataSerializer packetBuf) {
        Exchange handler = null;
        Collection<Exchange> potentialMessageTarget = source.getExchanges();
        if (potentialMessageTarget != null) {
            for (Exchange target : potentialMessageTarget) {
                if (!target.checkPacket(id, packetBuf)) continue;
                target.handle(id, packetBuf);
                handler = target;
                break;
            }
        }
        if (handler == null) {
            this.handle(source, id, packetBuf);
        } else if (handler.isFinished()) {
            this.notifyClose(handler);
        }
    }

    protected void handle(ExchangeTarget source, @NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        UUID placementId;
        if (id.equals(PacketType.REQUEST_LITEMATIC.identifier)) {
            UploadExchange upload;
            UUID syncmaticaId = packetBuf.o();
            ServerPlacement placement = SyncmaticaProtocol.getSyncmaticManager().getPlacement(syncmaticaId);
            if (placement == null) {
                return;
            }
            File toUpload = SyncmaticaProtocol.getFileStorage().getLocalLitematic(placement);
            try {
                upload = new UploadExchange(placement, toUpload, source);
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
                return;
            }
            this.startExchange(upload);
            return;
        }
        if (id.equals(PacketType.REGISTER_METADATA.identifier)) {
            ServerPlacement placement = this.receiveMetaData(packetBuf, source);
            if (SyncmaticaProtocol.getSyncmaticManager().getPlacement(placement.getId()) != null) {
                this.cancelShare(source, placement);
                return;
            }
            GameProfile profile = this.playerMap.get(source).fM();
            PlayerIdentifier playerIdentifier = SyncmaticaProtocol.getPlayerIdentifierProvider().createOrGet(profile);
            if (!placement.getOwner().equals(playerIdentifier)) {
                placement.setOwner(playerIdentifier);
                placement.setLastModifiedBy(playerIdentifier);
            }
            if (!SyncmaticaProtocol.getFileStorage().getLocalState(placement).isLocalFileReady()) {
                if (SyncmaticaProtocol.getFileStorage().getLocalState(placement) == LocalLitematicState.DOWNLOADING_LITEMATIC) {
                    this.downloadingFile.computeIfAbsent(placement.getHash(), key -> new ArrayList()).add(placement);
                    return;
                }
                try {
                    this.download(placement, source);
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                return;
            }
            this.addPlacement(source, placement);
            return;
        }
        if (id.equals(PacketType.REMOVE_SYNCMATIC.identifier)) {
            placementId = packetBuf.o();
            ServerPlacement placement = SyncmaticaProtocol.getSyncmaticManager().getPlacement(placementId);
            if (placement != null) {
                if (!this.getGameProfile(source).getId().equals(placement.getOwner().uuid)) {
                    return;
                }
                Exchange modifier = this.getModifier(placement);
                if (modifier != null) {
                    modifier.close(true);
                    this.notifyClose(modifier);
                }
                SyncmaticaProtocol.getSyncmaticManager().removePlacement(placement);
                for (ExchangeTarget client : this.broadcastTargets) {
                    PacketDataSerializer newPacketBuf = new PacketDataSerializer(Unpooled.buffer());
                    newPacketBuf.a(placement.getId());
                    client.sendPacket(PacketType.REMOVE_SYNCMATIC.identifier, newPacketBuf);
                }
            }
        }
        if (id.equals(PacketType.MODIFY_REQUEST.identifier)) {
            placementId = packetBuf.o();
            ModifyExchangeServer modifier = new ModifyExchangeServer(placementId, source);
            this.startExchange(modifier);
        }
    }

    protected void handleExchange(Exchange exchange) {
        if (exchange instanceof DownloadExchange) {
            ServerPlacement p2 = ((DownloadExchange)exchange).getPlacement();
            if (exchange.isSuccessful()) {
                this.addPlacement(exchange.getPartner(), p2);
                if (this.downloadingFile.containsKey(p2.getHash())) {
                    for (ServerPlacement placement : this.downloadingFile.get(p2.getHash())) {
                        this.addPlacement(exchange.getPartner(), placement);
                    }
                }
            } else {
                this.cancelShare(exchange.getPartner(), p2);
                if (this.downloadingFile.containsKey(p2.getHash())) {
                    for (ServerPlacement placement : this.downloadingFile.get(p2.getHash())) {
                        this.cancelShare(exchange.getPartner(), placement);
                    }
                }
            }
            this.downloadingFile.remove(p2.getHash());
            return;
        }
        if (exchange instanceof VersionHandshakeServer && exchange.isSuccessful()) {
            this.broadcastTargets.add(exchange.getPartner());
        }
        if (exchange instanceof ModifyExchangeServer && exchange.isSuccessful()) {
            ServerPlacement placement = ((ModifyExchangeServer)exchange).getPlacement();
            for (ExchangeTarget client : this.broadcastTargets) {
                PacketDataSerializer buf;
                if (client.getFeatureSet().hasFeature(Feature.MODIFY)) {
                    buf = new PacketDataSerializer(Unpooled.buffer());
                    buf.a(placement.getId());
                    this.putPositionData(placement, buf, client);
                    if (client.getFeatureSet().hasFeature(Feature.CORE_EX)) {
                        buf.a(placement.getLastModifiedBy().uuid);
                        buf.a(placement.getLastModifiedBy().getName());
                    }
                    client.sendPacket(PacketType.MODIFY.identifier, buf);
                    continue;
                }
                buf = new PacketDataSerializer(Unpooled.buffer());
                buf.a(placement.getId());
                client.sendPacket(PacketType.REMOVE_SYNCMATIC.identifier, buf);
                PacketDataSerializer buf2 = new PacketDataSerializer(Unpooled.buffer());
                this.putMetaData(placement, buf2, client);
                client.sendPacket(PacketType.REGISTER_METADATA.identifier, buf2);
            }
        }
    }

    private void addPlacement(ExchangeTarget t2, @NotNull ServerPlacement placement) {
        if (SyncmaticaProtocol.getSyncmaticManager().getPlacement(placement.getId()) != null) {
            this.cancelShare(t2, placement);
            return;
        }
        SyncmaticaProtocol.getSyncmaticManager().addPlacement(placement);
        for (ExchangeTarget target : this.broadcastTargets) {
            this.sendMetaData(placement, target);
        }
    }

    private void cancelShare(@NotNull ExchangeTarget source, @NotNull ServerPlacement placement) {
        PacketDataSerializer FriendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        FriendlyByteBuf.a(placement.getId());
        source.sendPacket(PacketType.CANCEL_SHARE.identifier, FriendlyByteBuf);
    }

    public void sendMetaData(ServerPlacement metaData, ExchangeTarget target) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        this.putMetaData(metaData, buf, target);
        target.sendPacket(PacketType.REGISTER_METADATA.identifier, buf);
    }

    public void putMetaData(@NotNull ServerPlacement metaData, @NotNull PacketDataSerializer buf, @NotNull ExchangeTarget exchangeTarget) {
        buf.a(metaData.getId());
        buf.a(SyncmaticaProtocol.sanitizeFileName(metaData.getName()));
        buf.a(metaData.getHash());
        if (exchangeTarget.getFeatureSet().hasFeature(Feature.CORE_EX)) {
            buf.a(metaData.getOwner().uuid);
            buf.a(metaData.getOwner().getName());
            buf.a(metaData.getLastModifiedBy().uuid);
            buf.a(metaData.getLastModifiedBy().getName());
        }
        this.putPositionData(metaData, buf, exchangeTarget);
    }

    public void putPositionData(@NotNull ServerPlacement metaData, @NotNull PacketDataSerializer buf, @NotNull ExchangeTarget exchangeTarget) {
        buf.a(metaData.getPosition());
        buf.a(metaData.getDimension());
        buf.writeInt(metaData.getRotation().ordinal());
        buf.writeInt(metaData.getMirror().ordinal());
        if (exchangeTarget.getFeatureSet().hasFeature(Feature.CORE_EX)) {
            if (metaData.getSubRegionData().getModificationData() == null) {
                buf.writeInt(0);
                return;
            }
            Collection<SubRegionPlacementModification> regionData = metaData.getSubRegionData().getModificationData().values();
            buf.writeInt(regionData.size());
            for (SubRegionPlacementModification subPlacement : regionData) {
                buf.a(subPlacement.name);
                buf.a(subPlacement.position);
                buf.writeInt(subPlacement.rotation.ordinal());
                buf.writeInt(subPlacement.mirror.ordinal());
            }
        }
    }

    public ServerPlacement receiveMetaData(@NotNull PacketDataSerializer buf, @NotNull ExchangeTarget exchangeTarget) {
        UUID id = buf.o();
        String fileName = SyncmaticaProtocol.sanitizeFileName(buf.e(Short.MAX_VALUE));
        UUID hash = buf.o();
        PlayerIdentifier owner = PlayerIdentifier.MISSING_PLAYER;
        PlayerIdentifier lastModifiedBy = PlayerIdentifier.MISSING_PLAYER;
        if (exchangeTarget.getFeatureSet().hasFeature(Feature.CORE_EX)) {
            PlayerIdentifierProvider provider = SyncmaticaProtocol.getPlayerIdentifierProvider();
            owner = provider.createOrGet(buf.o(), buf.e(Short.MAX_VALUE));
            lastModifiedBy = provider.createOrGet(buf.o(), buf.e(Short.MAX_VALUE));
        }
        ServerPlacement placement = new ServerPlacement(id, fileName, hash, owner);
        placement.setLastModifiedBy(lastModifiedBy);
        this.receivePositionData(placement, buf, exchangeTarget);
        return placement;
    }

    public void receivePositionData(@NotNull ServerPlacement placement, @NotNull PacketDataSerializer buf, @NotNull ExchangeTarget exchangeTarget) {
        BlockPosition pos = buf.f();
        String dimensionId = buf.e(Short.MAX_VALUE);
        EnumBlockRotation rot = rotOrdinals[buf.readInt()];
        EnumBlockMirror mir = mirOrdinals[buf.readInt()];
        placement.move(dimensionId, pos, rot, mir);
        if (exchangeTarget.getFeatureSet().hasFeature(Feature.CORE_EX)) {
            SubRegionData subRegionData = placement.getSubRegionData();
            subRegionData.reset();
            int limit = buf.readInt();
            for (int i2 = 0; i2 < limit; ++i2) {
                subRegionData.modify(buf.e(Short.MAX_VALUE), buf.f(), rotOrdinals[buf.readInt()], mirOrdinals[buf.readInt()]);
            }
        }
    }

    public void download(ServerPlacement syncmatic, ExchangeTarget source) throws NoSuchAlgorithmException, IOException {
        if (!SyncmaticaProtocol.getFileStorage().getLocalState(syncmatic).isReadyForDownload()) {
            throw new IllegalArgumentException(syncmatic.toString() + " is not ready for download local state is: " + SyncmaticaProtocol.getFileStorage().getLocalState(syncmatic).toString());
        }
        File toDownload = SyncmaticaProtocol.getFileStorage().createLocalLitematic(syncmatic);
        DownloadExchange downloadExchange = new DownloadExchange(syncmatic, toDownload, source);
        this.setDownloadState(syncmatic, true);
        this.startExchange(downloadExchange);
    }

    public void setDownloadState(@NotNull ServerPlacement syncmatic, boolean b2) {
        this.downloadState.put(syncmatic.getHash(), b2);
    }

    public boolean getDownloadState(@NotNull ServerPlacement syncmatic) {
        return this.downloadState.getOrDefault(syncmatic.getHash(), false);
    }

    public void setModifier(@NotNull ServerPlacement syncmatic, Exchange exchange) {
        this.modifyState.put(syncmatic.getHash(), exchange);
    }

    public Exchange getModifier(@NotNull ServerPlacement syncmatic) {
        return this.modifyState.get(syncmatic.getHash());
    }

    public void startExchange(@NotNull Exchange newExchange) {
        if (!this.broadcastTargets.contains(newExchange.getPartner())) {
            throw new IllegalArgumentException(newExchange.getPartner().toString() + " is not a valid ExchangeTarget");
        }
        this.startExchangeUnchecked(newExchange);
    }

    protected void startExchangeUnchecked(@NotNull Exchange newExchange) {
        newExchange.getPartner().getExchanges().add(newExchange);
        newExchange.init();
        if (newExchange.isFinished()) {
            this.notifyClose(newExchange);
        }
    }

    public void notifyClose(@NotNull Exchange e2) {
        e2.getPartner().getExchanges().remove(e2);
        this.handleExchange(e2);
    }
}

