/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.protocol.syncmatica.Feature;

public class FeatureSet {
    private static final Map<String, FeatureSet> versionFeatures = new HashMap<String, FeatureSet>();
    private final Collection<Feature> features;

    @Nullable
    public static FeatureSet fromVersionString(@NotNull String version) {
        if (version.matches("^\\d+(\\.\\d+){2,4}$")) {
            int minSize = version.indexOf(".");
            while (version.length() > minSize) {
                if (versionFeatures.containsKey(version)) {
                    return versionFeatures.get(version);
                }
                int lastDot = version.lastIndexOf(".");
                version = version.substring(0, lastDot);
            }
        }
        return null;
    }

    @NotNull
    public static FeatureSet fromString(@NotNull String features) {
        FeatureSet featureSet = new FeatureSet(new ArrayList<Feature>());
        for (String feature : features.split("\n")) {
            Feature f2 = Feature.fromString(feature);
            if (f2 == null) continue;
            featureSet.features.add(f2);
        }
        return featureSet;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        boolean b2 = false;
        for (Feature feature : this.features) {
            output.append((String)(b2 ? "\n" + feature.toString() : feature.toString()));
            b2 = true;
        }
        return output.toString();
    }

    public FeatureSet(Collection<Feature> features) {
        this.features = features;
    }

    public boolean hasFeature(Feature f2) {
        return this.features.contains((Object)f2);
    }

    static {
        versionFeatures.put("0.1", new FeatureSet(Collections.singletonList(Feature.CORE)));
    }
}

