/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica.exchange;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.PacketType;
import top.leavesmc.leaves.protocol.syncmatica.PlayerIdentifier;
import top.leavesmc.leaves.protocol.syncmatica.ServerPlacement;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.protocol.syncmatica.exchange.AbstractExchange;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;

public class ModifyExchangeServer
extends AbstractExchange {
    private final ServerPlacement placement;
    UUID placementId;

    public ModifyExchangeServer(UUID placeId, ExchangeTarget partner) {
        super(partner);
        this.placementId = placeId;
        this.placement = SyncmaticaProtocol.getSyncmaticManager().getPlacement(this.placementId);
    }

    @Override
    public boolean checkPacket(@NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        return id.equals(PacketType.MODIFY_FINISH.identifier) && ModifyExchangeServer.checkUUID(packetBuf, this.placement.getId());
    }

    @Override
    public void handle(@NotNull MinecraftKey id, @NotNull PacketDataSerializer packetBuf) {
        packetBuf.o();
        if (id.equals(PacketType.MODIFY_FINISH.identifier)) {
            SyncmaticaProtocol.getCommunicationManager().receivePositionData(this.placement, packetBuf, this.getPartner());
            PlayerIdentifier identifier = SyncmaticaProtocol.getPlayerIdentifierProvider().createOrGet(this.getPartner());
            this.placement.setLastModifiedBy(identifier);
            SyncmaticaProtocol.getSyncmaticManager().updateServerPlacement();
            this.succeed();
        }
    }

    @Override
    public void init() {
        if (this.getPlacement() == null || SyncmaticaProtocol.getCommunicationManager().getModifier(this.placement) != null) {
            this.close(true);
        } else if (SyncmaticaProtocol.getPlayerIdentifierProvider().createOrGet((ExchangeTarget)this.getPartner()).uuid.equals(this.placement.getOwner().uuid)) {
            this.accept();
        } else {
            this.close(true);
        }
    }

    private void accept() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.placement.getId());
        this.getPartner().sendPacket(PacketType.MODIFY_REQUEST_ACCEPT.identifier, buf);
        SyncmaticaProtocol.getCommunicationManager().setModifier(this.placement, this);
    }

    @Override
    protected void sendCancelPacket() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.placementId);
        this.getPartner().sendPacket(PacketType.MODIFY_REQUEST_DENY.identifier, buf);
    }

    public ServerPlacement getPlacement() {
        return this.placement;
    }

    @Override
    protected void onClose() {
        if (SyncmaticaProtocol.getCommunicationManager().getModifier(this.placement) == this) {
            SyncmaticaProtocol.getCommunicationManager().setModifier(this.placement, null);
        }
    }
}

