/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol.syncmatica.exchange;

import io.netty.buffer.Unpooled;
import java.util.Collection;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.protocol.syncmatica.FeatureSet;
import top.leavesmc.leaves.protocol.syncmatica.PacketType;
import top.leavesmc.leaves.protocol.syncmatica.ServerPlacement;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;
import top.leavesmc.leaves.protocol.syncmatica.exchange.FeatureExchange;

public class VersionHandshakeServer
extends FeatureExchange {
    public VersionHandshakeServer(ExchangeTarget partner) {
        super(partner);
    }

    @Override
    public boolean checkPacket(@NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        return id.equals(PacketType.REGISTER_VERSION.identifier) || super.checkPacket(id, packetBuf);
    }

    @Override
    public void handle(@NotNull MinecraftKey id, PacketDataSerializer packetBuf) {
        if (id.equals(PacketType.REGISTER_VERSION.identifier)) {
            String partnerVersion = packetBuf.e(Short.MAX_VALUE);
            if (partnerVersion.equals("0.0.1")) {
                this.close(false);
                return;
            }
            FeatureSet fs = FeatureSet.fromVersionString(partnerVersion);
            if (fs == null) {
                this.requestFeatureSet();
            } else {
                this.getPartner().setFeatureSet(fs);
                this.onFeatureSetReceive();
            }
        } else {
            super.handle(id, packetBuf);
        }
    }

    @Override
    public void onFeatureSetReceive() {
        PacketDataSerializer newBuf = new PacketDataSerializer(Unpooled.buffer());
        Collection<ServerPlacement> l2 = SyncmaticaProtocol.getSyncmaticManager().getAll();
        newBuf.writeInt(l2.size());
        for (ServerPlacement p2 : l2) {
            this.getManager().putMetaData(p2, newBuf, this.getPartner());
        }
        this.getPartner().sendPacket(PacketType.CONFIRM_USER.identifier, newBuf);
        this.succeed();
    }

    @Override
    public void init() {
        PacketDataSerializer newBuf = new PacketDataSerializer(Unpooled.buffer());
        newBuf.a("0.3.8");
        this.getPartner().sendPacket(PacketType.REGISTER_VERSION.identifier, newBuf);
    }
}

