/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.replay;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.SharedConstants;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.replay.RecordMetaData;
import top.leavesmc.leaves.replay.RecorderOption;
import top.leavesmc.leaves.replay.ReplayFile;
import top.leavesmc.leaves.replay.ServerPhotographer;

public class Recorder
extends NetworkManager {
    private static final LeavesLogger LOGGER = LeavesLogger.LOGGER;
    private final ReplayFile replayFile;
    private final ServerPhotographer photographer;
    private final RecorderOption recorderOption;
    private final RecordMetaData metaData;
    private final ExecutorService saveService = Executors.newSingleThreadExecutor();
    private boolean stopped = false;
    private boolean paused = false;
    private boolean resumeOnNextPacket = true;
    private long startTime;
    private long lastPacket;
    private long timeShift = 0L;
    private boolean isSaved;
    private boolean isSaving;
    private EnumProtocol state = EnumProtocol.d;

    public Recorder(ServerPhotographer photographer, RecorderOption recorderOption, File replayFile) throws IOException {
        super(EnumProtocolDirection.b);
        this.photographer = photographer;
        this.recorderOption = recorderOption;
        this.metaData = new RecordMetaData();
        this.replayFile = new ReplayFile(replayFile);
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.metaData.singleplayer = false;
        this.metaData.serverName = this.recorderOption.serverName;
        this.metaData.generator = "leaves";
        this.metaData.date = this.startTime;
        this.metaData.mcversion = SharedConstants.b().c();
        this.savePacket(new PacketLoginOutSuccess(this.photographer.fM()));
        this.state = EnumProtocol.b;
        if (this.recorderOption.forceWeather != null) {
            this.setWeather(this.recorderOption.forceWeather);
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public void pauseRecording() {
        this.resumeOnNextPacket = false;
        this.paused = true;
    }

    public void resumeRecording() {
        this.resumeOnNextPacket = true;
    }

    public void setWeather(RecorderOption.RecordWeather weather) {
        weather.getPackets().forEach(this::savePacket);
    }

    public long getRecordedTime() {
        long base = System.currentTimeMillis() - this.startTime;
        return base - this.timeShift;
    }

    private synchronized long getCurrentTimeAndUpdate() {
        long now = this.getRecordedTime();
        if (this.paused) {
            if (this.resumeOnNextPacket) {
                this.paused = false;
            }
            this.timeShift += now - this.lastPacket;
            return this.lastPacket;
        }
        this.lastPacket = now;
        return this.lastPacket;
    }

    @Override
    public boolean h() {
        return true;
    }

    @Override
    public void a(@NotNull Packet<?> packet, @Nullable PacketSendListener callbacks) {
        if (!this.stopped) {
            PacketPlayOutGameStateChange.a type;
            Packet<PacketListenerPlayOut> packet1;
            if (packet instanceof ClientboundBundlePacket) {
                packet1 = (ClientboundBundlePacket)((Object)packet);
                ((BundlePacket)packet1).a().forEach(subPacket -> this.a((Packet<?>)subPacket, null));
            }
            if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                packet1 = (PacketPlayOutNamedEntitySpawn)((Object)packet);
                this.metaData.players.add(((PacketPlayOutNamedEntitySpawn)packet1).c());
                this.saveMetadata();
            }
            if (packet instanceof PacketPlayOutKickDisconnect) {
                return;
            }
            if (this.recorderOption.forceDayTime != -1 && packet instanceof PacketPlayOutUpdateTime) {
                packet1 = packet;
                packet = new PacketPlayOutUpdateTime(((PacketPlayOutUpdateTime)packet1).c(), this.recorderOption.forceDayTime, false);
            }
            if (this.recorderOption.forceWeather != null && packet instanceof PacketPlayOutGameStateChange && ((type = ((PacketPlayOutGameStateChange)(packet1 = (PacketPlayOutGameStateChange)((Object)packet))).a()) == PacketPlayOutGameStateChange.b || type == PacketPlayOutGameStateChange.c || type == PacketPlayOutGameStateChange.h || type == PacketPlayOutGameStateChange.i)) {
                return;
            }
            if (this.recorderOption.ignoreChat && (packet instanceof ClientboundSystemChatPacket || packet instanceof ClientboundPlayerChatPacket)) {
                return;
            }
            this.savePacket(packet);
        }
    }

    private void saveMetadata() {
        this.saveService.submit(() -> {
            try {
                this.replayFile.saveMetaData(this.metaData);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
    }

    private void savePacket(Packet<?> packet) {
        try {
            long timestamp = this.getCurrentTimeAndUpdate();
            boolean login = this.state == EnumProtocol.d;
            this.saveService.submit(() -> {
                try {
                    this.replayFile.savePacket(timestamp, packet, login);
                }
                catch (Exception e2) {
                    LOGGER.severe("Error saving packet");
                    e2.printStackTrace();
                }
            });
        }
        catch (Exception e2) {
            LOGGER.severe("Error saving packet");
            e2.printStackTrace();
        }
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public CompletableFuture<Void> saveRecording(File dest) {
        this.isSaved = true;
        if (!this.isSaving) {
            this.isSaving = true;
            this.metaData.duration = (int)this.lastPacket;
            return CompletableFuture.runAsync(() -> {
                this.saveMetadata();
                this.saveService.shutdown();
                boolean interrupted = false;
                try {
                    this.saveService.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e2) {
                    interrupted = true;
                }
                try {
                    this.replayFile.closeAndSave(dest);
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    throw new CompletionException(e3);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }, runnable -> {
                Thread thread = new Thread(runnable, "Recording file save thread");
                thread.start();
            });
        }
        LOGGER.warning("saveRecording() called twice");
        return CompletableFuture.supplyAsync(() -> {
            throw new IllegalStateException("saveRecording() called twice");
        });
    }
}

