/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.structs;

import it.unimi.dsi.fastutil.HashCommon;

public class Long2FloatAgingCache {
    private final AgingEntry[] entries;
    private final int mask;
    private final int maxDistance;

    public Long2FloatAgingCache(int size) {
        int arraySize = HashCommon.nextPowerOfTwo((int)size);
        this.entries = new AgingEntry[arraySize];
        this.mask = arraySize - 1;
        this.maxDistance = Math.min(arraySize, 4);
    }

    public float getValue(long data) {
        int pos = HashCommon.mix((int)HashCommon.long2int((long)data)) & this.mask;
        AgingEntry curr = this.entries[pos];
        if (curr == null) {
            return Float.NaN;
        }
        if (data == curr.data) {
            curr.incrementUses();
            return curr.value;
        }
        int checked = 1;
        while ((curr = this.entries[pos = pos + 1 & this.mask]) != null) {
            if (data == curr.data) {
                curr.incrementUses();
                return curr.value;
            }
            if (++checked < this.maxDistance) continue;
            break;
        }
        return Float.NaN;
    }

    public void putValue(long data, float value) {
        int pos = HashCommon.mix((int)HashCommon.long2int((long)data)) & this.mask;
        AgingEntry curr = this.entries[pos];
        if (curr == null) {
            this.entries[pos] = new AgingEntry(data, value);
            return;
        }
        if (data == curr.data) {
            curr.incrementUses();
            return;
        }
        int checked = 1;
        while ((curr = this.entries[pos = pos + 1 & this.mask]) != null) {
            if (data == curr.data) {
                curr.incrementUses();
                return;
            }
            if (++checked < this.maxDistance) continue;
            this.forceAdd(data, value);
            return;
        }
        this.entries[pos] = new AgingEntry(data, value);
    }

    private void forceAdd(long data, float value) {
        int expectedPos = HashCommon.mix((int)HashCommon.long2int((long)data)) & this.mask;
        AgingEntry entryToRemove = this.entries[expectedPos];
        for (int i2 = expectedPos + 1; i2 < expectedPos + this.maxDistance; ++i2) {
            int pos = i2 & this.mask;
            AgingEntry entry = this.entries[pos];
            if (entry.getValue() < entryToRemove.getValue()) {
                entryToRemove = entry;
            }
            entry.incrementAge();
        }
        entryToRemove.replace(data, value);
    }

    private static class AgingEntry {
        private long data;
        private float value;
        private int uses = 0;
        private int age = 0;

        private AgingEntry(long data, float value) {
            this.data = data;
            this.value = value;
        }

        public void replace(long data, float flag) {
            this.data = data;
            this.value = flag;
        }

        public int getValue() {
            return this.uses - (this.age >> 1);
        }

        public void incrementUses() {
            this.uses = this.uses + 1 & Integer.MAX_VALUE;
        }

        public void incrementAge() {
            this.age = this.age + 1 & Integer.MAX_VALUE;
        }
    }
}

