/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.LocalTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.SystemUtils;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.LeavesLogger;

public class LeavesUpdateHelper {
    private static final String autoUpdateDir = "auto_update";
    private static final String corePathFileName = "auto_update" + File.separator + "core.path";
    private static final ReentrantLock updateLock = new ReentrantLock();
    private static boolean updateTaskStarted = false;
    private static final ScheduledExecutorService autoUpdateExecutor = Executors.newScheduledThreadPool(1);

    public static void init() {
        File leavesUpdateDir;
        File corePathFile;
        File workingDirFile = new File(autoUpdateDir);
        if (!workingDirFile.exists()) {
            workingDirFile.mkdir();
        }
        if (!(corePathFile = new File(corePathFileName)).exists()) {
            try {
                corePathFile.createNewFile();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (!(leavesUpdateDir = new File(autoUpdateDir + File.separator + "leaves")).exists()) {
            leavesUpdateDir.mkdir();
        }
        if (LeavesConfig.autoUpdate) {
            LocalTime currentTime = LocalTime.now();
            long dailyTaskPeriod = 86400000L;
            for (String time : LeavesConfig.autoUpdateTime) {
                try {
                    LocalTime taskTime = LocalTime.of(Integer.parseInt(time.split(":")[0]), Integer.parseInt(time.split(":")[1]));
                    Duration task = Duration.between(currentTime, taskTime);
                    if (task.isNegative()) {
                        task = task.plusDays(1L);
                    }
                    autoUpdateExecutor.scheduleAtFixedRate(LeavesUpdateHelper::tryUpdateLeaves, task.toMillis(), dailyTaskPeriod, TimeUnit.MILLISECONDS);
                }
                catch (Exception ignored) {
                    LeavesLogger.LOGGER.warning("Illegal auto-update time ignored: " + time);
                }
            }
        }
    }

    public static void tryUpdateLeaves() {
        updateLock.lock();
        try {
            if (!updateTaskStarted) {
                updateTaskStarted = true;
                new Thread(LeavesUpdateHelper::downloadLeaves).start();
            }
        }
        finally {
            updateLock.unlock();
        }
    }

    private static void downloadLeaves() {
        String minecraftVersion = Bukkit.getMinecraftVersion();
        String version = Bukkit.getVersion();
        if (version.startsWith("null")) {
            LeavesLogger.LOGGER.info("IDE? Can not update!");
            updateTaskStarted = false;
            return;
        }
        String gitHash = version.substring("git-Leaves-".length()).split("[-\\s]")[0].replaceAll("\"", "");
        LeavesLogger.LOGGER.info("Trying to get latest build info.");
        LeavesBuildInfo buildInfo = LeavesUpdateHelper.getLatestBuildInfo(minecraftVersion, gitHash);
        if (buildInfo != LeavesBuildInfo.NULL) {
            if (!buildInfo.needUpdate) {
                LeavesLogger.LOGGER.warning("You are running the latest version, stopping update.");
                updateTaskStarted = false;
                return;
            }
            LeavesLogger.LOGGER.info("Got build info, trying to download " + buildInfo.fileName);
            try {
                Path outFile = Path.of(autoUpdateDir, "leaves", buildInfo.fileName + ".cache");
                Files.deleteIfExists(outFile);
                boolean downloadFlag = false;
                URL cdnUrl = new URL(buildInfo.cdnUrl);
                try (ReadableByteChannel source = Channels.newChannel(cdnUrl.openStream());
                     FileChannel fileChannel = FileChannel.open(outFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                    fileChannel.transferFrom(source, 0L, Long.MAX_VALUE);
                    downloadFlag = true;
                }
                catch (IOException e2) {
                    Files.deleteIfExists(outFile);
                }
                if (!downloadFlag) {
                    URL githubUrl = new URL(buildInfo.githubUrl);
                    try (ReadableByteChannel source = Channels.newChannel(githubUrl.openStream());
                         FileChannel fileChannel = FileChannel.open(outFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                        fileChannel.transferFrom(source, 0L, Long.MAX_VALUE);
                    }
                    catch (IOException e3) {
                        LeavesLogger.LOGGER.warning("Download " + buildInfo.fileName + " failed.");
                        Files.deleteIfExists(outFile);
                        updateTaskStarted = false;
                        e3.printStackTrace();
                        return;
                    }
                }
                LeavesLogger.LOGGER.info("Download " + buildInfo.fileName + " completed.");
                if (!LeavesUpdateHelper.isFileValid(outFile, buildInfo.sha256)) {
                    LeavesLogger.LOGGER.warning("Hash check failed for downloaded file " + buildInfo.fileName);
                    Files.deleteIfExists(outFile);
                    updateTaskStarted = false;
                    return;
                }
                File nowServerCore = new File(autoUpdateDir + File.separator + "leaves" + File.separator + buildInfo.fileName);
                File backupServerCore = new File(autoUpdateDir + File.separator + "leaves" + File.separator + buildInfo.fileName + ".old");
                SystemUtils.a(nowServerCore, outFile.toFile(), backupServerCore);
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(corePathFileName));){
                    bufferedWriter.write(autoUpdateDir + File.separator + "leaves" + File.separator + "leaves-1.20.1.jar");
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                    updateTaskStarted = false;
                    return;
                }
                LeavesLogger.LOGGER.info("Leaves update completed, please restart your server.");
            }
            catch (Exception e5) {
                e5.printStackTrace();
            }
        } else {
            LeavesLogger.LOGGER.warning("Can't get build info, stopping update.");
        }
        updateTaskStarted = false;
    }

    private static boolean isFileValid(Path file, String hash) {
        boolean bl;
        FileInputStream inputStream = new FileInputStream(file.toFile());
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest md5 = MessageDigest.getInstance("SHA-256");
            while ((numRead = inputStream.read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
            bl = LeavesUpdateHelper.toHexString(md5.digest()).equals(hash);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return false;
            }
        }
        inputStream.close();
        return bl;
    }

    @NotNull
    private static String toHexString(byte @NotNull [] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b2 : bytes) {
            builder.append(String.format("%02x", b2));
        }
        return builder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LeavesBuildInfo getLatestBuildInfo(String mcVersion, String gitHash) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.leavesmc.top/projects/leaves/versions/" + mcVersion + "/builds/latest").openConnection();
            connection.connect();
            if (connection.getResponseCode() == 404) {
                return LeavesBuildInfo.NULL;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));){
                JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                String channel = obj.get("channel").getAsString();
                if (channel.equals("default")) {
                    int build = obj.get("build").getAsInt();
                    JsonArray changes = obj.get("changes").getAsJsonArray();
                    boolean needUpdate = true;
                    for (JsonElement change : changes) {
                        if (!change.getAsJsonObject().get("commit").getAsString().startsWith(gitHash)) continue;
                        needUpdate = false;
                        break;
                    }
                    JsonObject downloadInfo = obj.get("downloads").getAsJsonObject().get("application").getAsJsonObject();
                    String name = downloadInfo.get("name").getAsString();
                    String sha256 = downloadInfo.get("sha256").getAsString();
                    String githubUrl = downloadInfo.get("url").getAsString();
                    String cdnUrl = downloadInfo.get("cdn_url").getAsString();
                    LeavesBuildInfo leavesBuildInfo = new LeavesBuildInfo(build, name, sha256, needUpdate, cdnUrl, githubUrl);
                    return leavesBuildInfo;
                }
                LeavesBuildInfo leavesBuildInfo = LeavesBuildInfo.NULL;
                return leavesBuildInfo;
            }
            catch (JsonSyntaxException | NumberFormatException e2) {
                e2.printStackTrace();
                return LeavesBuildInfo.NULL;
            }
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return LeavesBuildInfo.NULL;
        }
    }

    private record LeavesBuildInfo(int build, String fileName, String sha256, boolean needUpdate, String cdnUrl, String githubUrl) {
        public static LeavesBuildInfo NULL = new LeavesBuildInfo(-1, null, null, false, null, null);
    }
}

