/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockShulkerBox;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;

public class ShulkerBoxUtils {
    public static final int TAG_END = 0;
    public static final int TAG_BYTE = 1;
    public static final int TAG_SHORT = 2;
    public static final int TAG_INT = 3;
    public static final int TAG_LONG = 4;
    public static final int TAG_FLOAT = 5;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_BYTEARRAY = 7;
    public static final int TAG_STRING = 8;
    public static final int TAG_LIST = 9;
    public static final int TAG_COMPOUND = 10;
    public static final int TAG_INTARRAY = 11;
    public static final int TAG_LONGARRAY = 12;

    public static boolean cleanUpShulkerBoxTag(@NotNull ItemStack stack) {
        boolean changed = false;
        NBTTagCompound tag = stack.v();
        if (tag == null || !tag.b("BlockEntityTag", 10)) {
            return false;
        }
        NBTTagCompound bet = tag.p("BlockEntityTag");
        if (bet.b("Items", 9) && bet.c("Items", 10).isEmpty()) {
            bet.r("Items");
            changed = true;
        }
        if (bet.g() || bet.f() == 1 && bet.l("id").equals("minecraft:shulker_box")) {
            tag.r("BlockEntityTag");
            changed = true;
        }
        if (tag.g()) {
            stack.c((NBTTagCompound)null);
            changed = true;
        }
        return changed;
    }

    public static boolean shulkerBoxHasItems(@NotNull ItemStack stack) {
        NBTTagCompound tag = stack.v();
        if (tag == null || !tag.b("BlockEntityTag", 10)) {
            return false;
        }
        NBTTagCompound bet = tag.p("BlockEntityTag");
        return bet.b("Items", 9) && !bet.c("Items", 10).isEmpty();
    }

    public static int getItemStackMaxCount(ItemStack stack) {
        ItemBlock bi;
        Item item;
        if (LeavesConfig.shulkerBoxStackSize > 1 && (item = stack.d()) instanceof ItemBlock && (bi = (ItemBlock)item).e() instanceof BlockShulkerBox && !ShulkerBoxUtils.shulkerBoxHasItems(stack)) {
            return LeavesConfig.shulkerBoxStackSize;
        }
        return stack.g();
    }

    public static boolean isStackable(ItemStack itemStack) {
        return ShulkerBoxUtils.getItemStackMaxCount(itemStack) > 1 && (!itemStack.i() || !itemStack.j());
    }
}

