/*
 * Decompiled with CFR 0.152.
 */
package leavesclip.libs.io.sigpipe.jbsdiff.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import leavesclip.libs.io.sigpipe.jbsdiff.DefaultDiffSettings;
import leavesclip.libs.io.sigpipe.jbsdiff.Diff;
import leavesclip.libs.io.sigpipe.jbsdiff.InvalidHeaderException;
import leavesclip.libs.io.sigpipe.jbsdiff.Patch;
import leavesclip.libs.org.apache.commons.compress.compressors.CompressorException;

public class FileUI {
    public static void diff(File oldFile, File newFile, File patchFile) throws CompressorException, FileNotFoundException, InvalidHeaderException, IOException {
        FileUI.diff(oldFile, newFile, patchFile, "bzip2");
    }

    public static void diff(File oldFile, File newFile, File patchFile, String compression) throws CompressorException, FileNotFoundException, InvalidHeaderException, IOException {
        FileInputStream oldIn = new FileInputStream(oldFile);
        byte[] oldBytes = new byte[(int)oldFile.length()];
        oldIn.read(oldBytes);
        oldIn.close();
        FileInputStream newIn = new FileInputStream(newFile);
        byte[] newBytes = new byte[(int)newFile.length()];
        newIn.read(newBytes);
        newIn.close();
        FileOutputStream out = new FileOutputStream(patchFile);
        DefaultDiffSettings settings = new DefaultDiffSettings(compression);
        Diff.diff(oldBytes, newBytes, out, settings);
        out.close();
    }

    public static void patch(File oldFile, File newFile, File patchFile) throws CompressorException, FileNotFoundException, InvalidHeaderException, IOException {
        FileInputStream oldIn = new FileInputStream(oldFile);
        byte[] oldBytes = new byte[(int)oldFile.length()];
        oldIn.read(oldBytes);
        oldIn.close();
        FileInputStream patchIn = new FileInputStream(patchFile);
        byte[] patchBytes = new byte[(int)patchFile.length()];
        patchIn.read(patchBytes);
        patchIn.close();
        FileOutputStream out = new FileOutputStream(newFile);
        Patch.patch(oldBytes, patchBytes, out);
        out.close();
    }
}

