/*
 * Decompiled with CFR 0.152.
 */
package leavesclip.libs.org.tukaani.xz;

import java.io.IOException;
import java.io.InputStream;
import leavesclip.libs.org.tukaani.xz.FilterEncoder;
import leavesclip.libs.org.tukaani.xz.FilterOptions;
import leavesclip.libs.org.tukaani.xz.FinishableOutputStream;
import leavesclip.libs.org.tukaani.xz.LZMA2Encoder;
import leavesclip.libs.org.tukaani.xz.LZMA2InputStream;
import leavesclip.libs.org.tukaani.xz.LZMA2OutputStream;
import leavesclip.libs.org.tukaani.xz.UncompressedLZMA2OutputStream;
import leavesclip.libs.org.tukaani.xz.UnsupportedOptionsException;

public class LZMA2Options
extends FilterOptions {
    public static final int PRESET_MIN = 0;
    public static final int PRESET_MAX = 9;
    public static final int PRESET_DEFAULT = 6;
    public static final int DICT_SIZE_MIN = 4096;
    public static final int DICT_SIZE_MAX = 0x30000000;
    public static final int DICT_SIZE_DEFAULT = 0x800000;
    public static final int LC_LP_MAX = 4;
    public static final int LC_DEFAULT = 3;
    public static final int LP_DEFAULT = 0;
    public static final int PB_MAX = 4;
    public static final int PB_DEFAULT = 2;
    public static final int MODE_UNCOMPRESSED = 0;
    public static final int MODE_FAST = 1;
    public static final int MODE_NORMAL = 2;
    public static final int NICE_LEN_MIN = 8;
    public static final int NICE_LEN_MAX = 273;
    public static final int MF_HC4 = 4;
    public static final int MF_BT4 = 20;
    private static final int[] presetToDictSize;
    private static final int[] presetToDepthLimit;
    private int dictSize;
    private byte[] presetDict = null;
    private int lc;
    private int lp;
    private int pb;
    private int mode;
    private int niceLen;
    private int mf;
    private int depthLimit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LZMA2Options() {
        try {
            this.setPreset(6);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException();
        }
    }

    public LZMA2Options(int n) throws UnsupportedOptionsException {
        this.setPreset(n);
    }

    public LZMA2Options(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws UnsupportedOptionsException {
        this.setDictSize(n);
        this.setLcLp(n2, n3);
        this.setPb(n4);
        this.setMode(n5);
        this.setNiceLen(n6);
        this.setMatchFinder(n7);
        this.setDepthLimit(n8);
    }

    public void setPreset(int n) throws UnsupportedOptionsException {
        if (n < 0 || n > 9) {
            throw new UnsupportedOptionsException("Unsupported preset: " + n);
        }
        this.lc = 3;
        this.lp = 0;
        this.pb = 2;
        this.dictSize = presetToDictSize[n];
        if (n <= 3) {
            this.mode = 1;
            this.mf = 4;
            this.niceLen = n <= 1 ? 128 : 273;
            this.depthLimit = presetToDepthLimit[n];
        } else {
            this.mode = 2;
            this.mf = 20;
            this.niceLen = n == 4 ? 16 : (n == 5 ? 32 : 64);
            this.depthLimit = 0;
        }
    }

    public void setDictSize(int n) throws UnsupportedOptionsException {
        if (n < 4096) {
            throw new UnsupportedOptionsException("LZMA2 dictionary size must be at least 4 KiB: " + n + " B");
        }
        if (n > 0x30000000) {
            throw new UnsupportedOptionsException("LZMA2 dictionary size must not exceed 768 MiB: " + n + " B");
        }
        this.dictSize = n;
    }

    public int getDictSize() {
        return this.dictSize;
    }

    public void setPresetDict(byte[] byArray) {
        this.presetDict = byArray;
    }

    public byte[] getPresetDict() {
        return this.presetDict;
    }

    public void setLcLp(int n, int n2) throws UnsupportedOptionsException {
        if (n < 0 || n2 < 0 || n > 4 || n2 > 4 || n + n2 > 4) {
            throw new UnsupportedOptionsException("lc + lp must not exceed 4: " + n + " + " + n2);
        }
        this.lc = n;
        this.lp = n2;
    }

    public void setLc(int n) throws UnsupportedOptionsException {
        this.setLcLp(n, this.lp);
    }

    public void setLp(int n) throws UnsupportedOptionsException {
        this.setLcLp(this.lc, n);
    }

    public int getLc() {
        return this.lc;
    }

    public int getLp() {
        return this.lp;
    }

    public void setPb(int n) throws UnsupportedOptionsException {
        if (n < 0 || n > 4) {
            throw new UnsupportedOptionsException("pb must not exceed 4: " + n);
        }
        this.pb = n;
    }

    public int getPb() {
        return this.pb;
    }

    public void setMode(int n) throws UnsupportedOptionsException {
        if (n < 0 || n > 2) {
            throw new UnsupportedOptionsException("Unsupported compression mode: " + n);
        }
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setNiceLen(int n) throws UnsupportedOptionsException {
        if (n < 8) {
            throw new UnsupportedOptionsException("Minimum nice length of matches is 8 bytes: " + n);
        }
        if (n > 273) {
            throw new UnsupportedOptionsException("Maximum nice length of matches is 273: " + n);
        }
        this.niceLen = n;
    }

    public int getNiceLen() {
        return this.niceLen;
    }

    public void setMatchFinder(int n) throws UnsupportedOptionsException {
        if (n != 4 && n != 20) {
            throw new UnsupportedOptionsException("Unsupported match finder: " + n);
        }
        this.mf = n;
    }

    public int getMatchFinder() {
        return this.mf;
    }

    public void setDepthLimit(int n) throws UnsupportedOptionsException {
        if (n < 0) {
            throw new UnsupportedOptionsException("Depth limit cannot be negative: " + n);
        }
        this.depthLimit = n;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public int getEncoderMemoryUsage() {
        return this.mode == 0 ? UncompressedLZMA2OutputStream.getMemoryUsage() : LZMA2OutputStream.getMemoryUsage(this);
    }

    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream) {
        if (this.mode == 0) {
            return new UncompressedLZMA2OutputStream(finishableOutputStream);
        }
        return new LZMA2OutputStream(finishableOutputStream, this);
    }

    public int getDecoderMemoryUsage() {
        int n = this.dictSize - 1;
        n |= n >>> 2;
        n |= n >>> 3;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return LZMA2InputStream.getMemoryUsage(n + 1);
    }

    public InputStream getInputStream(InputStream inputStream) throws IOException {
        return new LZMA2InputStream(inputStream, this.dictSize);
    }

    FilterEncoder getFilterEncoder() {
        return new LZMA2Encoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException();
        }
    }

    static {
        $assertionsDisabled = !LZMA2Options.class.desiredAssertionStatus();
        presetToDictSize = new int[]{262144, 0x100000, 0x200000, 0x400000, 0x400000, 0x800000, 0x800000, 0x1000000, 0x2000000, 0x4000000};
        presetToDepthLimit = new int[]{4, 8, 24, 48};
    }
}

