/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.entity;

import com.google.common.base.Preconditions;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Warden;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class WardenAngerChangeEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Entity target;
    private final int oldAnger;
    private int newAnger;
    private boolean cancelled;

    @ApiStatus.Internal
    public WardenAngerChangeEvent(@NotNull Warden warden, @NotNull Entity target, int oldAnger, int newAnger) {
        super(warden);
        this.target = target;
        this.oldAnger = oldAnger;
        this.newAnger = newAnger;
    }

    @NotNull
    public Entity getTarget() {
        return this.target;
    }

    public @Range(from=0L, to=150L) int getOldAnger() {
        return this.oldAnger;
    }

    public @Range(from=0L, to=150L) int getNewAnger() {
        return this.newAnger;
    }

    public void setNewAnger(@Range(from=0L, to=150L) int newAnger) {
        Preconditions.checkArgument((newAnger <= 150 ? 1 : 0) != 0, (Object)"newAnger must not be greater than 150");
        this.newAnger = newAnger;
    }

    @Override
    @NotNull
    public Warden getEntity() {
        return (Warden)super.getEntity();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

