/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.destroystokyo.paper.entity.ai.MobGoals;
import io.papermc.paper.ban.BanListType;
import io.papermc.paper.datapack.DatapackManager;
import io.papermc.paper.math.Position;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.BanList;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.ServerTickManager;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemCraftResult;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.packs.DataPackManager;
import org.bukkit.packs.ResourcePack;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageRecipient;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.CachedServerIcon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.leavesmc.leaves.packet.bytebuf.Bytebuf;
import top.leavesmc.leaves.entity.BotManager;
import top.leavesmc.leaves.entity.PhotographerManager;

public interface Server
extends PluginMessageRecipient,
ForwardingAudience {
    public static final String BROADCAST_CHANNEL_ADMINISTRATIVE = "bukkit.broadcast.admin";
    public static final String BROADCAST_CHANNEL_USERS = "bukkit.broadcast.user";

    @NotNull
    public File getPluginsFolder();

    @NotNull
    public String getName();

    @NotNull
    public String getVersion();

    @NotNull
    public String getBukkitVersion();

    @NotNull
    public String getMinecraftVersion();

    @NotNull
    public Collection<? extends Player> getOnlinePlayers();

    public int getMaxPlayers();

    public void setMaxPlayers(int var1);

    public int getPort();

    public int getViewDistance();

    public int getSimulationDistance();

    @NotNull
    public String getIp();

    @NotNull
    public String getWorldType();

    public boolean getGenerateStructures();

    public int getMaxWorldSize();

    public boolean getAllowEnd();

    public boolean getAllowNether();

    public boolean isLoggingIPs();

    @NotNull
    public List<String> getInitialEnabledPacks();

    @NotNull
    public List<String> getInitialDisabledPacks();

    @Deprecated(forRemoval=true)
    @NotNull
    public DataPackManager getDataPackManager();

    @NotNull
    public ServerTickManager getServerTickManager();

    @Nullable
    public ResourcePack getServerResourcePack();

    @NotNull
    public String getResourcePack();

    @NotNull
    public String getResourcePackHash();

    @NotNull
    public String getResourcePackPrompt();

    public boolean isResourcePackRequired();

    public boolean hasWhitelist();

    public void setWhitelist(boolean var1);

    public boolean isWhitelistEnforced();

    public void setWhitelistEnforced(boolean var1);

    @NotNull
    public Set<OfflinePlayer> getWhitelistedPlayers();

    public void reloadWhitelist();

    @Deprecated
    public int broadcastMessage(@NotNull String var1);

    @Deprecated
    default public void broadcast(@NotNull BaseComponent component) {
        this.spigot().broadcast(component);
    }

    @Deprecated
    default public void broadcast(BaseComponent ... components) {
        this.spigot().broadcast(components);
    }

    @NotNull
    public String getUpdateFolder();

    @NotNull
    public File getUpdateFolderFile();

    public long getConnectionThrottle();

    @Deprecated
    public int getTicksPerAnimalSpawns();

    @Deprecated
    public int getTicksPerMonsterSpawns();

    @Deprecated
    public int getTicksPerWaterSpawns();

    @Deprecated
    public int getTicksPerWaterAmbientSpawns();

    @Deprecated
    public int getTicksPerWaterUndergroundCreatureSpawns();

    @Deprecated
    public int getTicksPerAmbientSpawns();

    public int getTicksPerSpawns(@NotNull SpawnCategory var1);

    @Nullable
    public Player getPlayer(@NotNull String var1);

    @Nullable
    public Player getPlayerExact(@NotNull String var1);

    @NotNull
    public List<Player> matchPlayer(@NotNull String var1);

    @Nullable
    public Player getPlayer(@NotNull UUID var1);

    @Nullable
    public UUID getPlayerUniqueId(@NotNull String var1);

    @NotNull
    public PluginManager getPluginManager();

    @NotNull
    public BukkitScheduler getScheduler();

    @NotNull
    public ServicesManager getServicesManager();

    @NotNull
    public List<World> getWorlds();

    public boolean isTickingWorlds();

    @Nullable
    public World createWorld(@NotNull WorldCreator var1);

    public boolean unloadWorld(@NotNull String var1, boolean var2);

    public boolean unloadWorld(@NotNull World var1, boolean var2);

    @Nullable
    public World getWorld(@NotNull String var1);

    @Nullable
    public World getWorld(@NotNull UUID var1);

    @Nullable
    public World getWorld(@NotNull NamespacedKey var1);

    @NotNull
    public WorldBorder createWorldBorder();

    @Nullable
    public MapView getMap(int var1);

    @NotNull
    public MapView createMap(@NotNull World var1);

    @Deprecated
    @NotNull
    public ItemStack createExplorerMap(@NotNull World var1, @NotNull Location var2, @NotNull org.bukkit.StructureType var3);

    @Deprecated
    @NotNull
    public ItemStack createExplorerMap(@NotNull World var1, @NotNull Location var2, @NotNull org.bukkit.StructureType var3, int var4, boolean var5);

    @Nullable
    default public ItemStack createExplorerMap(@NotNull World world, @NotNull Location location, @NotNull StructureType structureType, @NotNull MapCursor.Type mapIcon) {
        return this.createExplorerMap(world, location, structureType, mapIcon, 100, true);
    }

    @Nullable
    public ItemStack createExplorerMap(@NotNull World var1, @NotNull Location var2, @NotNull StructureType var3, @NotNull MapCursor.Type var4, int var5, boolean var6);

    public void reload();

    public void reloadData();

    public void updateResources();

    public void updateRecipes();

    @NotNull
    @ApiStatus.Internal
    public Logger getLogger();

    @Nullable
    public PluginCommand getPluginCommand(@NotNull String var1);

    public void savePlayers();

    public boolean dispatchCommand(@NotNull CommandSender var1, @NotNull String var2) throws CommandException;

    @Contract(value="null -> false")
    public boolean addRecipe(@Nullable Recipe var1);

    @Contract(value="null, _ -> false")
    public boolean addRecipe(@Nullable Recipe var1, boolean var2);

    @NotNull
    public List<Recipe> getRecipesFor(@NotNull ItemStack var1);

    @Nullable
    public Recipe getRecipe(@NotNull NamespacedKey var1);

    @Nullable
    public Recipe getCraftingRecipe(@NotNull ItemStack[] var1, @NotNull World var2);

    @NotNull
    public ItemStack craftItem(@NotNull ItemStack[] var1, @NotNull World var2, @NotNull Player var3);

    @NotNull
    public ItemStack craftItem(@NotNull ItemStack[] var1, @NotNull World var2);

    @NotNull
    public ItemCraftResult craftItemResult(@NotNull ItemStack[] var1, @NotNull World var2, @NotNull Player var3);

    @NotNull
    public ItemCraftResult craftItemResult(@NotNull ItemStack[] var1, @NotNull World var2);

    @NotNull
    public Iterator<Recipe> recipeIterator();

    public void clearRecipes();

    public void resetRecipes();

    public boolean removeRecipe(@NotNull NamespacedKey var1);

    public boolean removeRecipe(@NotNull NamespacedKey var1, boolean var2);

    @NotNull
    public Map<String, String[]> getCommandAliases();

    public int getSpawnRadius();

    public void setSpawnRadius(int var1);

    @Deprecated
    public boolean shouldSendChatPreviews();

    public boolean isEnforcingSecureProfiles();

    public boolean getHideOnlinePlayers();

    public boolean getOnlineMode();

    public boolean getAllowFlight();

    public boolean isHardcore();

    public void shutdown();

    @Deprecated
    public int broadcast(@NotNull String var1, @NotNull String var2);

    public int broadcast(@NotNull Component var1);

    public int broadcast(@NotNull Component var1, @NotNull String var2);

    @NotNull
    public OfflinePlayer getOfflinePlayer(@NotNull String var1);

    @Nullable
    public OfflinePlayer getOfflinePlayerIfCached(@NotNull String var1);

    @NotNull
    public OfflinePlayer getOfflinePlayer(@NotNull UUID var1);

    @Deprecated
    @NotNull
    public PlayerProfile createPlayerProfile(@Nullable UUID var1, @Nullable String var2);

    @Deprecated
    @NotNull
    public PlayerProfile createPlayerProfile(@NotNull UUID var1);

    @Deprecated
    @NotNull
    public PlayerProfile createPlayerProfile(@NotNull String var1);

    @NotNull
    public Set<String> getIPBans();

    @Deprecated
    public void banIP(@NotNull String var1);

    @Deprecated
    public void unbanIP(@NotNull String var1);

    public void banIP(@NotNull InetAddress var1);

    public void unbanIP(@NotNull InetAddress var1);

    @NotNull
    public Set<OfflinePlayer> getBannedPlayers();

    @Deprecated
    @NotNull
    public <T extends BanList<?>> T getBanList(@NotNull BanList.Type var1);

    @NotNull
    public <B extends BanList<E>, E> B getBanList(@NotNull BanListType<B> var1);

    @NotNull
    public Set<OfflinePlayer> getOperators();

    @NotNull
    public GameMode getDefaultGameMode();

    public void setDefaultGameMode(@NotNull GameMode var1);

    @NotNull
    public ConsoleCommandSender getConsoleSender();

    @NotNull
    public CommandSender createCommandSender(@NotNull Consumer<? super Component> var1);

    @NotNull
    public File getWorldContainer();

    @NotNull
    public OfflinePlayer[] getOfflinePlayers();

    @NotNull
    public Messenger getMessenger();

    @NotNull
    public HelpMap getHelpMap();

    @NotNull
    public Inventory createInventory(@Nullable InventoryHolder var1, @NotNull InventoryType var2);

    @NotNull
    public Inventory createInventory(@Nullable InventoryHolder var1, @NotNull InventoryType var2, @NotNull Component var3);

    @Deprecated
    @NotNull
    public Inventory createInventory(@Nullable InventoryHolder var1, @NotNull InventoryType var2, @NotNull String var3);

    @NotNull
    public Inventory createInventory(@Nullable InventoryHolder var1, int var2) throws IllegalArgumentException;

    @NotNull
    public Inventory createInventory(@Nullable InventoryHolder var1, int var2, @NotNull Component var3) throws IllegalArgumentException;

    @Deprecated
    @NotNull
    public Inventory createInventory(@Nullable InventoryHolder var1, int var2, @NotNull String var3) throws IllegalArgumentException;

    @NotNull
    public Merchant createMerchant(@Nullable Component var1);

    @Deprecated
    @NotNull
    public Merchant createMerchant(@Nullable String var1);

    public int getMaxChainedNeighborUpdates();

    @Deprecated
    public int getMonsterSpawnLimit();

    @Deprecated
    public int getAnimalSpawnLimit();

    @Deprecated
    public int getWaterAnimalSpawnLimit();

    @Deprecated
    public int getWaterAmbientSpawnLimit();

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit();

    @Deprecated
    public int getAmbientSpawnLimit();

    public int getSpawnLimit(@NotNull SpawnCategory var1);

    public boolean isPrimaryThread();

    public @NotNull Component motd();

    public void motd(@NotNull Component var1);

    public @Nullable Component shutdownMessage();

    @Deprecated
    @NotNull
    public String getMotd();

    @Deprecated
    public void setMotd(@NotNull String var1);

    @Deprecated
    @Nullable
    public String getShutdownMessage();

    @NotNull
    public Warning.WarningState getWarningState();

    @NotNull
    public ItemFactory getItemFactory();

    @NotNull
    public ScoreboardManager getScoreboardManager();

    @NotNull
    public Criteria getScoreboardCriteria(@NotNull String var1);

    @Nullable
    public CachedServerIcon getServerIcon();

    @NotNull
    public CachedServerIcon loadServerIcon(@NotNull File var1) throws IllegalArgumentException, Exception;

    @NotNull
    public CachedServerIcon loadServerIcon(@NotNull BufferedImage var1) throws IllegalArgumentException, Exception;

    public void setIdleTimeout(int var1);

    public int getIdleTimeout();

    @NotNull
    public ChunkGenerator.ChunkData createChunkData(@NotNull World var1);

    @Deprecated(forRemoval=true)
    @NotNull
    public ChunkGenerator.ChunkData createVanillaChunkData(@NotNull World var1, int var2, int var3);

    @NotNull
    public BossBar createBossBar(@Nullable String var1, @NotNull BarColor var2, @NotNull BarStyle var3, BarFlag ... var4);

    @NotNull
    public KeyedBossBar createBossBar(@NotNull NamespacedKey var1, @Nullable String var2, @NotNull BarColor var3, @NotNull BarStyle var4, BarFlag ... var5);

    @NotNull
    public Iterator<KeyedBossBar> getBossBars();

    @Nullable
    public KeyedBossBar getBossBar(@NotNull NamespacedKey var1);

    public boolean removeBossBar(@NotNull NamespacedKey var1);

    @Nullable
    public Entity getEntity(@NotNull UUID var1);

    @NotNull
    public double[] getTPS();

    @NotNull
    public long[] getTickTimes();

    public double getAverageTickTime();

    @NotNull
    public CommandMap getCommandMap();

    @Nullable
    public Advancement getAdvancement(@NotNull NamespacedKey var1);

    @NotNull
    public Iterator<Advancement> advancementIterator();

    @NotNull
    public BlockData createBlockData(@NotNull Material var1);

    @NotNull
    public BlockData createBlockData(@NotNull Material var1, @Nullable Consumer<? super BlockData> var2);

    @NotNull
    public BlockData createBlockData(@NotNull String var1) throws IllegalArgumentException;

    @NotNull
    @Contract(value="null, null -> fail")
    public BlockData createBlockData(@Nullable Material var1, @Nullable String var2) throws IllegalArgumentException;

    @Nullable
    public <T extends Keyed> Tag<T> getTag(@NotNull String var1, @NotNull NamespacedKey var2, @NotNull Class<T> var3);

    @NotNull
    public <T extends Keyed> Iterable<Tag<T>> getTags(@NotNull String var1, @NotNull Class<T> var2);

    @Nullable
    public LootTable getLootTable(@NotNull NamespacedKey var1);

    @NotNull
    public List<Entity> selectEntities(@NotNull CommandSender var1, @NotNull String var2) throws IllegalArgumentException;

    @NotNull
    public StructureManager getStructureManager();

    @Nullable
    public <T extends Keyed> Registry<T> getRegistry(@NotNull Class<T> var1);

    @Deprecated
    @NotNull
    public UnsafeValues getUnsafe();

    @NotNull
    public Spigot spigot();

    public void reloadPermissions();

    public boolean reloadCommandAliases();

    public boolean suggestPlayerNamesWhenNullTabCompletions();

    @Deprecated
    @NotNull
    public String getPermissionMessage();

    @NotNull
    public Component permissionMessage();

    @NotNull
    public com.destroystokyo.paper.profile.PlayerProfile createProfile(@NotNull UUID var1);

    @NotNull
    public com.destroystokyo.paper.profile.PlayerProfile createProfile(@NotNull String var1);

    @NotNull
    public com.destroystokyo.paper.profile.PlayerProfile createProfile(@Nullable UUID var1, @Nullable String var2);

    @NotNull
    public com.destroystokyo.paper.profile.PlayerProfile createProfileExact(@Nullable UUID var1, @Nullable String var2);

    public int getCurrentTick();

    public boolean isStopping();

    @NotNull
    public MobGoals getMobGoals();

    @NotNull
    public DatapackManager getDatapackManager();

    @NotNull
    public PotionBrewer getPotionBrewer();

    @NotNull
    public RegionScheduler getRegionScheduler();

    @NotNull
    public AsyncScheduler getAsyncScheduler();

    @NotNull
    public GlobalRegionScheduler getGlobalRegionScheduler();

    public boolean isOwnedByCurrentRegion(@NotNull World var1, @NotNull Position var2);

    public boolean isOwnedByCurrentRegion(@NotNull World var1, @NotNull Position var2, int var3);

    public boolean isOwnedByCurrentRegion(@NotNull Location var1);

    public boolean isOwnedByCurrentRegion(@NotNull Location var1, int var2);

    default public boolean isOwnedByCurrentRegion(@NotNull Block block) {
        return this.isOwnedByCurrentRegion(block.getLocation());
    }

    public boolean isOwnedByCurrentRegion(@NotNull World var1, int var2, int var3);

    public boolean isOwnedByCurrentRegion(@NotNull World var1, int var2, int var3, int var4);

    public boolean isOwnedByCurrentRegion(@NotNull Entity var1);

    @NotNull
    public BotManager getBotManager();

    @NotNull
    public PhotographerManager getPhotographerManager();

    @NotNull
    public Bytebuf newByteBuf();

    @NotNull
    public Bytebuf newByteBuf(int var1);

    public static class Spigot {
        @NotNull
        public YamlConfiguration getConfig() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @NotNull
        public YamlConfiguration getBukkitConfig() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @NotNull
        public YamlConfiguration getSpigotConfig() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @NotNull
        public YamlConfiguration getPaperConfig() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @NotNull
        public YamlConfiguration getLeavesConfig() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void broadcast(@NotNull BaseComponent component) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void broadcast(BaseComponent ... components) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void restart() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

