/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.lock;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;

public final class ReentrantAreaLock {
    public final int coordinateShift;
    private final ConcurrentHashMap<Coordinate, Node> nodes = new ConcurrentHashMap(128, 0.2f);

    public ReentrantAreaLock(int coordinateShift) {
        this.coordinateShift = coordinateShift;
    }

    public boolean isHeldByCurrentThread(int x2, int z2) {
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int sectionX = x2 >> shift;
        int sectionZ = z2 >> shift;
        Coordinate coordinate = new Coordinate(Coordinate.key(sectionX, sectionZ));
        Node node = this.nodes.get(coordinate);
        return node != null && node.thread == currThread;
    }

    public boolean isHeldByCurrentThread(int centerX, int centerZ, int radius) {
        return this.isHeldByCurrentThread(centerX - radius, centerZ - radius, centerX + radius, centerZ + radius);
    }

    public boolean isHeldByCurrentThread(int fromX, int fromZ, int toX, int toZ) {
        if (fromX > toX || fromZ > toZ) {
            throw new IllegalArgumentException();
        }
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int fromSectionX = fromX >> shift;
        int fromSectionZ = fromZ >> shift;
        int toSectionX = toX >> shift;
        int toSectionZ = toZ >> shift;
        for (int currZ = fromSectionZ; currZ <= toSectionZ; ++currZ) {
            for (int currX = fromSectionX; currX <= toSectionX; ++currX) {
                Coordinate coordinate = new Coordinate(Coordinate.key(currX, currZ));
                Node node = this.nodes.get(coordinate);
                if (node != null && node.thread == currThread) continue;
                return false;
            }
        }
        return true;
    }

    public Node tryLock(int x2, int z2) {
        return this.tryLock(x2, z2, x2, z2);
    }

    public Node tryLock(int centerX, int centerZ, int radius) {
        return this.tryLock(centerX - radius, centerZ - radius, centerX + radius, centerZ + radius);
    }

    public Node tryLock(int fromX, int fromZ, int toX, int toZ) {
        if (fromX > toX || fromZ > toZ) {
            throw new IllegalArgumentException();
        }
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int fromSectionX = fromX >> shift;
        int fromSectionZ = fromZ >> shift;
        int toSectionX = toX >> shift;
        int toSectionZ = toZ >> shift;
        ArrayList<Coordinate> areaAffected = new ArrayList<Coordinate>();
        Node ret = new Node(this, areaAffected, currThread);
        boolean failed = false;
        block0: for (int currZ = fromSectionZ; currZ <= toSectionZ; ++currZ) {
            for (int currX = fromSectionX; currX <= toSectionX; ++currX) {
                Coordinate coordinate = new Coordinate(Coordinate.key(currX, currZ));
                Node prev = this.nodes.putIfAbsent(coordinate, ret);
                if (prev == null) {
                    areaAffected.add(coordinate);
                    continue;
                }
                if (prev.thread == currThread) continue;
                failed = true;
                continue block0;
            }
        }
        if (!failed) {
            return ret;
        }
        if (!areaAffected.isEmpty()) {
            Thread unpark;
            int len = areaAffected.size();
            for (int i2 = 0; i2 < len; ++i2) {
                Coordinate key = (Coordinate)areaAffected.get(i2);
                if (this.nodes.remove(key) == ret) continue;
                throw new IllegalStateException();
            }
            areaAffected.clear();
            while ((unpark = (Thread)ret.pollOrBlockAdds()) != null) {
                LockSupport.unpark(unpark);
            }
        }
        return null;
    }

    public Node lock(int x2, int z2) {
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int sectionX = x2 >> shift;
        int sectionZ = z2 >> shift;
        ArrayList<Coordinate> areaAffected = new ArrayList<Coordinate>(1);
        Node ret = new Node(this, areaAffected, currThread);
        Coordinate coordinate = new Coordinate(Coordinate.key(sectionX, sectionZ));
        long failures = 0L;
        while (true) {
            Node prev;
            if ((prev = this.nodes.putIfAbsent(coordinate, ret)) == null) {
                areaAffected.add(coordinate);
                return ret;
            }
            if (prev.thread == currThread) {
                return ret;
            }
            Node park = prev;
            if (++failures > 128L && park.add(currThread)) {
                LockSupport.park();
                continue;
            }
            if (failures < 128L) {
                for (long i2 = 0L; i2 < failures; ++i2) {
                    Thread.onSpinWait();
                }
                failures <<= 1;
                continue;
            }
            if (failures < 1200L) {
                LockSupport.parkNanos(1000L);
                ++failures;
                continue;
            }
            Thread.yield();
            LockSupport.parkNanos(100000L * failures);
            ++failures;
        }
    }

    public Node lock(int centerX, int centerZ, int radius) {
        return this.lock(centerX - radius, centerZ - radius, centerX + radius, centerZ + radius);
    }

    public Node lock(int fromX, int fromZ, int toX, int toZ) {
        if (fromX > toX || fromZ > toZ) {
            throw new IllegalArgumentException();
        }
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int fromSectionX = fromX >> shift;
        int toSectionX = toX >> shift;
        int fromSectionZ = fromZ >> shift;
        int toSectionZ = toZ >> shift;
        if ((fromSectionX ^ toSectionX | fromSectionZ ^ toSectionZ) == 0) {
            return this.lock(fromX, fromZ);
        }
        ArrayList<Coordinate> areaAffected = new ArrayList<Coordinate>();
        Node ret = new Node(this, areaAffected, currThread);
        long failures = 0L;
        while (true) {
            MultiThreadedQueue park = null;
            boolean addedToArea = false;
            boolean alreadyOwned = false;
            boolean allOwned = true;
            block1: for (int currZ = fromSectionZ; currZ <= toSectionZ; ++currZ) {
                for (int currX = fromSectionX; currX <= toSectionX; ++currX) {
                    Coordinate coordinate = new Coordinate(Coordinate.key(currX, currZ));
                    Node prev = this.nodes.putIfAbsent(coordinate, ret);
                    if (prev == null) {
                        addedToArea = true;
                        allOwned = false;
                        areaAffected.add(coordinate);
                        continue;
                    }
                    if (prev.thread == currThread) continue;
                    park = prev;
                    alreadyOwned = true;
                    continue block1;
                }
            }
            if (park == null) {
                if (alreadyOwned && !allOwned) {
                    throw new IllegalStateException("Improper lock usage: Should never acquire intersecting areas");
                }
                return ret;
            }
            if (addedToArea) {
                Thread unpark;
                int len = areaAffected.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    Coordinate key = (Coordinate)areaAffected.get(i2);
                    if (this.nodes.remove(key) == ret) continue;
                    throw new IllegalStateException();
                }
                areaAffected.clear();
                while ((unpark = (Thread)ret.pollOrBlockAdds()) != null) {
                    LockSupport.unpark(unpark);
                }
            }
            if (++failures > 128L && park.add(currThread)) {
                LockSupport.park(park);
            } else if (failures < 128L) {
                for (long i3 = 0L; i3 < failures; ++i3) {
                    Thread.onSpinWait();
                }
                failures <<= 1;
            } else if (failures < 1200L) {
                LockSupport.parkNanos(1000L);
                ++failures;
            } else {
                Thread.yield();
                LockSupport.parkNanos(100000L * failures);
                ++failures;
            }
            if (!addedToArea) continue;
            ret.allowAdds();
        }
    }

    public void unlock(Node node) {
        Thread unpark;
        if (node.lock != this) {
            throw new IllegalStateException("Unlock target lock mismatch");
        }
        List<Coordinate> areaAffected = node.areaAffected;
        if (areaAffected.isEmpty()) {
            return;
        }
        int len = areaAffected.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Coordinate coordinate = areaAffected.get(i2);
            if (this.nodes.remove(coordinate) == node) continue;
            throw new IllegalStateException();
        }
        while ((unpark = (Thread)node.pollOrBlockAdds()) != null) {
            LockSupport.unpark(unpark);
        }
    }

    private static final class Coordinate
    implements Comparable<Coordinate> {
        public final long key;

        public Coordinate(long key) {
            this.key = key;
        }

        public Coordinate(int x2, int z2) {
            this.key = Coordinate.key(x2, z2);
        }

        public static long key(int x2, int z2) {
            return (long)z2 << 32 | (long)x2 & 0xFFFFFFFFL;
        }

        public static int x(long key) {
            return (int)key;
        }

        public static int z(long key) {
            return (int)(key >>> 32);
        }

        public int hashCode() {
            return (int)HashCommon.mix((long)this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Coordinate)) {
                return false;
            }
            Coordinate other = (Coordinate)obj;
            return this.key == other.key;
        }

        @Override
        public int compareTo(Coordinate other) {
            return Long.compare(this.key, other.key);
        }

        public String toString() {
            return "[" + Coordinate.x(this.key) + "," + Coordinate.z(this.key) + "]";
        }
    }

    public static final class Node
    extends MultiThreadedQueue<Thread> {
        private final ReentrantAreaLock lock;
        private final List<Coordinate> areaAffected;
        private final Thread thread;

        private Node(ReentrantAreaLock lock, List<Coordinate> areaAffected, Thread thread) {
            this.lock = lock;
            this.areaAffected = areaAffected;
            this.thread = thread;
        }

        @Override
        public String toString() {
            return "Node{areaAffected=" + this.areaAffected + ", thread=" + this.thread + "}";
        }
    }
}

