/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.blockname;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.ConverterAbstractStringValueTypeRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.function.Function;

public final class ConverterAbstractBlockRename {
    private ConverterAbstractBlockRename() {
    }

    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractBlockRename.register(version, 0, renamer);
    }

    public static void register(int version, int subVersion, final Function<String, String> renamer) {
        ConverterAbstractStringValueTypeRename.register(version, subVersion, MCTypeRegistry.BLOCK_NAME, renamer);
        MCTypeRegistry.BLOCK_STATE.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(version, subVersion){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String converted;
                String name = data.getString("Name");
                if (name != null && (converted = (String)renamer.apply(name)) != null) {
                    data.setString("Name", converted);
                }
                return null;
            }
        });
    }

    public static void registerAndFixJigsaw(int version, Function<String, String> renamer) {
        ConverterAbstractBlockRename.registerAndFixJigsaw(version, 0, renamer);
    }

    public static void registerAndFixJigsaw(int version, int subVersion, final Function<String, String> renamer) {
        ConverterAbstractBlockRename.register(version, subVersion, renamer);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:jigsaw", new DataConverter<MapType<String>, MapType<String>>(version, subVersion){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String blockStateName;
                String converted;
                String finalState = data.getString("final_state");
                if (finalState == null || finalState.isEmpty()) {
                    return null;
                }
                int nbtStart1 = finalState.indexOf(91);
                int nbtStart2 = finalState.indexOf(123);
                int stateNameEnd = finalState.length();
                if (nbtStart1 > 0) {
                    stateNameEnd = Math.min(stateNameEnd, nbtStart1);
                }
                if (nbtStart2 > 0) {
                    stateNameEnd = Math.min(stateNameEnd, nbtStart2);
                }
                if ((converted = (String)renamer.apply(blockStateName = finalState.substring(0, stateNameEnd))) == null) {
                    return null;
                }
                String convertedState = converted.concat(finalState.substring(stateNameEnd));
                data.setString("final_state", convertedState);
                return null;
            }
        });
    }
}

