/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.util.NamespaceUtil;

public final class V1920 {
    protected static final int VERSION = 1920;

    private V1920() {
    }

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1920){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType references;
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                MapType structures = level.getMap("Structures");
                if (structures == null) {
                    return null;
                }
                MapType starts = structures.getMap("Starts");
                if (starts != null) {
                    MapType village = starts.getMap("New_Village");
                    if (village != null) {
                        starts.remove("New_Village");
                        starts.setMap("Village", village);
                    } else {
                        starts.remove("Village");
                    }
                }
                if ((references = structures.getMap("References")) != null) {
                    MapType newVillage = references.getMap("New_Village");
                    if (newVillage == null) {
                        references.remove("Village");
                    } else {
                        references.remove("New_Village");
                        references.setMap("Village", newVillage);
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.STRUCTURE_FEATURE.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1920){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String id = data.getString("id");
                if ("minecraft:new_village".equals(NamespaceUtil.correctNamespace(id))) {
                    data.setString("id", "minecraft:village");
                }
                return null;
            }
        });
        MCTypeRegistry.TILE_ENTITY.addWalker(1920, "minecraft:campfire", new DataWalkerItemLists("Items"));
    }
}

