/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public final class V2523 {
    protected static final int VERSION = 2523;
    private static final Map<String, String> RENAMES = new HashMap<String, String>((Map<String, String>)ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"generic.max_health").put((Object)"Max Health", (Object)"generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"horse.jump_strength").put((Object)"Jump Strength", (Object)"horse.jump_strength").put((Object)"generic.followRange", (Object)"generic.follow_range").put((Object)"Follow Range", (Object)"generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"generic.movement_speed").put((Object)"Movement Speed", (Object)"generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"generic.flying_speed").put((Object)"Flying Speed", (Object)"generic.flying_speed").put((Object)"generic.attackDamage", (Object)"generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"generic.attack_speed").put((Object)"generic.armorToughness", (Object)"generic.armor_toughness").build());

    private V2523() {
    }

    private static void updateName(MapType<String> data, String path) {
        String renamed;
        if (data == null) {
            return;
        }
        String name = data.getString(path);
        if (name != null && (renamed = RENAMES.get(name)) != null) {
            data.setString(path, renamed);
        }
    }

    public static void register() {
        DataConverter<MapType<String>, MapType<String>> entityConverter = new DataConverter<MapType<String>, MapType<String>>(2523){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType attributes = data.getList("Attributes", ObjectType.MAP);
                if (attributes == null) {
                    return null;
                }
                int len = attributes.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    V2523.updateName(attributes.getMap(i2), "Name");
                }
                return null;
            }
        };
        MCTypeRegistry.ENTITY.addStructureConverter(entityConverter);
        MCTypeRegistry.PLAYER.addStructureConverter(entityConverter);
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2523){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType attributes = data.getList("AttributeModifiers", ObjectType.MAP);
                if (attributes == null) {
                    return null;
                }
                int len = attributes.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    V2523.updateName(attributes.getMap(i2), "AttributeName");
                }
                return null;
            }
        });
    }
}

