/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.json;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.json.JsonListType;
import ca.spottedleaf.dataconverter.types.json.JsonMapType;
import ca.spottedleaf.dataconverter.types.nbt.NBTListType;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

public final class JsonTypeUtil
implements TypeUtil {
    @Override
    public ListType createEmptyList() {
        return new JsonListType(false);
    }

    public MapType<String> createEmptyMap() {
        return new JsonMapType(false);
    }

    public static <T extends JsonElement> T copyJson(T from) {
        String out = from.toString();
        return (T)Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(out)));
    }

    private static Object convertToGenericNBT(JsonElement element, boolean compressed) {
        if (element instanceof JsonObject) {
            return JsonTypeUtil.convertJsonToNBT(new JsonMapType((JsonObject)element, compressed));
        }
        if (element instanceof JsonArray) {
            return JsonTypeUtil.convertJsonToNBT(new JsonListType((JsonArray)element, compressed));
        }
        if (element instanceof JsonNull) {
            return null;
        }
        JsonPrimitive primitive = (JsonPrimitive)element;
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean() ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }
        if (primitive.isNumber()) {
            return primitive.getAsNumber();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        throw new IllegalStateException("Unrecognized type " + element);
    }

    public static NBTMapType convertJsonToNBT(JsonMapType json) {
        NBTMapType ret = new NBTMapType();
        for (Map.Entry entry : json.map.entrySet()) {
            Object obj = JsonTypeUtil.convertToGenericNBT((JsonElement)entry.getValue(), json.compressed);
            if (obj == null) continue;
            ret.setGeneric((String)entry.getKey(), obj);
        }
        return ret;
    }

    public static NBTListType convertJsonToNBT(JsonListType json) {
        NBTListType ret = new NBTListType();
        int len = json.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ret.addGeneric(JsonTypeUtil.convertToGenericNBT(json.array.get(i2), json.compressed));
        }
        return ret;
    }
}

