/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.util;

public final class IntegerUtil {
    public static final int HIGH_BIT_U32 = Integer.MIN_VALUE;
    public static final long HIGH_BIT_U64 = Long.MIN_VALUE;

    public static int ceilLog2(int value) {
        return 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static long ceilLog2(long value) {
        return 64 - Long.numberOfLeadingZeros(value - 1L);
    }

    public static int floorLog2(int value) {
        return 0x1F ^ Integer.numberOfLeadingZeros(value);
    }

    public static int floorLog2(long value) {
        return 0x3F ^ Long.numberOfLeadingZeros(value);
    }

    public static int roundCeilLog2(int value) {
        return Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(value - 1) - 1;
    }

    public static long roundCeilLog2(long value) {
        return Long.MIN_VALUE >>> Long.numberOfLeadingZeros(value - 1L) - 1;
    }

    public static int roundFloorLog2(int value) {
        return Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(value);
    }

    public static long roundFloorLog2(long value) {
        return Long.MIN_VALUE >>> Long.numberOfLeadingZeros(value);
    }

    public static boolean isPowerOfTwo(int n2) {
        return IntegerUtil.getTrailingBit(n2) == n2;
    }

    public static boolean isPowerOfTwo(long n2) {
        return IntegerUtil.getTrailingBit(n2) == n2;
    }

    public static int getTrailingBit(int n2) {
        return -n2 & n2;
    }

    public static long getTrailingBit(long n2) {
        return -n2 & n2;
    }

    public static int trailingZeros(int n2) {
        return Integer.numberOfTrailingZeros(n2);
    }

    public static int trailingZeros(long n2) {
        return Long.numberOfTrailingZeros(n2);
    }

    public static int getDivisorMultiple(long numbers) {
        return (int)(numbers >>> 32);
    }

    public static int getDivisorShift(long numbers) {
        return (int)numbers;
    }

    public static long getDivisorNumbers(int d2) {
        int delta;
        int ad = IntegerUtil.branchlessAbs(d2);
        if (ad < 2) {
            throw new IllegalArgumentException("|number| must be in [2, 2^31 -1], not: " + d2);
        }
        int two31 = Integer.MIN_VALUE;
        long mask = 0xFFFFFFFFL;
        int p2 = 31;
        int t2 = Integer.MIN_VALUE + (d2 >>> 31);
        int anc = t2 - 1 - (int)(((long)t2 & 0xFFFFFFFFL) % (long)ad);
        int q1 = (int)(0x80000000L / ((long)anc & 0xFFFFFFFFL));
        int r1 = Integer.MIN_VALUE - q1 * anc;
        int q2 = (int)(0x80000000L / ((long)ad & 0xFFFFFFFFL));
        int r2 = Integer.MIN_VALUE - q2 * ad;
        do {
            ++p2;
            q1 = 2 * q1;
            if (((long)(r1 = 2 * r1) & 0xFFFFFFFFL) >= ((long)anc & 0xFFFFFFFFL)) {
                ++q1;
                r1 -= anc;
            }
            q2 = 2 * q2;
            if (((long)(r2 = 2 * r2) & 0xFFFFFFFFL) < ((long)ad & 0xFFFFFFFFL)) continue;
            ++q2;
            r2 -= ad;
        } while (((long)q1 & 0xFFFFFFFFL) < ((long)(delta = ad - r2) & 0xFFFFFFFFL) || q1 == delta && r1 == 0);
        int magicNum = q2 + 1;
        if (d2 < 0) {
            magicNum = -magicNum;
        }
        int shift = p2;
        return (long)magicNum << 32 | (long)shift;
    }

    public static int branchlessAbs(int val) {
        int mask = val >> 31;
        return (mask ^ val) - mask;
    }

    public static long branchlessAbs(long val) {
        long mask = val >> 63;
        return (mask ^ val) - mask;
    }

    public static int hash0(int x2) {
        x2 *= 915625301;
        x2 ^= x2 >>> 16;
        return x2;
    }

    public static int hash1(int x2) {
        x2 ^= x2 >>> 15;
        x2 *= 896182957;
        x2 ^= x2 >>> 17;
        return x2;
    }

    public static int hash2(int x2) {
        x2 ^= x2 >>> 16;
        x2 *= 2146121005;
        x2 ^= x2 >>> 15;
        x2 *= -2073254261;
        x2 ^= x2 >>> 16;
        return x2;
    }

    public static int hash3(int x2) {
        x2 ^= x2 >>> 17;
        x2 *= -312814405;
        x2 ^= x2 >>> 11;
        x2 *= -1404298415;
        x2 ^= x2 >>> 15;
        x2 *= 830770091;
        x2 ^= x2 >>> 14;
        return x2;
    }

    public static long hash1(long x2) {
        x2 ^= x2 >>> 27;
        x2 *= -5599904292771383989L;
        x2 ^= x2 >>> 28;
        return x2;
    }

    public static long hash2(long x2) {
        x2 ^= x2 >>> 32;
        x2 *= -2960836687051489901L;
        x2 ^= x2 >>> 32;
        x2 *= -2960836687051489901L;
        x2 ^= x2 >>> 32;
        return x2;
    }

    public static long hash3(long x2) {
        x2 ^= x2 >>> 45;
        x2 *= -4512136349728674695L;
        x2 ^= x2 >>> 41;
        x2 *= -2025150219368492809L;
        x2 ^= x2 >>> 56;
        x2 *= 2277337576034381939L;
        x2 ^= x2 >>> 53;
        return x2;
    }

    private IntegerUtil() {
        throw new RuntimeException();
    }
}

