/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import com.destroystokyo.paper.entity.RangedEntity;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.papermc.paper.entity.SchoolableFish;
import io.papermc.paper.util.ObfHelper;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.raid.EntityRaider;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Flying;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;

public class MobGoalHelper {
    private static final BiMap<String, String> deobfuscationMap = HashBiMap.create();
    private static final Map<Class<? extends PathfinderGoal>, Class<? extends Mob>> entityClassCache = new HashMap<Class<? extends PathfinderGoal>, Class<? extends Mob>>();
    private static final Map<Class<? extends EntityInsentient>, Class<? extends Mob>> bukkitMap = new HashMap<Class<? extends EntityInsentient>, Class<? extends Mob>>();
    static final Set<String> ignored = new HashSet<String>();

    public static String getUsableName(Class<?> clazz) {
        String name = ObfHelper.INSTANCE.deobfClassName(clazz.getName());
        name = name.substring(name.lastIndexOf(".") + 1);
        boolean flag = false;
        if (name.contains("$")) {
            String cut = name.substring(name.indexOf("$") + 1);
            if (cut.length() <= 2) {
                name = name.replace("Entity", "");
                name = name.replace("$", "_");
                flag = true;
            } else {
                name = cut;
            }
        }
        name = name.replace("PathfinderGoal", "");
        name = name.replace("TargetGoal", "");
        name = name.replace("Goal", "");
        StringBuilder sb = new StringBuilder();
        for (char c2 : name.toCharArray()) {
            if (c2 >= 'A' && c2 <= 'Z') {
                sb.append("_");
                sb.append(Character.toLowerCase(c2));
                continue;
            }
            sb.append(c2);
        }
        name = sb.toString();
        name = name.replaceFirst("_", "");
        if (flag && !deobfuscationMap.containsKey((Object)name.toLowerCase()) && !ignored.contains(name)) {
            System.out.println("need to map " + clazz.getName() + " (" + name.toLowerCase() + ")");
        }
        return (String)deobfuscationMap.getOrDefault((Object)name, (Object)name);
    }

    public static EnumSet<GoalType> vanillaToPaper(PathfinderGoal goal) {
        EnumSet<GoalType> goals = EnumSet.noneOf(GoalType.class);
        for (GoalType type : GoalType.values()) {
            if (!goal.getFlags().contains(MobGoalHelper.paperToVanilla(type))) continue;
            goals.add(type);
        }
        return goals;
    }

    public static GoalType vanillaToPaper(PathfinderGoal.Type type) {
        switch (type) {
            case a: {
                return GoalType.MOVE;
            }
            case b: {
                return GoalType.LOOK;
            }
            case c: {
                return GoalType.JUMP;
            }
            case UNKNOWN_BEHAVIOR: {
                return GoalType.UNKNOWN_BEHAVIOR;
            }
            case d: {
                return GoalType.TARGET;
            }
        }
        throw new IllegalArgumentException("Unknown vanilla mob goal type " + type.name());
    }

    public static EnumSet<PathfinderGoal.Type> paperToVanilla(EnumSet<GoalType> types) {
        EnumSet<PathfinderGoal.Type> goals = EnumSet.noneOf(PathfinderGoal.Type.class);
        for (GoalType type : types) {
            goals.add(MobGoalHelper.paperToVanilla(type));
        }
        return goals;
    }

    public static PathfinderGoal.Type paperToVanilla(GoalType type) {
        switch (type) {
            case MOVE: {
                return PathfinderGoal.Type.a;
            }
            case LOOK: {
                return PathfinderGoal.Type.b;
            }
            case JUMP: {
                return PathfinderGoal.Type.c;
            }
            case UNKNOWN_BEHAVIOR: {
                return PathfinderGoal.Type.UNKNOWN_BEHAVIOR;
            }
            case TARGET: {
                return PathfinderGoal.Type.d;
            }
        }
        throw new IllegalArgumentException("Unknown paper mob goal type " + type.name());
    }

    public static <T extends Mob> GoalKey<T> getKey(Class<? extends PathfinderGoal> goalClass) {
        String name = MobGoalHelper.getUsableName(goalClass);
        if (ignored.contains(name)) {
            return GoalKey.of(Mob.class, (NamespacedKey)NamespacedKey.minecraft((String)name));
        }
        return GoalKey.of(MobGoalHelper.getEntity(goalClass), (NamespacedKey)NamespacedKey.minecraft((String)name));
    }

    public static <T extends Mob> Class<T> getEntity(Class<? extends PathfinderGoal> goalClass) {
        return entityClassCache.computeIfAbsent(goalClass, key -> {
            for (Constructor<?> ctor : key.getDeclaredConstructors()) {
                for (int i2 = 0; i2 < ctor.getParameterCount(); ++i2) {
                    Class<?> param = ctor.getParameterTypes()[i2];
                    if (EntityInsentient.class.isAssignableFrom(param)) {
                        return MobGoalHelper.toBukkitClass(param);
                    }
                    if (!IRangedEntity.class.isAssignableFrom(param)) continue;
                    return RangedEntity.class;
                }
            }
            throw new RuntimeException("Can't figure out applicable entity for mob goal " + goalClass);
        });
    }

    public static Class<? extends Mob> toBukkitClass(Class<? extends EntityInsentient> nmsClass) {
        Class<? extends Mob> bukkitClass = bukkitMap.get(nmsClass);
        if (bukkitClass == null) {
            throw new RuntimeException("Can't figure out applicable bukkit entity for nms entity " + nmsClass);
        }
        return bukkitClass;
    }

    static {
        deobfuscationMap.put((Object)"abstract_skeleton_1", (Object)"abstract_skeleton_melee");
        ignored.add("goal_selector_1");
        ignored.add("goal_selector_2");
        ignored.add("selector_1");
        ignored.add("selector_2");
        ignored.add("wrapped");
        bukkitMap.put(EntityInsentient.class, Mob.class);
        bukkitMap.put(EntityAgeable.class, Ageable.class);
        bukkitMap.put(EntityAmbient.class, Ambient.class);
        bukkitMap.put(EntityAnimal.class, Animals.class);
        bukkitMap.put(EntityBat.class, Bat.class);
        bukkitMap.put(EntityBee.class, Bee.class);
        bukkitMap.put(EntityBlaze.class, Blaze.class);
        bukkitMap.put(EntityCat.class, Cat.class);
        bukkitMap.put(EntityCaveSpider.class, CaveSpider.class);
        bukkitMap.put(EntityChicken.class, Chicken.class);
        bukkitMap.put(EntityCod.class, Cod.class);
        bukkitMap.put(EntityCow.class, Cow.class);
        bukkitMap.put(EntityCreature.class, Creature.class);
        bukkitMap.put(EntityCreeper.class, Creeper.class);
        bukkitMap.put(EntityDolphin.class, Dolphin.class);
        bukkitMap.put(EntityDrowned.class, Drowned.class);
        bukkitMap.put(EntityEnderDragon.class, EnderDragon.class);
        bukkitMap.put(EntityEnderman.class, Enderman.class);
        bukkitMap.put(EntityEndermite.class, Endermite.class);
        bukkitMap.put(EntityEvoker.class, Evoker.class);
        bukkitMap.put(EntityFish.class, Fish.class);
        bukkitMap.put(EntityFishSchool.class, SchoolableFish.class);
        bukkitMap.put(EntityFlying.class, Flying.class);
        bukkitMap.put(EntityFox.class, Fox.class);
        bukkitMap.put(EntityGhast.class, Ghast.class);
        bukkitMap.put(EntityGiantZombie.class, Giant.class);
        bukkitMap.put(EntityGolem.class, Golem.class);
        bukkitMap.put(EntityGuardian.class, Guardian.class);
        bukkitMap.put(EntityGuardianElder.class, ElderGuardian.class);
        bukkitMap.put(EntityHorse.class, Horse.class);
        bukkitMap.put(EntityHorseAbstract.class, AbstractHorse.class);
        bukkitMap.put(EntityHorseChestedAbstract.class, ChestedHorse.class);
        bukkitMap.put(EntityHorseDonkey.class, Donkey.class);
        bukkitMap.put(EntityHorseMule.class, Mule.class);
        bukkitMap.put(EntityHorseSkeleton.class, SkeletonHorse.class);
        bukkitMap.put(EntityHorseZombie.class, ZombieHorse.class);
        bukkitMap.put(net.minecraft.world.entity.animal.camel.Camel.class, Camel.class);
        bukkitMap.put(EntityIllagerAbstract.class, Illager.class);
        bukkitMap.put(EntityIllagerIllusioner.class, Illusioner.class);
        bukkitMap.put(EntityIllagerWizard.class, Spellcaster.class);
        bukkitMap.put(EntityIronGolem.class, IronGolem.class);
        bukkitMap.put(EntityLlama.class, Llama.class);
        bukkitMap.put(EntityLlamaTrader.class, TraderLlama.class);
        bukkitMap.put(EntityMagmaCube.class, MagmaCube.class);
        bukkitMap.put(EntityMonster.class, Monster.class);
        bukkitMap.put(EntityMonsterPatrolling.class, Raider.class);
        bukkitMap.put(EntityMushroomCow.class, MushroomCow.class);
        bukkitMap.put(EntityOcelot.class, Ocelot.class);
        bukkitMap.put(EntityPanda.class, Panda.class);
        bukkitMap.put(EntityParrot.class, Parrot.class);
        bukkitMap.put(EntityPerchable.class, Parrot.class);
        bukkitMap.put(EntityPhantom.class, Phantom.class);
        bukkitMap.put(EntityPig.class, Pig.class);
        bukkitMap.put(EntityPigZombie.class, PigZombie.class);
        bukkitMap.put(EntityPillager.class, Pillager.class);
        bukkitMap.put(EntityPolarBear.class, PolarBear.class);
        bukkitMap.put(EntityPufferFish.class, PufferFish.class);
        bukkitMap.put(EntityRabbit.class, Rabbit.class);
        bukkitMap.put(EntityRaider.class, Raider.class);
        bukkitMap.put(EntityRavager.class, Ravager.class);
        bukkitMap.put(EntitySalmon.class, Salmon.class);
        bukkitMap.put(EntitySheep.class, Sheep.class);
        bukkitMap.put(EntityShulker.class, Shulker.class);
        bukkitMap.put(EntitySilverfish.class, Silverfish.class);
        bukkitMap.put(EntitySkeleton.class, Skeleton.class);
        bukkitMap.put(EntitySkeletonAbstract.class, AbstractSkeleton.class);
        bukkitMap.put(EntitySkeletonStray.class, Stray.class);
        bukkitMap.put(EntitySkeletonWither.class, WitherSkeleton.class);
        bukkitMap.put(EntitySlime.class, Slime.class);
        bukkitMap.put(EntitySnowman.class, Snowman.class);
        bukkitMap.put(EntitySpider.class, Spider.class);
        bukkitMap.put(EntitySquid.class, Squid.class);
        bukkitMap.put(EntityTameableAnimal.class, Tameable.class);
        bukkitMap.put(EntityTropicalFish.class, TropicalFish.class);
        bukkitMap.put(EntityTurtle.class, Turtle.class);
        bukkitMap.put(EntityVex.class, Vex.class);
        bukkitMap.put(EntityVillager.class, Villager.class);
        bukkitMap.put(EntityVillagerAbstract.class, AbstractVillager.class);
        bukkitMap.put(EntityVillagerTrader.class, WanderingTrader.class);
        bukkitMap.put(EntityVindicator.class, Vindicator.class);
        bukkitMap.put(EntityWaterAnimal.class, WaterMob.class);
        bukkitMap.put(EntityWitch.class, Witch.class);
        bukkitMap.put(EntityWither.class, Wither.class);
        bukkitMap.put(EntityWolf.class, Wolf.class);
        bukkitMap.put(EntityZombie.class, Zombie.class);
        bukkitMap.put(EntityZombieHusk.class, Husk.class);
        bukkitMap.put(EntityZombieVillager.class, ZombieVillager.class);
        bukkitMap.put(EntityHoglin.class, Hoglin.class);
        bukkitMap.put(EntityPiglin.class, Piglin.class);
        bukkitMap.put(EntityPiglinAbstract.class, PiglinAbstract.class);
        bukkitMap.put(EntityPiglinBrute.class, PiglinBrute.class);
        bukkitMap.put(EntityStrider.class, Strider.class);
        bukkitMap.put(EntityZoglin.class, Zoglin.class);
        bukkitMap.put(net.minecraft.world.entity.GlowSquid.class, GlowSquid.class);
        bukkitMap.put(Axolotl.class, org.bukkit.entity.Axolotl.class);
        bukkitMap.put(Goat.class, org.bukkit.entity.Goat.class);
        bukkitMap.put(Frog.class, org.bukkit.entity.Frog.class);
        bukkitMap.put(net.minecraft.world.entity.animal.frog.Tadpole.class, Tadpole.class);
        bukkitMap.put(Warden.class, org.bukkit.entity.Warden.class);
        bukkitMap.put(net.minecraft.world.entity.animal.allay.Allay.class, Allay.class);
        bukkitMap.put(net.minecraft.world.entity.animal.sniffer.Sniffer.class, Sniffer.class);
        bukkitMap.put(Breeze.class, org.bukkit.entity.Breeze.class);
    }
}

