/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.maplist;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.world.entity.Entity;
import top.leavesmc.leaves.util.ArrayConstants;

public final class EntityList
implements Iterable<Entity> {
    protected final Int2IntOpenHashMap entityToIndex = new Int2IntOpenHashMap(2, 0.8f);
    protected Entity[] entities;
    protected int count;

    public EntityList() {
        this.entityToIndex.defaultReturnValue(Integer.MIN_VALUE);
        this.entities = ArrayConstants.emptyEntityArray;
    }

    public int size() {
        return this.count;
    }

    public boolean contains(Entity entity) {
        return this.entityToIndex.containsKey(entity.aj());
    }

    public boolean remove(Entity entity) {
        int index = this.entityToIndex.remove(entity.aj());
        if (index == Integer.MIN_VALUE) {
            return false;
        }
        int endIndex = --this.count;
        Entity end = this.entities[endIndex];
        if (index != endIndex) {
            this.entityToIndex.put(end.aj(), index);
        }
        this.entities[index] = end;
        this.entities[endIndex] = null;
        return true;
    }

    public boolean add(Entity entity) {
        int count = this.count;
        int currIndex = this.entityToIndex.putIfAbsent(entity.aj(), count);
        if (currIndex != Integer.MIN_VALUE) {
            return false;
        }
        Entity[] list = this.entities;
        if (list.length == count) {
            list = this.entities = Arrays.copyOf(list, (int)Math.max(4L, (long)count * 2L));
        }
        list[count] = entity;
        this.count = count + 1;
        return true;
    }

    public Entity getChecked(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + index + " is out of bounds, size: " + this.count);
        }
        return this.entities[index];
    }

    public Entity getUnchecked(int index) {
        return this.entities[index];
    }

    public Entity[] getRawData() {
        return this.entities;
    }

    public void clear() {
        this.entityToIndex.clear();
        Arrays.fill(this.entities, 0, this.count, null);
        this.count = 0;
    }

    @Override
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            Entity lastRet;
            int current;

            @Override
            public boolean hasNext() {
                return this.current < EntityList.this.count;
            }

            @Override
            public Entity next() {
                if (this.current >= EntityList.this.count) {
                    throw new NoSuchElementException();
                }
                this.lastRet = EntityList.this.entities[this.current++];
                return this.lastRet;
            }

            @Override
            public void remove() {
                Entity lastRet = this.lastRet;
                if (lastRet == null) {
                    throw new IllegalStateException();
                }
                this.lastRet = null;
                EntityList.this.remove(lastRet);
                --this.current;
            }
        };
    }
}

