/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.SignatureState;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.TextureUrlChecker;
import com.mojang.authlib.yggdrasil.request.JoinMinecraftServerRequest;
import com.mojang.authlib.yggdrasil.response.HasJoinedMinecraftServerResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.authlib.yggdrasil.response.ProfileAction;
import com.mojang.util.UUIDTypeAdapter;
import com.mojang.util.UndashedUuid;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YggdrasilMinecraftSessionService
implements MinecraftSessionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(YggdrasilMinecraftSessionService.class);
    protected final MinecraftClient client;
    private final ServicesKeySet servicesKeySet;
    private final String baseUrl;
    private final URL joinUrl;
    private final URL checkUrl;
    private final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
    private final LoadingCache<UUID, Optional<ProfileResult>> insecureProfiles = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<UUID, Optional<ProfileResult>>(){

        public Optional<ProfileResult> load(UUID key) {
            return Optional.ofNullable(YggdrasilMinecraftSessionService.this.fetchProfileUncached(key, false));
        }
    });

    protected YggdrasilMinecraftSessionService(ServicesKeySet servicesKeySet, Proxy proxy, Environment env) {
        this.client = MinecraftClient.unauthenticated((Proxy)proxy);
        this.servicesKeySet = servicesKeySet;
        this.baseUrl = env.sessionHost() + "/session/minecraft/";
        this.joinUrl = HttpAuthenticationService.constantURL((String)(this.baseUrl + "join"));
        this.checkUrl = HttpAuthenticationService.constantURL((String)(this.baseUrl + "hasJoined"));
    }

    public void joinServer(UUID profileId, String authenticationToken, String serverId) throws AuthenticationException {
        JoinMinecraftServerRequest request = new JoinMinecraftServerRequest(authenticationToken, profileId, serverId);
        try {
            this.client.post(this.joinUrl, (Object)request, Void.class);
        }
        catch (MinecraftClientException e2) {
            throw e2.toAuthenticationException();
        }
    }

    @Nullable
    public ProfileResult hasJoinedServer(String profileName, String serverId, @Nullable InetAddress address) throws AuthenticationUnavailableException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("username", profileName);
        arguments.put("serverId", serverId);
        if (address != null) {
            arguments.put("ip", address.getHostAddress());
        }
        URL url = HttpAuthenticationService.concatenateURL((URL)this.checkUrl, (String)HttpAuthenticationService.buildQuery(arguments));
        try {
            HasJoinedMinecraftServerResponse response = (HasJoinedMinecraftServerResponse)this.client.get(url, HasJoinedMinecraftServerResponse.class);
            if (response != null && response.id() != null) {
                GameProfile result = new GameProfile(response.id(), profileName);
                if (response.properties() != null) {
                    result.getProperties().putAll((Multimap)response.properties());
                }
                Set profileActions = response.profileActions().stream().map(ProfileAction::type).collect(Collectors.toSet());
                return new ProfileResult(result, profileActions);
            }
            return null;
        }
        catch (MinecraftClientException e2) {
            AuthenticationException authenticationException = e2.toAuthenticationException();
            if (authenticationException instanceof AuthenticationUnavailableException) {
                AuthenticationUnavailableException unavailable = (AuthenticationUnavailableException)authenticationException;
                throw unavailable;
            }
            return null;
        }
    }

    @Nullable
    public Property getPackedTextures(GameProfile profile) {
        return (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
    }

    public MinecraftProfileTextures unpackTextures(Property packedTextures) {
        MinecraftTexturesPayload result;
        String value = packedTextures.value();
        SignatureState signatureState = this.getPropertySignatureState(packedTextures);
        try {
            String json = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
            result = (MinecraftTexturesPayload)this.gson.fromJson(json, MinecraftTexturesPayload.class);
        }
        catch (JsonParseException | IllegalArgumentException e2) {
            LOGGER.error("Could not decode textures payload", e2);
            return MinecraftProfileTextures.EMPTY;
        }
        if (result == null || result.textures() == null || result.textures().isEmpty()) {
            return MinecraftProfileTextures.EMPTY;
        }
        Map textures = result.textures();
        for (Map.Entry entry : textures.entrySet()) {
            String url = ((MinecraftProfileTexture)entry.getValue()).getUrl();
            if (TextureUrlChecker.isAllowedTextureDomain((String)url)) continue;
            LOGGER.error("Textures payload contains blocked domain: {}", (Object)url);
            return MinecraftProfileTextures.EMPTY;
        }
        return new MinecraftProfileTextures((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN), (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.CAPE), (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.ELYTRA), signatureState);
    }

    @Nullable
    public ProfileResult fetchProfile(UUID profileId, boolean requireSecure) {
        if (!requireSecure) {
            return ((Optional)this.insecureProfiles.getUnchecked((Object)profileId)).orElse(null);
        }
        return this.fetchProfileUncached(profileId, true);
    }

    public String getSecurePropertyValue(Property property) throws InsecurePublicKeyException {
        switch (this.getPropertySignatureState(property)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UNSIGNED: {
                throw new InsecurePublicKeyException.MissingException("Missing signature from \"" + property.name() + "\"");
            }
            case INVALID: {
                throw new InsecurePublicKeyException.InvalidException("Property \"" + property.name() + "\" has been tampered with (signature invalid)");
            }
            case SIGNED: 
        }
        return property.value();
    }

    private SignatureState getPropertySignatureState(Property property) {
        if (!property.hasSignature()) {
            return SignatureState.UNSIGNED;
        }
        if (this.servicesKeySet.keys(ServicesKeyType.PROFILE_PROPERTY).stream().noneMatch(key -> key.validateProperty(property))) {
            return SignatureState.INVALID;
        }
        return SignatureState.SIGNED;
    }

    @Nullable
    private ProfileResult fetchProfileUncached(UUID profileId, boolean requireSecure) {
        try {
            URL url = HttpAuthenticationService.constantURL((String)(this.baseUrl + "profile/" + UndashedUuid.toString((UUID)profileId)));
            url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure));
            MinecraftProfilePropertiesResponse response = (MinecraftProfilePropertiesResponse)this.client.get(url, MinecraftProfilePropertiesResponse.class);
            if (response == null) {
                LOGGER.debug("Couldn't fetch profile properties for {} as the profile does not exist", (Object)profileId);
                return null;
            }
            GameProfile profile = response.toProfile();
            Set profileActions = response.profileActions().stream().map(ProfileAction::type).collect(Collectors.toSet());
            LOGGER.debug("Successfully fetched profile properties for {}", (Object)profile);
            return new ProfileResult(profile, profileActions);
        }
        catch (MinecraftClientException | IllegalArgumentException e2) {
            LOGGER.warn("Couldn't look up profile properties for {}", (Object)profileId, (Object)e2);
            return null;
        }
    }
}

