/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.util.FormattedString;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.Nullable;

public final class AdventureComponent
implements IChatBaseComponent {
    final Component adventure;
    private @MonotonicNonNull IChatBaseComponent vanilla;

    public AdventureComponent(Component adventure) {
        this.adventure = adventure;
    }

    public IChatBaseComponent deepConverted() {
        IChatBaseComponent vanilla = this.vanilla;
        if (vanilla == null) {
            this.vanilla = vanilla = (IChatBaseComponent)PaperAdventure.WRAPPER_AWARE_SERIALIZER.serialize(this.adventure);
        }
        return vanilla;
    }

    public @Nullable IChatBaseComponent deepConvertedIfPresent() {
        return this.vanilla;
    }

    @Override
    public ChatModifier a() {
        return this.deepConverted().a();
    }

    @Override
    public ComponentContents b() {
        if (this.adventure instanceof TextComponent) {
            return LiteralContents.a(((TextComponent)this.adventure).content());
        }
        return this.deepConverted().b();
    }

    @Override
    public String getString() {
        return PlainTextComponentSerializer.plainText().serialize(this.adventure);
    }

    @Override
    public List<IChatBaseComponent> c() {
        return this.deepConverted().c();
    }

    @Override
    public IChatMutableComponent e() {
        return this.deepConverted().e();
    }

    @Override
    public IChatMutableComponent f() {
        return this.deepConverted().f();
    }

    @Override
    public FormattedString g() {
        return this.deepConverted().g();
    }

    public Component adventure$component() {
        return this.adventure;
    }
}

