/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.util.AttributeKey;
import io.papermc.paper.adventure.AdventureCodecs;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.WrapperAwareSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.JavaOps;
import net.minecraft.world.BossBattle;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R3.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaperAdventure {
    private static final Pattern LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
    public static final ComponentFlattener FLATTENER = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).complexMapper(TranslatableComponent.class, (translatable, consumer) -> {
        if (!LocaleLanguage.a().b(translatable.key())) {
            for (Translator source : GlobalTranslator.translator().sources()) {
                TranslationRegistry registry;
                if (!(source instanceof TranslationRegistry) || !(registry = (TranslationRegistry)source).contains(translatable.key())) continue;
                consumer.accept(GlobalTranslator.render((Component)translatable, (Locale)Locale.US));
                return;
            }
        }
        @Nullable String fallback = translatable.fallback();
        @NotNull String translated = LocaleLanguage.a().a(translatable.key(), fallback != null ? fallback : translatable.key());
        Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
        List args = translatable.arguments();
        int argPosition = 0;
        int lastIdx = 0;
        while (matcher.find()) {
            int idx;
            if (lastIdx < matcher.start()) {
                consumer.accept(Component.text((String)translated.substring(lastIdx, matcher.start())));
            }
            lastIdx = matcher.end();
            @Nullable String argIdx = matcher.group(1);
            if (argIdx != null) {
                try {
                    idx = Integer.parseInt(argIdx) - 1;
                    if (idx >= args.size()) continue;
                    consumer.accept(((TranslationArgument)args.get(idx)).asComponent());
                }
                catch (NumberFormatException idx2) {}
                continue;
            }
            if ((idx = argPosition++) >= args.size()) continue;
            consumer.accept(((TranslationArgument)args.get(idx)).asComponent());
        }
        if (lastIdx < translated.length()) {
            consumer.accept(Component.text((String)translated.substring(lastIdx)));
        }
    }).build();
    public static final AttributeKey<Locale> LOCALE_ATTRIBUTE = AttributeKey.valueOf((String)"adventure:locale");
    @Deprecated
    public static final PlainComponentSerializer PLAIN = (PlainComponentSerializer)PlainComponentSerializer.builder().flattener(FLATTENER).build();
    public static final ANSIComponentSerializer ANSI_SERIALIZER = ANSIComponentSerializer.builder().flattener(FLATTENER).build();
    static final net.kyori.adventure.util.Codec<NBTTagCompound, String, IOException, IOException> NBT_CODEC = new net.kyori.adventure.util.Codec<NBTTagCompound, String, IOException, IOException>(){

        @NotNull
        public NBTTagCompound decode(@NotNull String encoded) throws IOException {
            try {
                return MojangsonParser.a(encoded);
            }
            catch (CommandSyntaxException e2) {
                throw new IOException(e2);
            }
        }

        @NotNull
        public String encode(@NotNull NBTTagCompound decoded) {
            return decoded.toString();
        }
    };
    public static final ComponentSerializer<Component, Component, IChatBaseComponent> WRAPPER_AWARE_SERIALIZER = new WrapperAwareSerializer();
    private static final Map<Locale, Codec<Component>> LOCALIZED_CODECS = new ConcurrentHashMap<Locale, Codec<Component>>();

    private PaperAdventure() {
    }

    public static MinecraftKey asVanilla(Key key) {
        return new MinecraftKey(key.namespace(), key.value());
    }

    public static MinecraftKey asVanillaNullable(Key key) {
        if (key == null) {
            return null;
        }
        return PaperAdventure.asVanilla(key);
    }

    @NotNull
    public static Component asAdventure(@Nullable IChatBaseComponent component) {
        return component == null ? Component.empty() : WRAPPER_AWARE_SERIALIZER.deserialize((Object)component);
    }

    public static ArrayList<Component> asAdventure(List<? extends IChatBaseComponent> vanillas) {
        ArrayList<Component> adventures = new ArrayList<Component>(vanillas.size());
        for (IChatBaseComponent iChatBaseComponent : vanillas) {
            adventures.add(PaperAdventure.asAdventure(iChatBaseComponent));
        }
        return adventures;
    }

    public static ArrayList<Component> asAdventureFromJson(List<String> jsonStrings) {
        ArrayList<Component> adventures = new ArrayList<Component>(jsonStrings.size());
        for (String json : jsonStrings) {
            adventures.add(GsonComponentSerializer.gson().deserialize((Object)json));
        }
        return adventures;
    }

    public static List<String> asJson(List<? extends Component> adventures) {
        ArrayList<String> jsons = new ArrayList<String>(adventures.size());
        for (Component component : adventures) {
            jsons.add((String)GsonComponentSerializer.gson().serialize(component));
        }
        return jsons;
    }

    public static IChatBaseComponent asVanilla(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        return new AdventureComponent(component);
    }

    public static List<IChatBaseComponent> asVanilla(List<? extends Component> adventures) {
        ArrayList<IChatBaseComponent> vanillas = new ArrayList<IChatBaseComponent>(adventures.size());
        for (Component component : adventures) {
            vanillas.add(PaperAdventure.asVanilla(component));
        }
        return vanillas;
    }

    public static String asJsonString(Component component, Locale locale) {
        return (String)GsonComponentSerializer.gson().serialize(PaperAdventure.translated(component, locale));
    }

    public static boolean hasAnyTranslations() {
        return StreamSupport.stream(GlobalTranslator.translator().sources().spliterator(), false).anyMatch(t2 -> t2.hasAnyTranslations().toBooleanOrElse(true));
    }

    public static Codec<Component> localizedCodec(@Nullable Locale l2) {
        if (l2 == null) {
            return AdventureCodecs.COMPONENT_CODEC;
        }
        return LOCALIZED_CODECS.computeIfAbsent(l2, locale -> AdventureCodecs.COMPONENT_CODEC.xmap(component -> component, component -> PaperAdventure.translated(component, locale)));
    }

    public static String asPlain(Component component, Locale locale) {
        return PlainTextComponentSerializer.plainText().serialize(PaperAdventure.translated(component, locale));
    }

    private static Component translated(Component component, Locale locale) {
        return GlobalTranslator.render((Component)component, (Locale)(locale != null ? locale : Locale.US));
    }

    public static Component resolveWithContext(@NotNull Component component, @Nullable CommandSender context, @Nullable Entity scoreboardSubject, boolean bypassPermissions) throws IOException {
        CommandListenerWrapper css = context != null ? VanillaCommandWrapper.getListener(context) : null;
        Boolean previous = null;
        if (css != null && bypassPermissions) {
            previous = css.bypassSelectorPermissions;
            css.bypassSelectorPermissions = true;
        }
        try {
            Component component2 = PaperAdventure.asAdventure(ChatComponentUtils.a(css, PaperAdventure.asVanilla(component), scoreboardSubject == null ? null : ((CraftEntity)scoreboardSubject).getHandle(), 0));
            return component2;
        }
        catch (CommandSyntaxException e2) {
            throw new IOException(e2);
        }
        finally {
            if (css != null && previous != null) {
                css.bypassSelectorPermissions = previous;
            }
        }
    }

    public static BossBattle.BarColor asVanilla(BossBar.Color color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case BossBar.Color.PINK -> BossBattle.BarColor.a;
            case BossBar.Color.BLUE -> BossBattle.BarColor.b;
            case BossBar.Color.RED -> BossBattle.BarColor.c;
            case BossBar.Color.GREEN -> BossBattle.BarColor.d;
            case BossBar.Color.YELLOW -> BossBattle.BarColor.e;
            case BossBar.Color.PURPLE -> BossBattle.BarColor.f;
            case BossBar.Color.WHITE -> BossBattle.BarColor.g;
        };
    }

    public static BossBar.Color asAdventure(BossBattle.BarColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case BossBattle.BarColor.a -> BossBar.Color.PINK;
            case BossBattle.BarColor.b -> BossBar.Color.BLUE;
            case BossBattle.BarColor.c -> BossBar.Color.RED;
            case BossBattle.BarColor.d -> BossBar.Color.GREEN;
            case BossBattle.BarColor.e -> BossBar.Color.YELLOW;
            case BossBattle.BarColor.f -> BossBar.Color.PURPLE;
            case BossBattle.BarColor.g -> BossBar.Color.WHITE;
        };
    }

    public static BossBattle.BarStyle asVanilla(BossBar.Overlay overlay) {
        return switch (overlay) {
            default -> throw new IncompatibleClassChangeError();
            case BossBar.Overlay.PROGRESS -> BossBattle.BarStyle.a;
            case BossBar.Overlay.NOTCHED_6 -> BossBattle.BarStyle.b;
            case BossBar.Overlay.NOTCHED_10 -> BossBattle.BarStyle.c;
            case BossBar.Overlay.NOTCHED_12 -> BossBattle.BarStyle.d;
            case BossBar.Overlay.NOTCHED_20 -> BossBattle.BarStyle.e;
        };
    }

    public static BossBar.Overlay asAdventure(BossBattle.BarStyle overlay) {
        return switch (overlay) {
            default -> throw new IncompatibleClassChangeError();
            case BossBattle.BarStyle.a -> BossBar.Overlay.PROGRESS;
            case BossBattle.BarStyle.b -> BossBar.Overlay.NOTCHED_6;
            case BossBattle.BarStyle.c -> BossBar.Overlay.NOTCHED_10;
            case BossBattle.BarStyle.d -> BossBar.Overlay.NOTCHED_12;
            case BossBattle.BarStyle.e -> BossBar.Overlay.NOTCHED_20;
        };
    }

    public static void setFlag(BossBar bar, BossBar.Flag flag, boolean value) {
        if (value) {
            bar.addFlag(flag);
        } else {
            bar.removeFlag(flag);
        }
    }

    public static ItemStack asItemStack(Book book, Locale locale) {
        ItemStack item = new ItemStack(Items.tU, 1);
        NBTTagCompound tag = item.w();
        tag.a("title", PaperAdventure.validateField(PaperAdventure.asPlain(book.title(), locale), 32, "title"));
        tag.a("author", PaperAdventure.asPlain(book.author(), locale));
        NBTTagList pages = new NBTTagList();
        if (book.pages().size() > 100) {
            throw new IllegalArgumentException("Book provided had " + book.pages().size() + " pages, but is only allowed a maximum of 100");
        }
        for (Component page : book.pages()) {
            pages.add(NBTTagString.a(PaperAdventure.validateField(PaperAdventure.asJsonString(page, locale), Short.MAX_VALUE, "page")));
        }
        tag.a("pages", pages);
        return item;
    }

    private static String validateField(String content, int length, String name) {
        int actual = content.length();
        if (actual > length) {
            throw new IllegalArgumentException("Field '" + name + "' has a maximum length of " + length + " but was passed '" + content + "', which was " + actual + " characters long.");
        }
        return content;
    }

    public static SoundCategory asVanilla(Sound.Source source) {
        return switch (source) {
            default -> throw new IncompatibleClassChangeError();
            case Sound.Source.MASTER -> SoundCategory.a;
            case Sound.Source.MUSIC -> SoundCategory.b;
            case Sound.Source.RECORD -> SoundCategory.c;
            case Sound.Source.WEATHER -> SoundCategory.d;
            case Sound.Source.BLOCK -> SoundCategory.e;
            case Sound.Source.HOSTILE -> SoundCategory.f;
            case Sound.Source.NEUTRAL -> SoundCategory.g;
            case Sound.Source.PLAYER -> SoundCategory.h;
            case Sound.Source.AMBIENT -> SoundCategory.i;
            case Sound.Source.VOICE -> SoundCategory.j;
        };
    }

    @Nullable
    public static SoundCategory asVanillaNullable(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Sound.Source source) {
        if (source == null) {
            return null;
        }
        return PaperAdventure.asVanilla(source);
    }

    public static Packet<?> asSoundPacket(Sound sound, double x2, double y2, double z2, long seed, @Nullable BiConsumer<Packet<?>, Float> packetConsumer) {
        MinecraftKey name = PaperAdventure.asVanilla(sound.name());
        Optional<SoundEffect> soundEvent = BuiltInRegistries.b.b(name);
        SoundCategory source = PaperAdventure.asVanilla(sound.source());
        Holder soundEventHolder = soundEvent.map(BuiltInRegistries.b::d).orElseGet(() -> Holder.a(SoundEffect.a(name)));
        PacketPlayOutNamedSoundEffect packet = new PacketPlayOutNamedSoundEffect(soundEventHolder, source, x2, y2, z2, sound.volume(), sound.pitch(), seed);
        if (packetConsumer != null) {
            packetConsumer.accept(packet, Float.valueOf(((SoundEffect)soundEventHolder.a()).a(sound.volume())));
        }
        return packet;
    }

    public static Packet<?> asSoundPacket(Sound sound, net.minecraft.world.entity.Entity emitter, long seed, @Nullable BiConsumer<Packet<?>, Float> packetConsumer) {
        MinecraftKey name = PaperAdventure.asVanilla(sound.name());
        Optional<SoundEffect> soundEvent = BuiltInRegistries.b.b(name);
        SoundCategory source = PaperAdventure.asVanilla(sound.source());
        Holder soundEventHolder = soundEvent.map(BuiltInRegistries.b::d).orElseGet(() -> Holder.a(SoundEffect.a(name)));
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(soundEventHolder, source, emitter, sound.volume(), sound.pitch(), seed);
        if (packetConsumer != null) {
            packetConsumer.accept(packet, Float.valueOf(((SoundEffect)soundEventHolder.a()).a(sound.volume())));
        }
        return packet;
    }

    @Nullable
    public static BinaryTagHolder asBinaryTagHolder(@Nullable NBTTagCompound tag) {
        if (tag == null) {
            return null;
        }
        try {
            return BinaryTagHolder.encode((Object)tag, NBT_CODEC);
        }
        catch (IOException e2) {
            return null;
        }
    }

    @NotNull
    public static TextColor asAdventure(EnumChatFormat formatting) {
        Integer color = formatting.f();
        if (color == null) {
            throw new IllegalArgumentException("Not a valid color");
        }
        return TextColor.color((int)color);
    }

    @Nullable
    public static EnumChatFormat asVanilla(TextColor color) {
        return EnumChatFormat.getByHexValue(color.value());
    }

    public static ChatModifier asVanilla(Style style) {
        Object encoded = SystemUtils.a(AdventureCodecs.STYLE_MAP_CODEC.codec().encodeStart((DynamicOps)JavaOps.a, (Object)style), IllegalStateException::new);
        return (ChatModifier)SystemUtils.a(ChatModifier.ChatModifierSerializer.b.parse((DynamicOps)JavaOps.a, encoded), IllegalStateException::new);
    }

    public static Style asAdventure(ChatModifier style) {
        Object encoded = SystemUtils.a(ChatModifier.ChatModifierSerializer.b.encodeStart((DynamicOps)JavaOps.a, (Object)style), IllegalStateException::new);
        return (Style)SystemUtils.a(AdventureCodecs.STYLE_MAP_CODEC.codec().parse((DynamicOps)JavaOps.a, encoded), IllegalStateException::new);
    }
}

