/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk;

import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;

public final class SingleThreadChunkRegionManager {
    protected final int regionSectionMergeRadius;
    protected final int regionSectionChunkSize;
    public final int regionChunkShift;
    public final WorldServer world;
    public final String name;
    protected final Long2ObjectOpenHashMap<RegionSection> regionsBySection = new Long2ObjectOpenHashMap();
    protected final ReferenceLinkedOpenHashSet<Region> needsRecalculation = new ReferenceLinkedOpenHashSet();
    protected final int minSectionRecalcCount;
    protected final double maxDeadRegionPercent;
    protected final Supplier<RegionData> regionDataSupplier;
    protected final Supplier<RegionSectionData> regionSectionDataSupplier;
    private final List<Region> toMerge = new ArrayList<Region>();

    public SingleThreadChunkRegionManager(WorldServer world, int minSectionRecalcCount, double maxDeadRegionPercent, int sectionMergeRadius, int regionSectionChunkShift, String name, Supplier<RegionData> regionDataSupplier, Supplier<RegionSectionData> regionSectionDataSupplier) {
        this.regionSectionMergeRadius = sectionMergeRadius;
        this.regionSectionChunkSize = 1 << regionSectionChunkShift;
        this.regionChunkShift = regionSectionChunkShift;
        this.world = world;
        this.name = name;
        this.minSectionRecalcCount = Math.max(2, minSectionRecalcCount);
        this.maxDeadRegionPercent = maxDeadRegionPercent;
        this.regionDataSupplier = regionDataSupplier;
        this.regionSectionDataSupplier = regionSectionDataSupplier;
    }

    protected void addToRecalcQueue(Region region) {
        this.needsRecalculation.add((Object)region);
    }

    protected void removeFromRecalcQueue(Region region) {
        this.needsRecalculation.remove((Object)region);
    }

    public RegionSection getRegionSection(int chunkX, int chunkZ) {
        return (RegionSection)this.regionsBySection.get(MCUtil.getCoordinateKey(chunkX >> this.regionChunkShift, chunkZ >> this.regionChunkShift));
    }

    public Region getRegion(int chunkX, int chunkZ) {
        RegionSection section = (RegionSection)this.regionsBySection.get(MCUtil.getCoordinateKey(chunkX >> this.regionChunkShift, chunkZ >> this.regionChunkShift));
        return section != null ? section.region : null;
    }

    protected RegionSection getOrCreateAndMergeSection(int sectionX, int sectionZ, RegionSection force) {
        RegionSection section;
        RegionSection region;
        long sectionKey = MCUtil.getCoordinateKey(sectionX, sectionZ);
        if (force == null && (region = (RegionSection)this.regionsBySection.get(sectionKey)) != null) {
            return region;
        }
        int mergeCandidateSectionSize = -1;
        Region mergeIntoCandidate = null;
        int minX = sectionX - this.regionSectionMergeRadius;
        int maxX = sectionX + this.regionSectionMergeRadius;
        int minZ = sectionZ - this.regionSectionMergeRadius;
        int maxZ = sectionZ + this.regionSectionMergeRadius;
        for (int currX = minX; currX <= maxX; ++currX) {
            for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                RegionSection section2 = (RegionSection)this.regionsBySection.get(MCUtil.getCoordinateKey(currX, currZ));
                if (section2 == null) continue;
                Region region2 = section2.region;
                if (region2.dead) {
                    throw new IllegalStateException("Dead region should not be in live region manager state: " + region2);
                }
                int sections = region2.sections.size();
                if (sections > mergeCandidateSectionSize) {
                    mergeCandidateSectionSize = sections;
                    mergeIntoCandidate = region2;
                }
                this.toMerge.add(region2);
            }
        }
        if (mergeIntoCandidate != null) {
            for (int i2 = 0; i2 < this.toMerge.size(); ++i2) {
                Region region3 = this.toMerge.get(i2);
                if (region3.dead || mergeIntoCandidate == region3) continue;
                region3.mergeInto(mergeIntoCandidate);
            }
            this.toMerge.clear();
        } else {
            mergeIntoCandidate = new Region(this);
        }
        if (force == null) {
            section = new RegionSection(sectionKey, this);
            this.regionsBySection.put(sectionKey, (Object)section);
        } else {
            RegionSection existing = (RegionSection)this.regionsBySection.putIfAbsent(sectionKey, (Object)force);
            if (existing != null) {
                throw new IllegalStateException("Attempting to override section '" + existing.toStringWithRegion() + ", with " + force.toStringWithRegion());
            }
            section = force;
        }
        mergeIntoCandidate.addRegionSection(section);
        return section;
    }

    public void addChunk(int chunkX, int chunkZ) {
        this.getOrCreateAndMergeSection(chunkX >> this.regionChunkShift, chunkZ >> this.regionChunkShift, null).addChunk(chunkX, chunkZ);
    }

    public void removeChunk(int chunkX, int chunkZ) {
        RegionSection section = (RegionSection)this.regionsBySection.get(MCUtil.getCoordinateKey(chunkX >> this.regionChunkShift, chunkZ >> this.regionChunkShift));
        if (section == null) {
            throw new IllegalStateException("Cannot remove chunk at (" + chunkX + "," + chunkZ + ") from region state, section does not exist");
        }
        section.removeChunk(chunkX, chunkZ);
    }

    public void recalculateRegions() {
        int len = this.needsRecalculation.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Region region = (Region)this.needsRecalculation.removeFirst();
            this.recalculateRegion(region);
        }
    }

    protected void recalculateRegion(Region region) {
        RegionSection aliveSection;
        region.markedForRecalc = false;
        for (RegionSection deadSection : region.deadSections) {
            if (deadSection.hasChunks()) {
                throw new IllegalStateException("Dead section '" + deadSection.toStringWithRegion() + "' is marked dead but has chunks!");
            }
            if (!region.removeRegionSection(deadSection)) {
                throw new IllegalStateException("Region " + region + " has inconsistent state, it should contain section " + deadSection);
            }
            if (this.regionsBySection.remove(deadSection.regionCoordinate, (Object)deadSection)) continue;
            throw new IllegalStateException("Cannot remove dead section '" + deadSection.toStringWithRegion() + "' from section state! State at section coordinate: " + this.regionsBySection.get(deadSection.regionCoordinate));
        }
        region.deadSections.clear();
        if (region.sections.size() < this.minSectionRecalcCount) {
            return;
        }
        region.dead = true;
        Object iterator = region.sections.unsafeIterator(1);
        while (iterator.hasNext()) {
            aliveSection = (RegionSection)iterator.next();
            if (!aliveSection.hasChunks()) {
                throw new IllegalStateException("Alive section '" + aliveSection.toStringWithRegion() + "' has no chunks!");
            }
            if (this.regionsBySection.remove(aliveSection.regionCoordinate, (Object)aliveSection)) continue;
            throw new IllegalStateException("Cannot remove alive section '" + aliveSection.toStringWithRegion() + "' from section state! State at section coordinate: " + this.regionsBySection.get(aliveSection.regionCoordinate));
        }
        iterator = region.sections.unsafeIterator(1);
        while (iterator.hasNext()) {
            aliveSection = (RegionSection)iterator.next();
            this.getOrCreateAndMergeSection(aliveSection.getSectionX(), aliveSection.getSectionZ(), aliveSection);
        }
    }

    public static final class RegionSection {
        protected final long regionCoordinate;
        protected final long[] chunksBitset;
        protected int chunkCount;
        protected Region region;
        public final SingleThreadChunkRegionManager regionManager;
        public final RegionSectionData sectionData;

        protected RegionSection(long regionCoordinate, SingleThreadChunkRegionManager regionManager) {
            this.regionCoordinate = regionCoordinate;
            this.regionManager = regionManager;
            this.chunksBitset = new long[Math.max(1, regionManager.regionSectionChunkSize * regionManager.regionSectionChunkSize / 64)];
            this.sectionData = regionManager.regionSectionDataSupplier.get();
        }

        public int getSectionX() {
            return MCUtil.getCoordinateX(this.regionCoordinate);
        }

        public int getSectionZ() {
            return MCUtil.getCoordinateZ(this.regionCoordinate);
        }

        public Region getRegion() {
            return this.region;
        }

        private int getChunkIndex(int chunkX, int chunkZ) {
            return chunkX & this.regionManager.regionSectionChunkSize - 1 | (chunkZ & this.regionManager.regionSectionChunkSize - 1) << this.regionManager.regionChunkShift;
        }

        protected boolean hasChunks() {
            return this.chunkCount != 0;
        }

        protected void addChunk(int chunkX, int chunkZ) {
            int index;
            long bitset = this.chunksBitset[index >>> 6];
            this.chunksBitset[(index = this.getChunkIndex((int)chunkX, (int)chunkZ)) >>> 6] = bitset | 1L << (index & 0x3F);
            long after = this.chunksBitset[(index = this.getChunkIndex((int)chunkX, (int)chunkZ)) >>> 6];
            if (after == bitset) {
                throw new IllegalStateException("Cannot add a chunk to a section which already has the chunk! RegionSection: " + this + ", global chunk: " + new ChunkCoordIntPair(chunkX, chunkZ).toString());
            }
            if (++this.chunkCount != 1) {
                return;
            }
            this.region.markSectionAlive(this);
        }

        protected void removeChunk(int chunkX, int chunkZ) {
            long bitset;
            int index = this.getChunkIndex(chunkX, chunkZ);
            long before = this.chunksBitset[index >>> 6];
            if (before == (bitset = (this.chunksBitset[index >>> 6] = before & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL)))) {
                throw new IllegalStateException("Cannot remove a chunk from a section which does not have that chunk! RegionSection: " + this + ", global chunk: " + new ChunkCoordIntPair(chunkX, chunkZ).toString());
            }
            if (--this.chunkCount != 0) {
                return;
            }
            this.region.markSectionDead(this);
        }

        public String toString() {
            return "RegionSection{regionCoordinate=" + new ChunkCoordIntPair(this.regionCoordinate).toString() + ",chunkCount=" + this.chunkCount + ",chunksBitset=" + RegionSection.toString(this.chunksBitset) + ",hash=" + this.hashCode() + "}";
        }

        public String toStringWithRegion() {
            return "RegionSection{regionCoordinate=" + new ChunkCoordIntPair(this.regionCoordinate).toString() + ",chunkCount=" + this.chunkCount + ",chunksBitset=" + RegionSection.toString(this.chunksBitset) + ",hash=" + this.hashCode() + ",region=" + this.region + "}";
        }

        private static String toString(long[] array) {
            StringBuilder ret = new StringBuilder();
            for (long value : array) {
                char[] zeros = new char[16];
                Arrays.fill(zeros, '0');
                String string = Long.toHexString(value);
                System.arraycopy(string.toCharArray(), 0, zeros, zeros.length - string.length(), string.length());
                ret.append(zeros);
            }
            return ret.toString();
        }
    }

    public static final class Region {
        protected final IteratorSafeOrderedReferenceSet<RegionSection> sections = new IteratorSafeOrderedReferenceSet();
        protected final ReferenceOpenHashSet<RegionSection> deadSections = new ReferenceOpenHashSet(16, 0.7f);
        protected boolean dead;
        protected boolean markedForRecalc;
        public final SingleThreadChunkRegionManager regionManager;
        public final RegionData regionData;

        protected Region(SingleThreadChunkRegionManager regionManager) {
            this.regionManager = regionManager;
            this.regionData = regionManager.regionDataSupplier.get();
        }

        public IteratorSafeOrderedReferenceSet.Iterator<RegionSection> getSections() {
            return this.sections.iterator(1);
        }

        protected final double getDeadSectionPercent() {
            return (double)this.deadSections.size() / (double)this.sections.size();
        }

        protected final boolean addRegionSection(RegionSection section) {
            if (!this.sections.add(section)) {
                return false;
            }
            section.sectionData.addToRegion(section, section.region, this);
            section.region = this;
            return true;
        }

        protected final boolean removeRegionSection(RegionSection section) {
            if (!this.sections.remove(section)) {
                return false;
            }
            section.sectionData.removeFromRegion(section, this);
            return true;
        }

        protected void mergeInto(Region mergeTarget) {
            if (this == mergeTarget) {
                throw new IllegalStateException("Cannot merge a region onto itself");
            }
            if (this.dead) {
                throw new IllegalStateException("Source region is dead! Source " + this + ", target " + mergeTarget);
            }
            if (mergeTarget.dead) {
                throw new IllegalStateException("Target region is dead! Source " + this + ", target " + mergeTarget);
            }
            this.dead = true;
            if (this.markedForRecalc) {
                this.regionManager.removeFromRecalcQueue(this);
            }
            Iterator<RegionSection> iterator = this.sections.unsafeIterator(1);
            while (iterator.hasNext()) {
                RegionSection section = iterator.next();
                if (mergeTarget.addRegionSection(section)) continue;
                throw new IllegalStateException("Target cannot contain source's sections! Source " + this + ", target " + mergeTarget);
            }
            for (RegionSection deadSection : this.deadSections) {
                if (!this.sections.contains(deadSection)) {
                    throw new IllegalStateException("Source region does not even contain its own dead sections! Missing " + deadSection + " from region " + this);
                }
                mergeTarget.deadSections.add((Object)deadSection);
            }
        }

        protected void markSectionAlive(RegionSection section) {
            this.deadSections.remove((Object)section);
            if (this.markedForRecalc && (this.sections.size() < this.regionManager.minSectionRecalcCount || this.getDeadSectionPercent() < this.regionManager.maxDeadRegionPercent)) {
                this.regionManager.removeFromRecalcQueue(this);
                this.markedForRecalc = false;
            }
        }

        protected void markSectionDead(RegionSection section) {
            this.deadSections.add((Object)section);
            if (!this.markedForRecalc && (this.sections.size() >= this.regionManager.minSectionRecalcCount || this.sections.size() == this.deadSections.size()) && this.getDeadSectionPercent() >= this.regionManager.maxDeadRegionPercent) {
                this.regionManager.addToRecalcQueue(this);
                this.markedForRecalc = true;
            }
        }

        public String toString() {
            StringBuilder ret = new StringBuilder(128);
            ret.append("Region{");
            ret.append("dead=").append(this.dead).append(',');
            ret.append("markedForRecalc=").append(this.markedForRecalc).append(',');
            ret.append("sectionCount=").append(this.sections.size()).append(',');
            ret.append("sections=[");
            Iterator<RegionSection> iterator = this.sections.unsafeIterator(1);
            while (iterator.hasNext()) {
                RegionSection section = iterator.next();
                ret.append(section);
                if (!iterator.hasNext()) continue;
                ret.append(',');
            }
            ret.append(']');
            ret.append('}');
            return ret.toString();
        }
    }

    public static interface RegionSectionData {
        public void removeFromRegion(RegionSection var1, Region var2);

        public void addToRegion(RegionSection var1, Region var2, Region var3);
    }

    public static interface RegionData {
    }
}

