/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.slf4j.Logger;

public final class ChunkSystem {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void scheduleChunkTask(WorldServer level, int chunkX, int chunkZ, Runnable run) {
        ChunkSystem.scheduleChunkTask(level, chunkX, chunkZ, run, PrioritisedExecutor.Priority.NORMAL);
    }

    public static void scheduleChunkTask(WorldServer level, int chunkX, int chunkZ, Runnable run, PrioritisedExecutor.Priority priority) {
        level.chunkTaskScheduler.scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    public static void scheduleChunkLoad(WorldServer level, int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<IChunkAccess> onComplete) {
        level.chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleChunkLoad(WorldServer level, int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<IChunkAccess> onComplete) {
        level.chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleTickingState(WorldServer level, int chunkX, int chunkZ, FullChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<Chunk> onComplete) {
        level.chunkTaskScheduler.scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static List<PlayerChunk> getVisibleChunkHolders(WorldServer level) {
        return level.chunkTaskScheduler.chunkHolderManager.getOldChunkHolders();
    }

    public static List<PlayerChunk> getUpdatingChunkHolders(WorldServer level) {
        return level.chunkTaskScheduler.chunkHolderManager.getOldChunkHolders();
    }

    public static int getVisibleChunkHolderCount(WorldServer level) {
        return level.chunkTaskScheduler.chunkHolderManager.size();
    }

    public static int getUpdatingChunkHolderCount(WorldServer level) {
        return level.chunkTaskScheduler.chunkHolderManager.size();
    }

    public static boolean hasAnyChunkHolders(WorldServer level) {
        return ChunkSystem.getUpdatingChunkHolderCount(level) != 0;
    }

    public static void onEntityPreAdd(WorldServer level, Entity entity) {
    }

    public static void onChunkHolderCreate(WorldServer level, PlayerChunk holder) {
        PlayerChunkMap chunkMap = level.I.a;
        int len = chunkMap.regionManagers.size();
        for (int index = 0; index < len; ++index) {
            chunkMap.regionManagers.get(index).addChunk(holder.l().e, holder.l().f);
        }
    }

    public static void onChunkHolderDelete(WorldServer level, PlayerChunk holder) {
        PlayerChunkMap chunkMap = level.I.a;
        int len = chunkMap.regionManagers.size();
        for (int index = 0; index < len; ++index) {
            chunkMap.regionManagers.get(index).removeChunk(holder.l().e, holder.l().f);
        }
    }

    public static void onChunkBorder(Chunk chunk, PlayerChunk holder) {
        chunk.playerChunk = holder;
        chunk.chunkStatus = FullChunkStatus.b;
    }

    public static void onChunkNotBorder(Chunk chunk, PlayerChunk holder) {
        chunk.chunkStatus = FullChunkStatus.a;
    }

    public static void onChunkTicking(Chunk chunk, PlayerChunk holder) {
        chunk.r.l().tickingChunks.add(chunk);
        chunk.chunkStatus = FullChunkStatus.c;
    }

    public static void onChunkNotTicking(Chunk chunk, PlayerChunk holder) {
        chunk.r.l().tickingChunks.remove(chunk);
        chunk.chunkStatus = FullChunkStatus.b;
    }

    public static void onChunkEntityTicking(Chunk chunk, PlayerChunk holder) {
        chunk.r.l().entityTickingChunks.add(chunk);
        chunk.chunkStatus = FullChunkStatus.d;
    }

    public static void onChunkNotEntityTicking(Chunk chunk, PlayerChunk holder) {
        chunk.r.l().entityTickingChunks.remove(chunk);
        chunk.chunkStatus = FullChunkStatus.c;
    }

    public static PlayerChunk getUnloadingChunkHolder(WorldServer level, int chunkX, int chunkZ) {
        return level.I.a.getUnloadingChunkHolder(chunkX, chunkZ);
    }

    public static int getSendViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    public static int getLoadViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getLoadViewDistance(player);
    }

    public static int getTickViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    private ChunkSystem() {
        throw new RuntimeException();
    }
}

