/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EnumCreatureType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public final class StringRepresentableSerializer
extends ScalarSerializer<INamable> {
    private static final Map<Type, Function<String, INamable>> TYPES = Collections.synchronizedMap(Map.ofEntries(StringRepresentableSerializer.createEntry(EnumCreatureType.class)));

    public StringRepresentableSerializer() {
        super(INamable.class);
    }

    public static boolean isValidFor(Type type) {
        return TYPES.containsKey(type);
    }

    private static <E extends Enum<E>> Map.Entry<Type, Function<String, @Nullable INamable>> createEntry(Class<E> type) {
        return Map.entry(type, s2 -> {
            for (Enum value : (Enum[])type.getEnumConstants()) {
                if (!((INamable)((Object)value)).c().equals(s2)) continue;
                return (INamable)((Object)value);
            }
            return null;
        });
    }

    public INamable deserialize(Type type, Object obj) throws SerializationException {
        Function<String, INamable> function = TYPES.get(type);
        if (function == null) {
            throw new SerializationException(type + " isn't registered");
        }
        return function.apply(obj.toString());
    }

    protected Object serialize(INamable item, Predicate<Class<?>> typeSupported) {
        return item.c();
    }
}

