/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datapack;

import io.papermc.paper.datapack.Datapack;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.ResourcePackLoader;

public class PaperDatapack
implements Datapack {
    private final String name;
    private final Datapack.Compatibility compatibility;
    private final boolean enabled;

    PaperDatapack(ResourcePackLoader loader, boolean enabled) {
        this.name = loader.f();
        this.compatibility = Datapack.Compatibility.valueOf((String)loader.c().name());
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public Datapack.Compatibility getCompatibility() {
        return this.compatibility;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        List<String> enabledKeys = server.aD().f().stream().map(ResourcePackLoader::f).collect(Collectors.toList());
        if (enabled) {
            enabledKeys.add(this.name);
        } else {
            enabledKeys.remove(this.name);
        }
        server.reloadResources(enabledKeys, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }
}

