/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.source;

import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.entrypoint.EntrypointHandler;
import io.papermc.paper.plugin.provider.source.FileProviderSource;
import io.papermc.paper.plugin.provider.source.ProviderSource;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class DirectoryProviderSource
implements ProviderSource<Path, List<Path>> {
    public static final DirectoryProviderSource INSTANCE = new DirectoryProviderSource();
    private static final FileProviderSource FILE_PROVIDER_SOURCE = new FileProviderSource(arg_0 -> DirectoryProviderSource.lambda$static$0("Directory '%s'", arg_0));
    private static final Logger LOGGER = LogUtils.getClassLogger();

    @Override
    public List<Path> prepareContext(Path context) throws IOException {
        if (!Files.isDirectory(context, new LinkOption[0])) {
            Files.createDirectories(context, new FileAttribute[0]);
        }
        ArrayList<Path> files = new ArrayList<Path>();
        this.walkFiles(context, path -> {
            try {
                files.add(FILE_PROVIDER_SOURCE.prepareContext((Path)path));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception e2) {
                LOGGER.error("Error preparing plugin context: " + e2.getMessage(), (Throwable)e2);
            }
        });
        return files;
    }

    @Override
    public void registerProviders(EntrypointHandler entrypointHandler, List<Path> context) {
        for (Path path : context) {
            try {
                FILE_PROVIDER_SOURCE.registerProviders(entrypointHandler, path);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception e2) {
                LOGGER.error("Error loading plugin: " + e2.getMessage(), (Throwable)e2);
            }
        }
    }

    private void walkFiles(Path context, Consumer<Path> consumer) throws IOException {
        Files.walk(context, 1, FileVisitOption.FOLLOW_LINKS).filter(this::isValidFile).forEach(consumer);
    }

    public boolean isValidFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && !path.startsWith(".");
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return "Directory '%s'".formatted(xva$0);
    }
}

