/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.destroystokyo.paper.util.SneakyThrow;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_20_R3.CraftCrashReport;
import org.slf4j.Logger;

public class CrashReport {
    private static final Logger a = LogUtils.getLogger();
    private static final DateTimeFormatter b = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    private final String c;
    private final Throwable d;
    private final List<CrashReportSystemDetails> e = Lists.newArrayList();
    @Nullable
    private File f;
    private boolean g = true;
    private StackTraceElement[] h = new StackTraceElement[0];
    private final SystemReport i = new SystemReport();

    public CrashReport(String message, Throwable cause) {
        StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(cause);
        this.c = message;
        this.d = cause;
        this.i.a("CraftBukkit Information", new CraftCrashReport());
    }

    public String a() {
        return this.c;
    }

    public Throwable b() {
        return this.d;
    }

    public String c() {
        StringBuilder stringbuilder = new StringBuilder();
        this.a(stringbuilder);
        return stringbuilder.toString();
    }

    public void a(StringBuilder crashReportBuilder) {
        if (!(this.h != null && this.h.length > 0 || this.e.isEmpty())) {
            this.h = (StackTraceElement[])ArrayUtils.subarray((Object[])this.e.get(0).a(), (int)0, (int)1);
        }
        if (this.h != null && this.h.length > 0) {
            crashReportBuilder.append("-- Head --\n");
            crashReportBuilder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            crashReportBuilder.append("Stacktrace:\n");
            for (StackTraceElement stacktraceelement : this.h) {
                crashReportBuilder.append("\t").append("at ").append(stacktraceelement);
                crashReportBuilder.append("\n");
            }
            crashReportBuilder.append("\n");
        }
        for (CrashReportSystemDetails crashreportsystemdetails : this.e) {
            crashreportsystemdetails.a(crashReportBuilder);
            crashReportBuilder.append("\n\n");
        }
        this.i.a(crashReportBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String d() {
        String s2;
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        Throwable object = this.d;
        if (object.getMessage() == null) {
            if (object instanceof NullPointerException) {
                object = new NullPointerException(this.c);
            } else if (object instanceof StackOverflowError) {
                object = new StackOverflowError(this.c);
            } else if (object instanceof OutOfMemoryError) {
                object = new OutOfMemoryError(this.c);
            }
            object.setStackTrace(this.d.getStackTrace());
        }
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            object.printStackTrace(printwriter);
            s2 = stringwriter.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Writer)stringwriter);
            IOUtils.closeQuietly(printwriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)stringwriter);
        IOUtils.closeQuietly((Writer)printwriter);
        return s2;
    }

    public String e() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Crash Report ----\n");
        stringbuilder.append("// ");
        stringbuilder.append(CrashReport.i());
        stringbuilder.append("\n\n");
        stringbuilder.append("Time: ");
        stringbuilder.append(b.format(ZonedDateTime.now()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.c);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.d());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i2 = 0; i2 < 87; ++i2) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.a(stringbuilder);
        return stringbuilder.toString();
    }

    @Nullable
    public File f() {
        return this.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean a(File file) {
        boolean bl;
        if (this.f != null) {
            return false;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        OutputStreamWriter outputstreamwriter = null;
        try {
            boolean flag1;
            outputstreamwriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            outputstreamwriter.write(this.e());
            this.f = file;
            bl = flag1 = true;
        }
        catch (Throwable throwable) {
            boolean flag;
            try {
                a.error("Could not save crash report to {}", (Object)file, (Object)throwable);
                flag = false;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(outputstreamwriter);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)outputstreamwriter);
            return flag;
        }
        IOUtils.closeQuietly((Writer)outputstreamwriter);
        return bl;
    }

    public SystemReport g() {
        return this.i;
    }

    public CrashReportSystemDetails a(String name) {
        return this.a(name, 1);
    }

    public CrashReportSystemDetails a(String name, int ignoredStackTraceCallCount) {
        CrashReportSystemDetails crashreportsystemdetails = new CrashReportSystemDetails(name);
        if (this.g) {
            int j2 = crashreportsystemdetails.a(ignoredStackTraceCallCount);
            StackTraceElement[] astacktraceelement = this.d.getStackTrace();
            StackTraceElement stacktraceelement = null;
            StackTraceElement stacktraceelement1 = null;
            int k2 = astacktraceelement.length - j2;
            if (k2 < 0) {
                a.error("Negative index in crash report handler ({}/{})", (Object)astacktraceelement.length, (Object)j2);
            }
            if (astacktraceelement != null && 0 <= k2 && k2 < astacktraceelement.length) {
                stacktraceelement = astacktraceelement[k2];
                if (astacktraceelement.length + 1 - j2 < astacktraceelement.length) {
                    stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - j2];
                }
            }
            this.g = crashreportsystemdetails.a(stacktraceelement, stacktraceelement1);
            if (astacktraceelement != null && astacktraceelement.length >= j2 && 0 <= k2 && k2 < astacktraceelement.length) {
                this.h = new StackTraceElement[k2];
                System.arraycopy(astacktraceelement, 0, this.h, 0, this.h.length);
            } else {
                this.g = false;
            }
        }
        this.e.add(crashreportsystemdetails);
        return crashreportsystemdetails;
    }

    private static String i() {
        String[] astring = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!", "But it works on my machine."};
        try {
            return astring[(int)(SystemUtils.c() % (long)astring.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport a(Throwable cause, String title) {
        CrashReport crashreport;
        if (cause instanceof ThreadDeath) {
            SneakyThrow.sneaky((Throwable)cause);
        }
        while (cause instanceof CompletionException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)cause;
            crashreport = reportedexception.a();
        } else {
            crashreport = new CrashReport(title, cause);
        }
        return crashreport;
    }

    public static void h() {
        new CrashReport("Don't panic!", new Throwable()).e();
    }
}

