/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import top.leavesmc.leaves.LeavesConfig;

public record Advancement(Optional<MinecraftKey> b, Optional<AdvancementDisplay> c, AdvancementRewards d, Map<String, Criterion<?>> e, AdvancementRequirements f, boolean g, Optional<IChatBaseComponent> h) {
    private static final Codec<Map<String, Criterion<?>>> i = ExtraCodecs.a(Codec.unboundedMap((Codec)Codec.STRING, Criterion.a), (T criteria) -> criteria.isEmpty() ? DataResult.error(() -> "Advancement criteria cannot be empty") : DataResult.success((Object)criteria));
    public static final Codec<Advancement> a = ExtraCodecs.a(RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(MinecraftKey.a, "parent").forGetter(Advancement::b), (App)ExtraCodecs.a(AdvancementDisplay.a, "display").forGetter(Advancement::c), (App)ExtraCodecs.a(AdvancementRewards.a, "rewards", AdvancementRewards.b).forGetter(Advancement::d), (App)i.fieldOf("criteria").forGetter(Advancement::e), (App)ExtraCodecs.a(AdvancementRequirements.a, "requirements").forGetter(advancement -> Optional.of(advancement.f())), (App)ExtraCodecs.a(Codec.BOOL, "sends_telemetry_event", false).forGetter(Advancement::g)).apply((Applicative)instance, (parent, display, rewards, criteria, requirements, sendsTelemetryEvent) -> {
        AdvancementRequirements advancementRequirements = requirements.orElseGet(() -> AdvancementRequirements.a(criteria.keySet()));
        return new Advancement((Optional<MinecraftKey>)parent, (Optional<AdvancementDisplay>)display, (AdvancementRewards)rewards, (Map<String, Criterion<?>>)criteria, advancementRequirements, (boolean)sendsTelemetryEvent);
    })), Advancement::a);

    public Advancement(Optional<MinecraftKey> parent, Optional<AdvancementDisplay> display, AdvancementRewards rewards, Map<String, Criterion<?>> criteria, AdvancementRequirements requirements, boolean sendsTelemetryEvent) {
        this(parent, display, rewards, !LeavesConfig.skipCloningAdvancementCriteria ? Map.copyOf(criteria) : criteria, requirements, sendsTelemetryEvent, display.map(Advancement::a));
    }

    private static DataResult<Advancement> a(Advancement advancement) {
        return advancement.f().a(advancement.e().keySet()).map(validated -> advancement);
    }

    public static IChatBaseComponent a(AdvancementDisplay display) {
        IChatBaseComponent component = display.a();
        EnumChatFormat chatFormatting = display.e().a();
        IChatMutableComponent component2 = ChatComponentUtils.a(component.f(), ChatModifier.a.a(chatFormatting)).f("\n").b(display.b());
        IChatMutableComponent component3 = component.f().a(style -> style.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, component2)));
        return ChatComponentUtils.a(component3).a(chatFormatting);
    }

    public static IChatBaseComponent a(AdvancementHolder identifiedAdvancement) {
        return identifiedAdvancement.b().h().orElseGet(() -> IChatBaseComponent.b(identifiedAdvancement.a().toString()));
    }

    public void a(PacketDataSerializer buf) {
        buf.a(this.b, PacketDataSerializer::a);
        buf.a(this.c, (bufx, display) -> display.a((PacketDataSerializer)((Object)bufx)));
        this.f.a(buf);
        buf.a(this.g);
    }

    public static Advancement b(PacketDataSerializer buf) {
        return new Advancement(buf.b(PacketDataSerializer::t), buf.b(AdvancementDisplay::b), AdvancementRewards.b, Map.of(), new AdvancementRequirements(buf), buf.readBoolean());
    }

    public boolean a() {
        return this.b.isEmpty();
    }

    public void a(ProblemReporter errorReporter, LootDataResolver conditionsLookup) {
        this.e.forEach((name, criterion) -> {
            CriterionValidator criterionValidator = new CriterionValidator(errorReporter.a((String)name), conditionsLookup);
            criterion.b().a(criterionValidator);
        });
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "b", "c", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "b", "c", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "b", "c", "d", "e", "f", "g", "h"}, this, o2);
    }

    public static class SerializedAdvancement {
        private Optional<MinecraftKey> a = Optional.empty();
        private Optional<AdvancementDisplay> b = Optional.empty();
        private AdvancementRewards c = AdvancementRewards.b;
        private final ImmutableMap.Builder<String, Criterion<?>> d = ImmutableMap.builder();
        private Optional<AdvancementRequirements> e = Optional.empty();
        private AdvancementRequirements.a f = AdvancementRequirements.a.a;
        private boolean g;

        public static SerializedAdvancement a() {
            return new SerializedAdvancement().c();
        }

        public static SerializedAdvancement b() {
            return new SerializedAdvancement();
        }

        public SerializedAdvancement a(AdvancementHolder parent) {
            this.a = Optional.of(parent.a());
            return this;
        }

        @Deprecated(forRemoval=true)
        public SerializedAdvancement a(MinecraftKey parentId) {
            this.a = Optional.of(parentId);
            return this;
        }

        public SerializedAdvancement a(ItemStack icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.a(new AdvancementDisplay(icon, title, description, Optional.ofNullable(background), frame, showToast, announceToChat, hidden));
        }

        public SerializedAdvancement a(IMaterial icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.a(new AdvancementDisplay(new ItemStack(icon.k()), title, description, Optional.ofNullable(background), frame, showToast, announceToChat, hidden));
        }

        public SerializedAdvancement a(AdvancementDisplay display) {
            this.b = Optional.of(display);
            return this;
        }

        public SerializedAdvancement a(AdvancementRewards.a builder) {
            return this.a(builder.a());
        }

        public SerializedAdvancement a(AdvancementRewards rewards) {
            this.c = rewards;
            return this;
        }

        public SerializedAdvancement a(String name, Criterion<?> criterion) {
            this.d.put((Object)name, criterion);
            return this;
        }

        public SerializedAdvancement a(AdvancementRequirements.a merger) {
            this.f = merger;
            return this;
        }

        public SerializedAdvancement a(AdvancementRequirements requirements) {
            this.e = Optional.of(requirements);
            return this;
        }

        public SerializedAdvancement c() {
            this.g = true;
            return this;
        }

        public AdvancementHolder b(MinecraftKey id) {
            ImmutableMap map = this.d.buildOrThrow();
            AdvancementRequirements advancementRequirements = this.e.orElseGet(() -> this.a((Map)map));
            return new AdvancementHolder(id, new Advancement(this.a, this.b, this.c, (Map<String, Criterion<?>>)map, advancementRequirements, this.g));
        }

        public AdvancementHolder a(Consumer<AdvancementHolder> exporter, String id) {
            AdvancementHolder advancementHolder = this.b(new MinecraftKey(id));
            exporter.accept(advancementHolder);
            return advancementHolder;
        }

        private /* synthetic */ AdvancementRequirements a(Map map) {
            return this.f.create(map.keySet());
        }
    }
}

