/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionDistance;
import net.minecraft.advancements.critereon.CriterionConditionEntityEquipment;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionEntityType;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionConditionMobEffect;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;

public final class CriterionConditionEntity
extends Record {
    private final Optional<CriterionConditionEntityType> c;
    private final Optional<CriterionConditionDistance> d;
    private final Optional<CriterionConditionLocation> e;
    private final Optional<CriterionConditionLocation> f;
    private final Optional<CriterionConditionMobEffect> g;
    private final Optional<CriterionConditionNBT> h;
    private final Optional<CriterionConditionEntityFlags> i;
    private final Optional<CriterionConditionEntityEquipment> j;
    private final Optional<EntitySubPredicate> k;
    private final Optional<CriterionConditionEntity> l;
    private final Optional<CriterionConditionEntity> m;
    private final Optional<CriterionConditionEntity> n;
    private final Optional<String> o;
    public static final Codec<CriterionConditionEntity> a = ExtraCodecs.a("EntityPredicate", (Codec<T> entityPredicateCodec) -> RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(CriterionConditionEntityType.a, "type").forGetter(CriterionConditionEntity::a), (App)ExtraCodecs.a(CriterionConditionDistance.a, "distance").forGetter(CriterionConditionEntity::b), (App)ExtraCodecs.a(CriterionConditionLocation.a, "location").forGetter(CriterionConditionEntity::c), (App)ExtraCodecs.a(CriterionConditionLocation.a, "stepping_on").forGetter(CriterionConditionEntity::d), (App)ExtraCodecs.a(CriterionConditionMobEffect.a, "effects").forGetter(CriterionConditionEntity::e), (App)ExtraCodecs.a(CriterionConditionNBT.a, "nbt").forGetter(CriterionConditionEntity::f), (App)ExtraCodecs.a(CriterionConditionEntityFlags.a, "flags").forGetter(CriterionConditionEntity::g), (App)ExtraCodecs.a(CriterionConditionEntityEquipment.a, "equipment").forGetter(CriterionConditionEntity::h), (App)ExtraCodecs.a(EntitySubPredicate.a, "type_specific").forGetter(CriterionConditionEntity::i), (App)ExtraCodecs.a(entityPredicateCodec, "vehicle").forGetter(CriterionConditionEntity::j), (App)ExtraCodecs.a(entityPredicateCodec, "passenger").forGetter(CriterionConditionEntity::k), (App)ExtraCodecs.a(entityPredicateCodec, "targeted_entity").forGetter(CriterionConditionEntity::l), (App)ExtraCodecs.a(Codec.STRING, "team").forGetter(CriterionConditionEntity::m)).apply((Applicative)instance, CriterionConditionEntity::new)));
    public static final Codec<ContextAwarePredicate> b = ExtraCodecs.a(ContextAwarePredicate.a, a, CriterionConditionEntity::a);

    public CriterionConditionEntity(Optional<CriterionConditionEntityType> optional, Optional<CriterionConditionDistance> optional2, Optional<CriterionConditionLocation> optional3, Optional<CriterionConditionLocation> optional4, Optional<CriterionConditionMobEffect> optional5, Optional<CriterionConditionNBT> optional6, Optional<CriterionConditionEntityFlags> optional7, Optional<CriterionConditionEntityEquipment> optional8, Optional<EntitySubPredicate> optional9, Optional<CriterionConditionEntity> optional10, Optional<CriterionConditionEntity> optional11, Optional<CriterionConditionEntity> optional12, Optional<String> optional13) {
        this.c = optional;
        this.d = optional2;
        this.e = optional3;
        this.f = optional4;
        this.g = optional5;
        this.h = optional6;
        this.i = optional7;
        this.j = optional8;
        this.k = optional9;
        this.l = optional10;
        this.m = optional11;
        this.n = optional12;
        this.o = optional13;
    }

    public static ContextAwarePredicate a(a builder) {
        return CriterionConditionEntity.a(builder.b());
    }

    public static Optional<ContextAwarePredicate> a(Optional<CriterionConditionEntity> entityPredicate) {
        return entityPredicate.map(CriterionConditionEntity::a);
    }

    public static List<ContextAwarePredicate> a(a ... builders) {
        return Stream.of(builders).map(CriterionConditionEntity::a).toList();
    }

    public static ContextAwarePredicate a(CriterionConditionEntity predicate) {
        LootItemCondition lootItemCondition = LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.a, predicate).build();
        return new ContextAwarePredicate(List.of(lootItemCondition));
    }

    public boolean a(EntityPlayer player, @Nullable Entity entity) {
        return this.a(player.z(), player.dk(), entity);
    }

    public boolean a(WorldServer world, @Nullable Vec3D pos, @Nullable Entity entity) {
        ScoreboardTeam team;
        if (entity == null) {
            return false;
        }
        if (this.c.isPresent() && !this.c.get().b(entity.ai())) {
            return false;
        }
        if (pos == null ? this.d.isPresent() : this.d.isPresent() && !this.d.get().a(pos.c, pos.d, pos.e, entity.dr(), entity.dt(), entity.dx())) {
            return false;
        }
        if (this.e.isPresent() && !this.e.get().a(world, entity.dr(), entity.dt(), entity.dx())) {
            return false;
        }
        if (this.f.isPresent()) {
            Vec3D vec3 = Vec3D.b(entity.aJ());
            if (!this.f.get().a(world, vec3.a(), vec3.b(), vec3.c())) {
                return false;
            }
        }
        if (this.g.isPresent() && !this.g.get().a(entity)) {
            return false;
        }
        if (this.h.isPresent() && !this.h.get().a(entity)) {
            return false;
        }
        if (this.i.isPresent() && !this.i.get().a(entity)) {
            return false;
        }
        if (this.j.isPresent() && !this.j.get().a(entity)) {
            return false;
        }
        if (this.k.isPresent() && !this.k.get().a(entity, world, pos)) {
            return false;
        }
        if (this.l.isPresent() && !this.l.get().a(world, pos, entity.cZ())) {
            return false;
        }
        if (this.m.isPresent() && entity.cP().stream().noneMatch(entityx -> this.m.get().a(world, pos, (Entity)entityx))) {
            return false;
        }
        if (this.n.isPresent() && !this.n.get().a(world, pos, entity instanceof EntityInsentient ? ((EntityInsentient)entity).q() : null)) {
            return false;
        }
        return !this.o.isPresent() || (team = entity.cg()) != null && this.o.get().equals(((ScoreboardTeamBase)team).b());
    }

    public static LootTableInfo b(EntityPlayer player, Entity target) {
        LootParams lootParams = new LootParams.a(player.z()).a(LootContextParameters.a, target).a(LootContextParameters.f, player.dk()).a(LootContextParameterSets.l);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;location;steppingOnLocation;effects;nbt;flags;equipment;subPredicate;vehicle;passenger;targetedEntity;team", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;location;steppingOnLocation;effects;nbt;flags;equipment;subPredicate;vehicle;passenger;targetedEntity;team", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;location;steppingOnLocation;effects;nbt;flags;equipment;subPredicate;vehicle;passenger;targetedEntity;team", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this, object);
    }

    public Optional<CriterionConditionEntityType> a() {
        return this.c;
    }

    public Optional<CriterionConditionDistance> b() {
        return this.d;
    }

    public Optional<CriterionConditionLocation> c() {
        return this.e;
    }

    public Optional<CriterionConditionLocation> d() {
        return this.f;
    }

    public Optional<CriterionConditionMobEffect> e() {
        return this.g;
    }

    public Optional<CriterionConditionNBT> f() {
        return this.h;
    }

    public Optional<CriterionConditionEntityFlags> g() {
        return this.i;
    }

    public Optional<CriterionConditionEntityEquipment> h() {
        return this.j;
    }

    public Optional<EntitySubPredicate> i() {
        return this.k;
    }

    public Optional<CriterionConditionEntity> j() {
        return this.l;
    }

    public Optional<CriterionConditionEntity> k() {
        return this.m;
    }

    public Optional<CriterionConditionEntity> l() {
        return this.n;
    }

    public Optional<String> m() {
        return this.o;
    }

    public static class a {
        private Optional<CriterionConditionEntityType> a = Optional.empty();
        private Optional<CriterionConditionDistance> b = Optional.empty();
        private Optional<CriterionConditionLocation> c = Optional.empty();
        private Optional<CriterionConditionLocation> d = Optional.empty();
        private Optional<CriterionConditionMobEffect> e = Optional.empty();
        private Optional<CriterionConditionNBT> f = Optional.empty();
        private Optional<CriterionConditionEntityFlags> g = Optional.empty();
        private Optional<CriterionConditionEntityEquipment> h = Optional.empty();
        private Optional<EntitySubPredicate> i = Optional.empty();
        private Optional<CriterionConditionEntity> j = Optional.empty();
        private Optional<CriterionConditionEntity> k = Optional.empty();
        private Optional<CriterionConditionEntity> l = Optional.empty();
        private Optional<String> m = Optional.empty();

        public static a a() {
            return new a();
        }

        public a a(EntityTypes<?> type) {
            this.a = Optional.of(CriterionConditionEntityType.a(type));
            return this;
        }

        public a a(TagKey<EntityTypes<?>> tag) {
            this.a = Optional.of(CriterionConditionEntityType.a(tag));
            return this;
        }

        public a a(CriterionConditionEntityType type) {
            this.a = Optional.of(type);
            return this;
        }

        public a a(CriterionConditionDistance distance) {
            this.b = Optional.of(distance);
            return this;
        }

        public a a(CriterionConditionLocation.a location) {
            this.c = Optional.of(location.b());
            return this;
        }

        public a b(CriterionConditionLocation.a steppingOn) {
            this.d = Optional.of(steppingOn.b());
            return this;
        }

        public a a(CriterionConditionMobEffect.a effects) {
            this.e = effects.b();
            return this;
        }

        public a a(CriterionConditionNBT nbt) {
            this.f = Optional.of(nbt);
            return this;
        }

        public a a(CriterionConditionEntityFlags.a flags) {
            this.g = Optional.of(flags.b());
            return this;
        }

        public a a(CriterionConditionEntityEquipment.a equipment) {
            this.h = Optional.of(equipment.b());
            return this;
        }

        public a a(CriterionConditionEntityEquipment equipment) {
            this.h = Optional.of(equipment);
            return this;
        }

        public a a(EntitySubPredicate typeSpecific) {
            this.i = Optional.of(typeSpecific);
            return this;
        }

        public a a(a vehicle) {
            this.j = Optional.of(vehicle.b());
            return this;
        }

        public a b(a passenger) {
            this.k = Optional.of(passenger.b());
            return this;
        }

        public a c(a targetedEntity) {
            this.l = Optional.of(targetedEntity.b());
            return this;
        }

        public a a(String team) {
            this.m = Optional.of(team);
            return this;
        }

        public CriterionConditionEntity b() {
            return new CriterionConditionEntity(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m);
        }
    }
}

