/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.BuildContexts;
import net.minecraft.commands.functions.FunctionBuilder;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;

public interface CommandFunction<T> {
    public MinecraftKey a();

    public InstantiatedFunction<T> a(@Nullable NBTTagCompound var1, com.mojang.brigadier.CommandDispatcher<T> var2, T var3) throws FunctionInstantiationException;

    private static boolean a(CharSequence string) {
        int i2 = string.length();
        return i2 > 0 && string.charAt(i2 - 1) == '\\';
    }

    public static <T extends ExecutionCommandSource<T>> CommandFunction<T> a(MinecraftKey id, com.mojang.brigadier.CommandDispatcher<T> dispatcher, T source, List<String> lines) {
        FunctionBuilder<T> functionBuilder = new FunctionBuilder<T>();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            String string4;
            int j2 = i2 + 1;
            String string = lines.get(i2).trim();
            if (CommandFunction.a(string)) {
                StringBuilder stringBuilder = new StringBuilder(string);
                do {
                    if (++i2 == lines.size()) {
                        throw new IllegalArgumentException("Line continuation at end of file");
                    }
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    String string2 = lines.get(i2).trim();
                    stringBuilder.append(string2);
                } while (CommandFunction.a(stringBuilder));
                String string3 = stringBuilder.toString();
            } else {
                string4 = string;
            }
            StringReader stringReader = new StringReader(string4);
            if (!stringReader.canRead() || stringReader.peek() == '#') continue;
            if (stringReader.peek() == '/') {
                stringReader.skip();
                if (stringReader.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + string4 + "' on line " + j2 + " (if you intended to make a comment, use '#' not '//')");
                }
                String string5 = stringReader.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + string4 + "' on line " + j2 + " (did you mean '" + string5 + "'? Do not use a preceding forwards slash.)");
            }
            if (stringReader.peek() == '$') {
                functionBuilder.a(string4.substring(1), j2);
                continue;
            }
            try {
                functionBuilder.a(CommandFunction.a(dispatcher, source, stringReader));
                continue;
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new IllegalArgumentException("Whilst parsing command on line " + j2 + ": " + commandSyntaxException.getMessage());
            }
        }
        return functionBuilder.a(id);
    }

    public static <T extends ExecutionCommandSource<T>> UnboundEntryAction<T> a(com.mojang.brigadier.CommandDispatcher<T> dispatcher, T source, StringReader reader) throws CommandSyntaxException {
        ParseResults<T> parseResults = dispatcher.parse(reader, source);
        CommandDispatcher.a(parseResults);
        Optional optional = ContextChain.tryFlatten((CommandContext)parseResults.getContext().build(reader.getString()));
        if (optional.isEmpty()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseResults.getReader());
        }
        return new BuildContexts.c(reader.getString(), (ContextChain)optional.get());
    }
}

