/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public final class EnumDirection
extends Enum<EnumDirection>
implements INamable {
    public static final /* enum */ EnumDirection a = new EnumDirection(0, 1, -1, "down", EnumAxisDirection.b, EnumAxis.b, new BaseBlockPosition(0, -1, 0));
    public static final /* enum */ EnumDirection b = new EnumDirection(1, 0, -1, "up", EnumAxisDirection.a, EnumAxis.b, new BaseBlockPosition(0, 1, 0));
    public static final /* enum */ EnumDirection c = new EnumDirection(2, 3, 2, "north", EnumAxisDirection.b, EnumAxis.c, new BaseBlockPosition(0, 0, -1));
    public static final /* enum */ EnumDirection d = new EnumDirection(3, 2, 0, "south", EnumAxisDirection.a, EnumAxis.c, new BaseBlockPosition(0, 0, 1));
    public static final /* enum */ EnumDirection e = new EnumDirection(4, 5, 1, "west", EnumAxisDirection.b, EnumAxis.a, new BaseBlockPosition(-1, 0, 0));
    public static final /* enum */ EnumDirection f = new EnumDirection(5, 4, 3, "east", EnumAxisDirection.a, EnumAxis.a, new BaseBlockPosition(1, 0, 0));
    public static final INamable.a<EnumDirection> g;
    public static final Codec<EnumDirection> h;
    private final int i;
    private final int j;
    private final int k;
    private final String l;
    private final EnumAxis m;
    private final EnumAxisDirection n;
    private final BaseBlockPosition o;
    private static final EnumDirection[] p;
    private static final EnumDirection[] q;
    private static final EnumDirection[] r;
    private final int adjX;
    private final int adjY;
    private final int adjZ;
    private static final int RANDOM_OFFSET = 2017601568;
    private EnumDirection opposite;
    private final int id = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(this.ordinal() + 2017601568)) + 2017601568));
    private static final /* synthetic */ EnumDirection[] s;

    public static EnumDirection[] values() {
        return (EnumDirection[])s.clone();
    }

    public static EnumDirection valueOf(String name) {
        return Enum.valueOf(EnumDirection.class, name);
    }

    public final int uniqueId() {
        return this.id;
    }

    private EnumDirection(int id, int idOpposite, int idHorizontal, String name, EnumAxisDirection direction, EnumAxis axis, BaseBlockPosition vector) {
        this.i = id;
        this.k = idHorizontal;
        this.j = idOpposite;
        this.l = name;
        this.m = axis;
        this.n = direction;
        this.o = vector;
        this.adjX = vector.u();
        this.adjY = vector.v();
        this.adjZ = vector.w();
    }

    public static EnumDirection[] a(Entity entity) {
        EnumDirection direction3;
        float f2 = entity.g(1.0f) * ((float)Math.PI / 180);
        float g2 = -entity.h(1.0f) * ((float)Math.PI / 180);
        float h2 = MathHelper.a(f2);
        float i2 = MathHelper.b(f2);
        float j2 = MathHelper.a(g2);
        float k2 = MathHelper.b(g2);
        boolean bl = j2 > 0.0f;
        boolean bl2 = h2 < 0.0f;
        boolean bl3 = k2 > 0.0f;
        float l2 = bl ? j2 : -j2;
        float m2 = bl2 ? -h2 : h2;
        float n2 = bl3 ? k2 : -k2;
        float o2 = l2 * i2;
        float p2 = n2 * i2;
        EnumDirection direction = bl ? f : e;
        EnumDirection direction2 = bl2 ? b : a;
        EnumDirection enumDirection = direction3 = bl3 ? d : c;
        if (l2 > n2) {
            if (m2 > o2) {
                return EnumDirection.a(direction2, direction, direction3);
            }
            return p2 > m2 ? EnumDirection.a(direction, direction3, direction2) : EnumDirection.a(direction, direction2, direction3);
        }
        if (m2 > p2) {
            return EnumDirection.a(direction2, direction3, direction);
        }
        return o2 > m2 ? EnumDirection.a(direction3, direction, direction2) : EnumDirection.a(direction3, direction2, direction);
    }

    private static EnumDirection[] a(EnumDirection first, EnumDirection second, EnumDirection third) {
        return new EnumDirection[]{first, second, third, third.g(), second.g(), first.g()};
    }

    public static EnumDirection a(Matrix4f matrix, EnumDirection direction) {
        BaseBlockPosition vec3i = direction.q();
        Vector4f vector4f = matrix.transform(new Vector4f((float)vec3i.u(), (float)vec3i.v(), (float)vec3i.w(), 0.0f));
        return EnumDirection.a(vector4f.x(), vector4f.y(), vector4f.z());
    }

    public static Collection<EnumDirection> a(RandomSource random) {
        return SystemUtils.b(EnumDirection.values(), random);
    }

    public static Stream<EnumDirection> a() {
        return Stream.of(p);
    }

    public Quaternionf b() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case a -> new Quaternionf().rotationX((float)Math.PI);
            case b -> new Quaternionf();
            case c -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            case d -> new Quaternionf().rotationX(1.5707964f);
            case e -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            case f -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
        };
    }

    public int d() {
        return this.i;
    }

    public int e() {
        return this.k;
    }

    public EnumAxisDirection f() {
        return this.n;
    }

    public static EnumDirection a(Entity entity, EnumAxis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAxis.a -> {
                if (f.a(entity.h(1.0f))) {
                    yield f;
                }
                yield e;
            }
            case EnumAxis.c -> {
                if (d.a(entity.h(1.0f))) {
                    yield d;
                }
                yield c;
            }
            case EnumAxis.b -> entity.g(1.0f) < 0.0f ? b : a;
        };
    }

    public EnumDirection g() {
        return EnumDirection.a(this.j);
    }

    public EnumDirection a(EnumAxis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAxis.a -> {
                if (this != e && this != f) {
                    yield this.r();
                }
                yield this;
            }
            case EnumAxis.c -> {
                if (this != c && this != d) {
                    yield this.t();
                }
                yield this;
            }
            case EnumAxis.b -> this != b && this != a ? this.h() : this;
        };
    }

    public EnumDirection b(EnumAxis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAxis.a -> {
                if (this != e && this != f) {
                    yield this.s();
                }
                yield this;
            }
            case EnumAxis.c -> {
                if (this != c && this != d) {
                    yield this.u();
                }
                yield this;
            }
            case EnumAxis.b -> this != b && this != a ? this.i() : this;
        };
    }

    public EnumDirection h() {
        return switch (this) {
            case c -> f;
            case d -> e;
            case e -> c;
            case f -> d;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
        };
    }

    private EnumDirection r() {
        return switch (this) {
            case a -> d;
            case b -> c;
            case c -> a;
            case d -> b;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private EnumDirection s() {
        return switch (this) {
            case a -> c;
            case b -> d;
            case c -> b;
            case d -> a;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private EnumDirection t() {
        return switch (this) {
            case a -> e;
            case b -> f;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case e -> b;
            case f -> a;
        };
    }

    private EnumDirection u() {
        return switch (this) {
            case a -> f;
            case b -> e;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
            case e -> a;
            case f -> b;
        };
    }

    public EnumDirection i() {
        return switch (this) {
            case c -> e;
            case d -> f;
            case e -> d;
            case f -> c;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + this);
        };
    }

    public int j() {
        return this.adjX;
    }

    public int k() {
        return this.adjY;
    }

    public int l() {
        return this.adjZ;
    }

    public Vector3f m() {
        return new Vector3f((float)this.j(), (float)this.k(), (float)this.l());
    }

    public String n() {
        return this.l;
    }

    public EnumAxis o() {
        return this.m;
    }

    @Nullable
    public static EnumDirection a(@Nullable String name) {
        return g.a(name);
    }

    public static EnumDirection a(int id) {
        return q[MathHelper.a(id % q.length)];
    }

    public static EnumDirection b(int value) {
        return r[MathHelper.a(value % r.length)];
    }

    @Nullable
    public static EnumDirection a(int x2, int y2, int z2) {
        if (x2 == 0) {
            if (y2 == 0) {
                if (z2 > 0) {
                    return d;
                }
                if (z2 < 0) {
                    return c;
                }
            } else if (z2 == 0) {
                if (y2 > 0) {
                    return b;
                }
                return a;
            }
        } else if (y2 == 0 && z2 == 0) {
            if (x2 > 0) {
                return f;
            }
            return e;
        }
        return null;
    }

    public static EnumDirection a(double rotation) {
        return EnumDirection.b(MathHelper.a(rotation / 90.0 + 0.5) & 3);
    }

    public static EnumDirection a(EnumAxis axis, EnumAxisDirection direction) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAxis.a -> {
                if (direction == EnumAxisDirection.a) {
                    yield f;
                }
                yield e;
            }
            case EnumAxis.c -> {
                if (direction == EnumAxisDirection.a) {
                    yield d;
                }
                yield c;
            }
            case EnumAxis.b -> direction == EnumAxisDirection.a ? b : a;
        };
    }

    public float p() {
        return (this.k & 3) * 90;
    }

    public static EnumDirection b(RandomSource random) {
        return SystemUtils.a(p, random);
    }

    public static EnumDirection a(double x2, double y2, double z2) {
        return EnumDirection.a((float)x2, (float)y2, (float)z2);
    }

    public static EnumDirection a(float x2, float y2, float z2) {
        EnumDirection direction = c;
        float f2 = Float.MIN_VALUE;
        for (EnumDirection direction2 : p) {
            float g2 = x2 * (float)direction2.o.u() + y2 * (float)direction2.o.v() + z2 * (float)direction2.o.w();
            if (!(g2 > f2)) continue;
            f2 = g2;
            direction = direction2;
        }
        return direction;
    }

    public String toString() {
        return this.l;
    }

    @Override
    public String c() {
        return this.l;
    }

    private static DataResult<EnumDirection> a(EnumDirection direction) {
        return direction.o().b() ? DataResult.success((Object)direction) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static EnumDirection a(EnumAxisDirection direction, EnumAxis axis) {
        for (EnumDirection direction2 : p) {
            if (direction2.f() != direction || direction2.o() != axis) continue;
            return direction2;
        }
        throw new IllegalArgumentException("No such direction: " + direction + " " + axis);
    }

    public BaseBlockPosition q() {
        return this.o;
    }

    public boolean a(float yaw) {
        float f2 = yaw * ((float)Math.PI / 180);
        float g2 = -MathHelper.a(f2);
        float h2 = MathHelper.b(f2);
        return (float)this.o.u() * g2 + (float)this.o.w() * h2 > 0.0f;
    }

    private static /* synthetic */ EnumDirection[] w() {
        return new EnumDirection[]{a, b, c, d, e, f};
    }

    static {
        s = EnumDirection.w();
        g = INamable.a(EnumDirection::values);
        h = ExtraCodecs.a(g, EnumDirection::a);
        p = EnumDirection.values();
        q = (EnumDirection[])Arrays.stream(p).sorted(Comparator.comparingInt(direction -> direction.i)).toArray(EnumDirection[]::new);
        r = (EnumDirection[])Arrays.stream(p).filter(direction -> direction.o().d()).sorted(Comparator.comparingInt(direction -> direction.k)).toArray(EnumDirection[]::new);
        for (EnumDirection direction2 : p) {
            direction2.opposite = EnumDirection.a(direction2.j);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class EnumAxis
    extends Enum<EnumAxis>
    implements INamable,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumAxis a = new EnumAxis("x"){

            @Override
            public int a(int x2, int y2, int z2) {
                return x2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return x2;
            }
        };
        public static final /* enum */ EnumAxis b = new EnumAxis("y"){

            @Override
            public int a(int x2, int y2, int z2) {
                return y2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return y2;
            }
        };
        public static final /* enum */ EnumAxis c = new EnumAxis("z"){

            @Override
            public int a(int x2, int y2, int z2) {
                return z2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return z2;
            }
        };
        public static final EnumAxis[] d;
        public static final INamable.a<EnumAxis> e;
        private final String f;
        private static final /* synthetic */ EnumAxis[] g;

        public static EnumAxis[] values() {
            return (EnumAxis[])g.clone();
        }

        public static EnumAxis valueOf(String name) {
            return Enum.valueOf(EnumAxis.class, name);
        }

        private EnumAxis(String name) {
            this.f = name;
        }

        @Nullable
        public static EnumAxis a(String name) {
            return e.a(name);
        }

        public String a() {
            return this.f;
        }

        public boolean b() {
            return this == b;
        }

        public boolean d() {
            return this == a || this == c;
        }

        public String toString() {
            return this.f;
        }

        public static EnumAxis a(RandomSource random) {
            return SystemUtils.a(d, random);
        }

        public boolean a(@Nullable EnumDirection direction) {
            return direction != null && direction.o() == this;
        }

        public EnumDirectionLimit e() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case a, c -> EnumDirectionLimit.a;
                case b -> EnumDirectionLimit.b;
            };
        }

        @Override
        public String c() {
            return this.f;
        }

        public abstract int a(int var1, int var2, int var3);

        public abstract double a(double var1, double var3, double var5);

        private static /* synthetic */ EnumAxis[] f() {
            return new EnumAxis[]{a, b, c};
        }

        static {
            g = EnumAxis.f();
            d = EnumAxis.values();
            e = INamable.a(EnumAxis::values);
        }
    }

    public static final class EnumAxisDirection
    extends Enum<EnumAxisDirection> {
        public static final /* enum */ EnumAxisDirection a = new EnumAxisDirection(1, "Towards positive");
        public static final /* enum */ EnumAxisDirection b = new EnumAxisDirection(-1, "Towards negative");
        private final int c;
        private final String d;
        private static final /* synthetic */ EnumAxisDirection[] e;

        public static EnumAxisDirection[] values() {
            return (EnumAxisDirection[])e.clone();
        }

        public static EnumAxisDirection valueOf(String name) {
            return Enum.valueOf(EnumAxisDirection.class, name);
        }

        private EnumAxisDirection(int offset, String description) {
            this.c = offset;
            this.d = description;
        }

        public int a() {
            return this.c;
        }

        public String b() {
            return this.d;
        }

        public String toString() {
            return this.d;
        }

        public EnumAxisDirection c() {
            return this == a ? b : a;
        }

        private static /* synthetic */ EnumAxisDirection[] d() {
            return new EnumAxisDirection[]{a, b};
        }

        static {
            e = EnumAxisDirection.d();
        }
    }

    public static final class EnumDirectionLimit
    extends Enum<EnumDirectionLimit>
    implements Iterable<EnumDirection>,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumDirectionLimit a = new EnumDirectionLimit(new EnumDirection[]{c, f, d, e}, new EnumAxis[]{EnumAxis.a, EnumAxis.c});
        public static final /* enum */ EnumDirectionLimit b = new EnumDirectionLimit(new EnumDirection[]{b, a}, new EnumAxis[]{EnumAxis.b});
        private final EnumDirection[] c;
        private final EnumAxis[] d;
        private static final /* synthetic */ EnumDirectionLimit[] e;

        public static EnumDirectionLimit[] values() {
            return (EnumDirectionLimit[])e.clone();
        }

        public static EnumDirectionLimit valueOf(String name) {
            return Enum.valueOf(EnumDirectionLimit.class, name);
        }

        private EnumDirectionLimit(EnumDirection[] facingArray, EnumAxis[] axisArray) {
            this.c = facingArray;
            this.d = axisArray;
        }

        public EnumDirection a(RandomSource random) {
            return SystemUtils.a(this.c, random);
        }

        public EnumAxis b(RandomSource random) {
            return SystemUtils.a(this.d, random);
        }

        public boolean a(@Nullable EnumDirection direction) {
            return direction != null && direction.o().e() == this;
        }

        @Override
        public Iterator<EnumDirection> iterator() {
            return Iterators.forArray((Object[])this.c);
        }

        public Stream<EnumDirection> a() {
            return Arrays.stream(this.c);
        }

        public List<EnumDirection> c(RandomSource random) {
            return SystemUtils.b(this.c, random);
        }

        private static /* synthetic */ EnumDirectionLimit[] b() {
            return new EnumDirectionLimit[]{a, b};
        }

        static {
            e = EnumDirectionLimit.b();
        }
    }
}

