/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockListReport
implements DebugReportProvider {
    private final PackOutput d;

    public BlockListReport(PackOutput output) {
        this.d = output;
    }

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        JsonObject jsonObject = new JsonObject();
        for (Block block : BuiltInRegistries.e) {
            MinecraftKey resourceLocation = BuiltInRegistries.e.b(block);
            JsonObject jsonObject2 = new JsonObject();
            BlockStateList<Block, IBlockData> stateDefinition = block.n();
            if (!stateDefinition.d().isEmpty()) {
                JsonObject jsonObject3 = new JsonObject();
                for (IBlockState iBlockState : stateDefinition.d()) {
                    JsonArray jsonArray = new JsonArray();
                    for (Comparable comparable : iBlockState.a()) {
                        jsonArray.add(SystemUtils.a(iBlockState, comparable));
                    }
                    jsonObject3.add(iBlockState.f(), (JsonElement)jsonArray);
                }
                jsonObject2.add("properties", (JsonElement)jsonObject3);
            }
            JsonArray jsonArray2 = new JsonArray();
            for (IBlockData iBlockData : stateDefinition.a()) {
                JsonObject jsonObject4 = new JsonObject();
                JsonObject jsonObject5 = new JsonObject();
                for (IBlockState<?> property2 : stateDefinition.d()) {
                    jsonObject5.addProperty(property2.f(), SystemUtils.a(property2, iBlockData.c(property2)));
                }
                if (jsonObject5.size() > 0) {
                    jsonObject4.add("properties", (JsonElement)jsonObject5);
                }
                jsonObject4.addProperty("id", (Number)Block.i(iBlockData));
                if (iBlockData == block.o()) {
                    jsonObject4.addProperty("default", Boolean.valueOf(true));
                }
                jsonArray2.add((JsonElement)jsonObject4);
            }
            jsonObject2.add("states", (JsonElement)jsonArray2);
            jsonObject.add(resourceLocation.toString(), (JsonElement)jsonObject2);
        }
        Path path = this.d.a(PackOutput.b.c).resolve("blocks.json");
        return DebugReportProvider.a(writer, (JsonElement)jsonObject, path);
    }

    @Override
    @Override
    public final String a() {
        return "Block List";
    }
}

