/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootSelectorLootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;

public abstract class EntityLootSubProvider
implements LootTableSubProvider {
    protected static final CriterionConditionEntity.a a = CriterionConditionEntity.a.a().a(CriterionConditionEntityFlags.a.a().a(true));
    private static final Set<EntityTypes<?>> b = ImmutableSet.of(EntityTypes.bv, EntityTypes.d, EntityTypes.ad, EntityTypes.aP, EntityTypes.bg);
    private final FeatureFlagSet c;
    private final FeatureFlagSet d;
    private final Map<EntityTypes<?>, Map<MinecraftKey, LootTable.a>> e = Maps.newHashMap();

    protected EntityLootSubProvider(FeatureFlagSet requiredFeatures) {
        this(requiredFeatures, requiredFeatures);
    }

    protected EntityLootSubProvider(FeatureFlagSet requiredFeatures, FeatureFlagSet featureSet) {
        this.c = requiredFeatures;
        this.d = featureSet;
    }

    protected static LootTable.a a(IMaterial item) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(item))).a(LootSelector.a().a(ConstantValue.a(1.0f)).a(LootSelectorLootTable.a(EntityTypes.aG.j())));
    }

    public abstract void a();

    @Override
    @Override
    public void generate(BiConsumer<MinecraftKey, LootTable.a> exporter) {
        this.a();
        HashSet set = Sets.newHashSet();
        BuiltInRegistries.g.h().forEach(entityType -> {
            EntityTypes entityType2 = (EntityTypes)entityType.a();
            if (!entityType2.a(this.c)) {
                return;
            }
            if (EntityLootSubProvider.a(entityType2)) {
                Map<MinecraftKey, LootTable.a> map = this.e.remove(entityType2);
                MinecraftKey resourceLocation = entityType2.j();
                if (!(resourceLocation.equals(LootTables.a) || !entityType2.a(this.d) || map != null && map.containsKey(resourceLocation))) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourceLocation, entityType.g().a()));
                }
                if (map != null) {
                    map.forEach((lootTableId, lootTableBuilder) -> {
                        if (!set.add(lootTableId)) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", lootTableId, entityType.g().a()));
                        }
                        exporter.accept((MinecraftKey)lootTableId, (LootTable.a)lootTableBuilder);
                    });
                }
            } else {
                Map<MinecraftKey, LootTable.a> map2 = this.e.remove(entityType2);
                if (map2 != null) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", map2.keySet().stream().map(MinecraftKey::toString).collect(Collectors.joining(",")), entityType.g().a()));
                }
            }
        });
        if (!this.e.isEmpty()) {
            throw new IllegalStateException("Created loot tables for entities not supported by datapack: " + this.e.keySet());
        }
    }

    private static boolean a(EntityTypes<?> entityType) {
        return b.contains(entityType) || entityType.f() != EnumCreatureType.h;
    }

    protected LootItemCondition.a b() {
        return LootItemConditionDamageSourceProperties.a(CriterionConditionDamageSource.a.a().b(CriterionConditionEntity.a.a().a(EntityTypes.P)));
    }

    protected LootItemCondition.a a(FrogVariant variant) {
        return LootItemConditionDamageSourceProperties.a(CriterionConditionDamageSource.a.a().b(CriterionConditionEntity.a.a().a(EntityTypes.P).a(EntitySubPredicate.a(variant))));
    }

    protected void a(EntityTypes<?> entityType, LootTable.a lootTable) {
        this.a(entityType, entityType.j(), lootTable);
    }

    protected void a(EntityTypes<?> entityType, MinecraftKey entityId, LootTable.a lootTable) {
        this.e.computeIfAbsent(entityType, type -> new HashMap()).put(entityId, lootTable);
    }
}

