/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionTriggerEnterBlock;
import net.minecraft.advancements.critereon.CriterionTriggerInventoryChanged;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class RecipeProvider
implements DebugReportProvider {
    final PackOutput.a d;
    final PackOutput.a e;
    private static final Map<BlockFamily.b, BiFunction<IMaterial, IMaterial, RecipeBuilder>> f = ImmutableMap.builder().put((Object)BlockFamily.b.a, (output, input) -> RecipeProvider.c(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.b, (output, input) -> RecipeProvider.b(RecipeCategory.a, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.d, (output, input) -> RecipeProvider.f(RecipeCategory.a, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.e, (output, input) -> RecipeProvider.a(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.f, (output, input) -> RecipeProvider.d(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.g, (output, input) -> RecipeProvider.d(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.h, (output, input) -> RecipeProvider.e(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.i, (output, input) -> RecipeProvider.e(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.k, (output, input) -> RecipeProvider.g(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.l, (output, input) -> RecipeProvider.a(RecipeCategory.a, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.m, (output, input) -> RecipeProvider.b(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.n, (output, input) -> RecipeProvider.c(RecipeCategory.c, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.o, (output, input) -> RecipeProvider.e(RecipeCategory.a, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.p, (output, input) -> RecipeProvider.f(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.q, (output, input) -> RecipeProvider.d(RecipeCategory.b, output, RecipeItemStack.a(input))).build();

    public RecipeProvider(PackOutput output) {
        this.d = output.a(PackOutput.b.a, "recipes");
        this.e = output.a(PackOutput.b.a, "advancements");
    }

    @Override
    @Override
    public CompletableFuture<?> a(final CachedOutput writer) {
        final HashSet set = Sets.newHashSet();
        final ArrayList list = new ArrayList();
        this.a(new RecipeOutput(){

            @Override
            @Override
            public void a(MinecraftKey recipeId, IRecipe<?> recipe, @Nullable AdvancementHolder advancement) {
                if (!set.add(recipeId)) {
                    throw new IllegalStateException("Duplicate recipe " + recipeId);
                }
                list.add(DebugReportProvider.a(writer, IRecipe.h, recipe, RecipeProvider.this.d.a(recipeId)));
                if (advancement != null) {
                    list.add(DebugReportProvider.a(writer, Advancement.a, advancement.b(), RecipeProvider.this.e.a(advancement.a())));
                }
            }

            @Override
            @Override
            public Advancement.SerializedAdvancement a() {
                return Advancement.SerializedAdvancement.b().a(RecipeBuilder.a);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected CompletableFuture<?> a(CachedOutput cache, AdvancementHolder advancement) {
        return DebugReportProvider.a(cache, Advancement.a, advancement.b(), this.e.a(advancement.a()));
    }

    protected abstract void a(RecipeOutput var1);

    protected static void a(RecipeOutput exporter, FeatureFlagSet enabledFeatures) {
        BlockFamilies.a().filter(BlockFamily::d).forEach(family -> RecipeProvider.a(exporter, family, enabledFeatures));
    }

    protected static void a(RecipeOutput exporter, IMaterial output, IMaterial input, @Nullable String group) {
        RecipeProvider.a(exporter, output, input, group, 1);
    }

    protected static void a(RecipeOutput exporter, IMaterial output, IMaterial input, @Nullable String group, int outputCount) {
        ShapelessRecipeBuilder.a(RecipeCategory.i, output, outputCount).b(input).b(group).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, RecipeProvider.a(output, input));
    }

    protected static void a(RecipeOutput exporter, List<IMaterial> inputs, RecipeCategory category, IMaterial output, float experience, int cookingTime, String group) {
        RecipeProvider.a(exporter, RecipeSerializer.p, FurnaceRecipe::new, inputs, category, output, experience, cookingTime, group, "_from_smelting");
    }

    protected static void b(RecipeOutput exporter, List<IMaterial> inputs, RecipeCategory category, IMaterial output, float experience, int cookingTime, String group) {
        RecipeProvider.a(exporter, RecipeSerializer.q, RecipeBlasting::new, inputs, category, output, experience, cookingTime, group, "_from_blasting");
    }

    private static <T extends RecipeCooking> void a(RecipeOutput exporter, RecipeSerializer<T> serializer, RecipeCooking.a<T> recipeFactory, List<IMaterial> inputs, RecipeCategory category, IMaterial output, float experience, int cookingTime, String group, String suffix) {
        for (IMaterial itemLike : inputs) {
            SimpleCookingRecipeBuilder.a(RecipeItemStack.a(itemLike), category, output, experience, cookingTime, serializer, recipeFactory).b(group).b(RecipeProvider.b(itemLike), RecipeProvider.a(itemLike)).a(exporter, RecipeProvider.c(output) + suffix + "_" + RecipeProvider.c(itemLike));
        }
    }

    protected static void a(RecipeOutput exporter, Item input, RecipeCategory category, Item result) {
        SmithingTransformRecipeBuilder.a(RecipeItemStack.a(Items.xj), RecipeItemStack.a(input), RecipeItemStack.a(Items.oG), category, result).a("has_netherite_ingot", RecipeProvider.a(Items.oG)).a(exporter, RecipeProvider.c(result) + "_smithing");
    }

    protected static void a(RecipeOutput exporter, Item template, MinecraftKey recipeId) {
        SmithingTrimRecipeBuilder.a(RecipeItemStack.a(template), RecipeItemStack.a(TagsItem.aH), RecipeItemStack.a(TagsItem.aI), RecipeCategory.i).a("has_smithing_trim_template", RecipeProvider.a(template)).a(exporter, recipeId);
    }

    protected static void a(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(category, output, 1).a(Character.valueOf('#'), input).b("##").b("##").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static void a(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input, String criterionName) {
        ShapelessRecipeBuilder.a(category, output).a(input, 9).b(criterionName, RecipeProvider.a(input)).a(exporter);
    }

    protected static void b(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        RecipeProvider.a(exporter, category, output, input, RecipeProvider.b(input));
    }

    protected static void a(RecipeOutput exporter, IMaterial output, TagKey<Item> input, int count) {
        ShapelessRecipeBuilder.a(RecipeCategory.a, output, count).a(input).b("planks").b("has_log", RecipeProvider.a(input)).a(exporter);
    }

    protected static void b(RecipeOutput exporter, IMaterial output, TagKey<Item> input, int count) {
        ShapelessRecipeBuilder.a(RecipeCategory.a, output, count).a(input).b("planks").b("has_logs", RecipeProvider.a(input)).a(exporter);
    }

    protected static void a(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.a, output, 3).a(Character.valueOf('#'), input).b("##").b("##").c("bark").b("has_log", RecipeProvider.a(input)).a(exporter);
    }

    protected static void b(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.d, output).a(Character.valueOf('#'), input).b("# #").b("###").c("boat").b("in_water", RecipeProvider.a(Blocks.G)).a(exporter);
    }

    protected static void c(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapelessRecipeBuilder.a(RecipeCategory.d, output).b(Blocks.cv).b(input).b("chest_boat").b("has_boat", RecipeProvider.a(TagsItem.am)).a(exporter);
    }

    private static RecipeBuilder c(IMaterial output, RecipeItemStack input) {
        return ShapelessRecipeBuilder.a(RecipeCategory.c, output).a(input);
    }

    protected static RecipeBuilder a(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(RecipeCategory.c, output, 3).a(Character.valueOf('#'), input).b("##").b("##").b("##");
    }

    private static RecipeBuilder d(IMaterial output, RecipeItemStack input) {
        int i2 = output == Blocks.fo ? 6 : 3;
        Item item = output == Blocks.fo ? Items.uq : Items.pm;
        return ShapedRecipeBuilder.a(RecipeCategory.b, output, i2).a(Character.valueOf('W'), input).a(Character.valueOf('#'), item).b("W#W").b("W#W");
    }

    private static RecipeBuilder e(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(RecipeCategory.c, output).a(Character.valueOf('#'), Items.pm).a(Character.valueOf('W'), input).b("#W#").b("#W#");
    }

    protected static void d(RecipeOutput exporter, IMaterial output, IMaterial input) {
        RecipeProvider.c(RecipeCategory.c, output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static RecipeBuilder c(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(category, output).a(Character.valueOf('#'), input).b("##");
    }

    protected static void c(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        RecipeProvider.a(category, output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static RecipeBuilder a(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(category, output, 6).a(Character.valueOf('#'), input).b("###");
    }

    protected static RecipeBuilder b(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(RecipeCategory.a, output, 4).a(Character.valueOf('#'), input).b("#  ").b("## ").b("###");
    }

    private static RecipeBuilder f(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(RecipeCategory.c, output, 2).a(Character.valueOf('#'), input).b("###").b("###");
    }

    private static RecipeBuilder g(IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(RecipeCategory.b, output, 3).c("sign").a(Character.valueOf('#'), input).a(Character.valueOf('X'), Items.pm).b("###").b("###").b(" X ");
    }

    protected static void e(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.b, output, 6).c("hanging_sign").a(Character.valueOf('#'), input).a(Character.valueOf('X'), Items.fR).b("X X").b("###").b("###").b("has_stripped_logs", RecipeProvider.a(input)).a(exporter);
    }

    protected static void a(RecipeOutput exporter, List<Item> dyes, List<Item> dyeables, String group) {
        for (int i2 = 0; i2 < dyes.size(); ++i2) {
            Item item = dyes.get(i2);
            Item item2 = dyeables.get(i2);
            ShapelessRecipeBuilder.a(RecipeCategory.a, item2).b(item).a(RecipeItemStack.a(dyeables.stream().filter(dyeable -> !dyeable.equals(item2)).map(ItemStack::new))).b(group).b("has_needed_dye", RecipeProvider.a(item)).a(exporter, "dye_" + RecipeProvider.c(item2));
        }
    }

    protected static void f(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.b, output, 3).a(Character.valueOf('#'), input).b("##").c("carpet").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static void g(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.b, output).a(Character.valueOf('#'), input).a(Character.valueOf('X'), TagsItem.b).b("###").b("XXX").c("bed").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static void h(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.b, output).a(Character.valueOf('#'), input).a(Character.valueOf('|'), Items.pm).b("###").b("###").b(" | ").c("banner").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static void i(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.a, output, 8).a(Character.valueOf('#'), Blocks.aQ).a(Character.valueOf('X'), input).b("###").b("#X#").b("###").c("stained_glass").b("has_glass", RecipeProvider.a((IMaterial)Blocks.aQ)).a(exporter);
    }

    protected static void j(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.b, output, 16).a(Character.valueOf('#'), input).b("###").b("###").c("stained_glass_pane").b("has_glass", RecipeProvider.a(input)).a(exporter);
    }

    protected static void k(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.b, output, 8).a(Character.valueOf('#'), Blocks.eY).a(Character.valueOf('$'), input).b("###").b("#$#").b("###").c("stained_glass_pane").b("has_glass_pane", RecipeProvider.a((IMaterial)Blocks.eY)).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, RecipeProvider.a(output, (IMaterial)Blocks.eY));
    }

    protected static void l(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(RecipeCategory.a, output, 8).a(Character.valueOf('#'), Blocks.iA).a(Character.valueOf('X'), input).b("###").b("#X#").b("###").c("stained_terracotta").b("has_terracotta", RecipeProvider.a((IMaterial)Blocks.iA)).a(exporter);
    }

    protected static void m(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapelessRecipeBuilder.a(RecipeCategory.a, output, 8).b(input).a(Blocks.I, 4).a(Blocks.L, 4).b("concrete_powder").b("has_sand", RecipeProvider.a((IMaterial)Blocks.I)).b("has_gravel", RecipeProvider.a((IMaterial)Blocks.L)).a(exporter);
    }

    protected static void n(RecipeOutput exporter, IMaterial output, IMaterial input) {
        ShapelessRecipeBuilder.a(RecipeCategory.b, output).b(Blocks.pL).b(input).b("dyed_candle").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static void d(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        RecipeProvider.d(category, output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static RecipeBuilder d(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(category, output, 6).a(Character.valueOf('#'), input).b("###").b("###");
    }

    protected static void e(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        RecipeProvider.e(category, output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static RecipeBuilder e(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(category, output, 4).a(Character.valueOf('S'), input).b("SS").b("SS");
    }

    protected static void f(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        RecipeProvider.f(category, output, RecipeItemStack.a(input)).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    private static ShapedRecipeBuilder f(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(category, output, 4).a(Character.valueOf('#'), input).b("##").b("##");
    }

    protected static void g(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        RecipeProvider.b(category, output, RecipeItemStack.a(input)).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static void h(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        ShapedRecipeBuilder.a(category, output).a(Character.valueOf('#'), input).b("#").b("#").b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static ShapedRecipeBuilder b(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return ShapedRecipeBuilder.a(category, output).a(Character.valueOf('#'), input).b("#").b("#");
    }

    protected static void i(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input) {
        RecipeProvider.a(exporter, category, output, input, 1);
    }

    protected static void a(RecipeOutput exporter, RecipeCategory category, IMaterial output, IMaterial input, int count) {
        SingleItemRecipeBuilder.a(RecipeItemStack.a(input), category, output, count).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter, RecipeProvider.a(output, input) + "_stonecutting");
    }

    private static void p(RecipeOutput exporter, IMaterial output, IMaterial input) {
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(input), RecipeCategory.a, output, 0.1f, 200).b(RecipeProvider.b(input), RecipeProvider.a(input)).a(exporter);
    }

    protected static void a(RecipeOutput exporter, RecipeCategory reverseCategory, IMaterial baseItem, RecipeCategory compactingCategory, IMaterial compactItem) {
        RecipeProvider.a(exporter, reverseCategory, baseItem, compactingCategory, compactItem, RecipeProvider.d(compactItem), null, RecipeProvider.d(baseItem), null);
    }

    protected static void a(RecipeOutput exporter, RecipeCategory reverseCategory, IMaterial baseItem, RecipeCategory compactingCategory, IMaterial compactItem, String compactingId, String compactingGroup) {
        RecipeProvider.a(exporter, reverseCategory, baseItem, compactingCategory, compactItem, compactingId, compactingGroup, RecipeProvider.d(baseItem), null);
    }

    protected static void b(RecipeOutput exporter, RecipeCategory reverseCategory, IMaterial baseItem, RecipeCategory compactingCategory, IMaterial compactItem, String reverseId, String reverseGroup) {
        RecipeProvider.a(exporter, reverseCategory, baseItem, compactingCategory, compactItem, RecipeProvider.d(compactItem), null, reverseId, reverseGroup);
    }

    private static void a(RecipeOutput exporter, RecipeCategory reverseCategory, IMaterial baseItem, RecipeCategory compactingCategory, IMaterial compactItem, String compactingId, @Nullable String compactingGroup, String reverseId, @Nullable String reverseGroup) {
        ShapelessRecipeBuilder.a(reverseCategory, baseItem, 9).b(compactItem).b(reverseGroup).b(RecipeProvider.b(compactItem), RecipeProvider.a(compactItem)).a(exporter, new MinecraftKey(reverseId));
        ShapedRecipeBuilder.a(compactingCategory, compactItem).a(Character.valueOf('#'), baseItem).b("###").b("###").b("###").c(compactingGroup).b(RecipeProvider.b(baseItem), RecipeProvider.a(baseItem)).a(exporter, new MinecraftKey(compactingId));
    }

    protected static void a(RecipeOutput exporter, IMaterial template, TagKey<Item> resource) {
        ShapedRecipeBuilder.a(RecipeCategory.i, template, 2).a(Character.valueOf('#'), Items.ov).a(Character.valueOf('C'), resource).a(Character.valueOf('S'), template).b("#S#").b("#C#").b("###").b(RecipeProvider.b(template), RecipeProvider.a(template)).a(exporter);
    }

    protected static void o(RecipeOutput exporter, IMaterial template, IMaterial resource) {
        ShapedRecipeBuilder.a(RecipeCategory.i, template, 2).a(Character.valueOf('#'), Items.ov).a(Character.valueOf('C'), resource).a(Character.valueOf('S'), template).b("#S#").b("#C#").b("###").b(RecipeProvider.b(template), RecipeProvider.a(template)).a(exporter);
    }

    protected static <T extends RecipeCooking> void a(RecipeOutput exporter, String cooker, RecipeSerializer<T> serializer, RecipeCooking.a<T> recipeFactory, int cookingTime) {
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.rX, Items.rY, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.rZ, Items.sa, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.qW, Items.ra, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.dJ, Items.rU, 0.1f);
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.qX, Items.rb, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.uG, Items.uH, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.pU, Items.pV, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.tZ, Items.ua, 0.35f);
        RecipeProvider.a(exporter, cooker, serializer, recipeFactory, cookingTime, Items.ut, Items.uu, 0.35f);
    }

    private static <T extends RecipeCooking> void a(RecipeOutput exporter, String cooker, RecipeSerializer<T> serializer, RecipeCooking.a<T> recipeFactory, int cookingTime, IMaterial items, IMaterial output, float experience) {
        SimpleCookingRecipeBuilder.a(RecipeItemStack.a(items), RecipeCategory.g, output, experience, cookingTime, serializer, recipeFactory).b(RecipeProvider.b(items), RecipeProvider.a(items)).a(exporter, RecipeProvider.c(output) + "_from_" + cooker);
    }

    protected static void b(RecipeOutput exporter, FeatureFlagSet enabledFeatures) {
        HoneycombItem.a.get().forEach((unwaxed, waxed) -> {
            if (!waxed.m().a(enabledFeatures)) {
                return;
            }
            ShapelessRecipeBuilder.a(RecipeCategory.a, waxed).b((IMaterial)unwaxed).b(Items.wn).b(RecipeProvider.c(waxed)).b(RecipeProvider.b(unwaxed), RecipeProvider.a((IMaterial)unwaxed)).a(exporter, RecipeProvider.a((IMaterial)waxed, (IMaterial)Items.wn));
        });
    }

    protected static void a(RecipeOutput exporter, Block output, Block input) {
        ShapedRecipeBuilder.a(RecipeCategory.a, output, 4).a(Character.valueOf('M'), input).b(" M ").b("M M").b(" M ").b(RecipeProvider.b(input), RecipeProvider.a((IMaterial)input)).a(exporter);
    }

    protected static void b(RecipeOutput exporter, Block output, Block input) {
        ShapedRecipeBuilder.a(RecipeCategory.c, output, 4).a(Character.valueOf('C'), input).a(Character.valueOf('R'), Items.lG).a(Character.valueOf('B'), Items.sd).b(" C ").b("CBC").b(" R ").b(RecipeProvider.b(input), RecipeProvider.a((IMaterial)input)).a(exporter);
    }

    protected static void a(RecipeOutput exporter, BlockFamily family, FeatureFlagSet enabledFeatures) {
        family.b().forEach((variant, block) -> {
            if (!block.m().a(enabledFeatures)) {
                return;
            }
            BiFunction<IMaterial, IMaterial, RecipeBuilder> biFunction = f.get(variant);
            Block itemLike = RecipeProvider.a(family, variant);
            if (biFunction != null) {
                RecipeBuilder recipeBuilder = biFunction.apply((IMaterial)block, itemLike);
                family.e().ifPresent(group -> recipeBuilder.a(group + (String)(variant == BlockFamily.b.d ? "" : "_" + variant.a())));
                recipeBuilder.a(family.f().orElseGet(() -> RecipeProvider.b(itemLike)), RecipeProvider.a((IMaterial)itemLike));
                recipeBuilder.a(exporter);
            }
            if (variant == BlockFamily.b.c) {
                RecipeProvider.p(exporter, block, itemLike);
            }
        });
    }

    private static Block a(BlockFamily family, BlockFamily.b variant) {
        if (variant == BlockFamily.b.b) {
            if (!family.b().containsKey((Object)BlockFamily.b.l)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return family.a(BlockFamily.b.l);
        }
        return family.a();
    }

    private static Criterion<CriterionTriggerEnterBlock.a> a(Block block) {
        return CriterionTriggers.e.a(new CriterionTriggerEnterBlock.a(Optional.empty(), Optional.of(block.r()), Optional.empty()));
    }

    private static Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionValue.IntegerRange count, IMaterial item) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(item).a(count));
    }

    protected static Criterion<CriterionTriggerInventoryChanged.a> a(IMaterial item) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(item));
    }

    protected static Criterion<CriterionTriggerInventoryChanged.a> a(TagKey<Item> tag) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(tag));
    }

    private static Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionItem.a ... predicates) {
        return RecipeProvider.a((CriterionConditionItem[])Arrays.stream(predicates).map(CriterionConditionItem.a::b).toArray(CriterionConditionItem[]::new));
    }

    private static Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionItem ... predicates) {
        return CriterionTriggers.f.a(new CriterionTriggerInventoryChanged.a(Optional.empty(), CriterionTriggerInventoryChanged.a.a.b, List.of(predicates)));
    }

    protected static String b(IMaterial item) {
        return "has_" + RecipeProvider.c(item);
    }

    protected static String c(IMaterial item) {
        return BuiltInRegistries.h.b(item.k()).a();
    }

    protected static String d(IMaterial item) {
        return RecipeProvider.c(item);
    }

    protected static String a(IMaterial to, IMaterial from) {
        return RecipeProvider.c(to) + "_from_" + RecipeProvider.c(from);
    }

    protected static String e(IMaterial item) {
        return RecipeProvider.c(item) + "_from_smelting";
    }

    protected static String f(IMaterial item) {
        return RecipeProvider.c(item) + "_from_blasting";
    }

    @Override
    @Override
    public final String a() {
        return "Recipes";
    }
}

