/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.level.IMaterial;

public class SingleItemRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory b;
    private final Item c;
    private final RecipeItemStack d;
    private final int e;
    private final Map<String, Criterion<?>> f = new LinkedHashMap();
    @Nullable
    private String g;
    private final RecipeSingleItem.a<?> h;

    public SingleItemRecipeBuilder(RecipeCategory category, RecipeSingleItem.a<?> recipeFactory, RecipeItemStack input, IMaterial output, int count) {
        this.b = category;
        this.h = recipeFactory;
        this.c = output.k();
        this.d = input;
        this.e = count;
    }

    public static SingleItemRecipeBuilder a(RecipeItemStack input, RecipeCategory category, IMaterial output) {
        return new SingleItemRecipeBuilder(category, RecipeStonecutting::new, input, output, 1);
    }

    public static SingleItemRecipeBuilder a(RecipeItemStack input, RecipeCategory category, IMaterial output, int count) {
        return new SingleItemRecipeBuilder(category, RecipeStonecutting::new, input, output, count);
    }

    @Override
    public SingleItemRecipeBuilder b(String string, Criterion<?> criterion) {
        this.f.put(string, criterion);
        return this;
    }

    @Override
    public SingleItemRecipeBuilder b(@Nullable String string) {
        this.g = string;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.c;
    }

    @Override
    @Override
    public void a(RecipeOutput exporter, MinecraftKey recipeId) {
        this.a(recipeId);
        Advancement.SerializedAdvancement builder = exporter.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeId)).a(AdvancementRewards.a.c(recipeId)).a(AdvancementRequirements.a.b);
        this.f.forEach(builder::a);
        Object singleItemRecipe = this.h.create(Objects.requireNonNullElse(this.g, ""), this.d, new ItemStack(this.c, this.e));
        exporter.a(recipeId, (IRecipe<?>)singleItemRecipe, builder.b(recipeId.d("recipes/" + this.b.a() + "/")));
    }

    private void a(MinecraftKey recipeId) {
        if (this.f.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.b(group);
    }

    public /* synthetic */ RecipeBuilder a(String name, Criterion criterion) {
        return this.b(name, criterion);
    }
}

