/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    private final PackOutput e;
    private final Iterable<Path> f;
    private final List<a> g = Lists.newArrayList();

    public SnbtToNbt(PackOutput output, Iterable<Path> paths) {
        this.e = output;
        this.f = paths;
    }

    public SnbtToNbt a(a tweaker) {
        this.g.add(tweaker);
        return this;
    }

    private NBTTagCompound a(String key, NBTTagCompound compound) {
        NBTTagCompound compoundTag = compound;
        for (a filter : this.g) {
            compoundTag = filter.apply(key, compoundTag);
        }
        return compoundTag;
    }

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        Path path = this.e.a();
        ArrayList list = Lists.newArrayList();
        for (Path path2 : this.f) {
            list.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])stream.filter(path -> path.toString().endsWith(".snbt")).map(path -> CompletableFuture.runAsync(() -> {
                            c taskResult = this.a((Path)path, this.a(path2, (Path)path));
                            this.a(writer, taskResult, path);
                        }, SystemUtils.f())).toArray(CompletableFuture[]::new));
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Failed to read structure input directory, aborting", exception);
                        }
                    }
                    stream.close();
                }
                return completableFuture;
            }, SystemUtils.f()).thenCompose(future -> future));
        }
        return SystemUtils.c(list);
    }

    @Override
    @Override
    public final String a() {
        return "SNBT -> NBT";
    }

    private String a(Path root, Path file) {
        String string = root.relativize(file).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    private c a(Path path, String name) {
        c c2;
        block8: {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            try {
                String string = IOUtils.toString((Reader)bufferedReader);
                NBTTagCompound compoundTag = this.a(name, GameProfileSerializer.a(string));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                NBTCompressedStreamTools.a(compoundTag, (OutputStream)hashingOutputStream);
                byte[] bs = byteArrayOutputStream.toByteArray();
                HashCode hashCode = hashingOutputStream.hash();
                c2 = new c(name, bs, hashCode);
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    throw new b(path, throwable3);
                }
            }
            bufferedReader.close();
        }
        return c2;
    }

    private void a(CachedOutput cache, c data, Path root) {
        Path path = root.resolve(data.a + ".nbt");
        try {
            cache.writeIfNeeded(path, data.b, data.c);
        }
        catch (IOException iOException) {
            d.error("Couldn't write structure {} at {}", new Object[]{data.a, path, iOException});
        }
    }

    @FunctionalInterface
    public static interface a {
        public NBTTagCompound apply(String var1, NBTTagCompound var2);
    }

    record c(String a, byte[] b, HashCode c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "name;payload;hash", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "name;payload;hash", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "name;payload;hash", "a", "b", "c"}, this, object);
        }
    }

    static class b
    extends RuntimeException {
        public b(Path path, Throwable cause) {
            super(path.toAbsolutePath().toString(), cause);
        }
    }
}

