/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class GameTestHarnessStructures {
    private static final Logger c = LogUtils.getLogger();
    public static final String a = "gameteststructures";
    public static String b = "gameteststructures";

    public static EnumBlockRotation a(int steps) {
        switch (steps) {
            case 0: {
                return EnumBlockRotation.a;
            }
            case 1: {
                return EnumBlockRotation.b;
            }
            case 2: {
                return EnumBlockRotation.c;
            }
            case 3: {
                return EnumBlockRotation.d;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + steps);
    }

    public static int a(EnumBlockRotation rotation) {
        switch (rotation) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + rotation);
    }

    public static AxisAlignedBB a(TileEntityStructure structureBlockEntity) {
        return AxisAlignedBB.a(GameTestHarnessStructures.b(structureBlockEntity));
    }

    public static StructureBoundingBox b(TileEntityStructure structureBlockEntity) {
        BlockPosition blockPos = GameTestHarnessStructures.c(structureBlockEntity);
        BlockPosition blockPos2 = GameTestHarnessStructures.a(blockPos, structureBlockEntity.k(), structureBlockEntity.m());
        return StructureBoundingBox.a(blockPos, blockPos2);
    }

    public static BlockPosition c(TileEntityStructure structureBlockEntity) {
        return structureBlockEntity.aB_().a(structureBlockEntity.g());
    }

    public static void a(BlockPosition pos, BlockPosition relativePos, EnumBlockRotation rotation, WorldServer world) {
        BlockPosition blockPos = DefinedStructure.a(pos.a(relativePos), EnumBlockMirror.a, rotation, pos);
        world.b(blockPos, Blocks.fN.o());
        TileEntityCommand commandBlockEntity = (TileEntityCommand)world.c_(blockPos);
        commandBlockEntity.c().a("test runthis");
        BlockPosition blockPos2 = DefinedStructure.a(blockPos.b(0, 0, -1), EnumBlockMirror.a, rotation, blockPos);
        world.b(blockPos2, Blocks.dM.o().a(rotation));
    }

    public static void a(String testName, BlockPosition pos, BaseBlockPosition relativePos, EnumBlockRotation rotation, WorldServer world) {
        StructureBoundingBox boundingBox = GameTestHarnessStructures.b(pos.c(), relativePos, rotation);
        GameTestHarnessStructures.a(boundingBox, world);
        world.b(pos, Blocks.pa.o());
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(pos);
        structureBlockEntity.a(false);
        structureBlockEntity.a(new MinecraftKey(testName));
        structureBlockEntity.a(relativePos);
        structureBlockEntity.a(BlockPropertyStructureMode.a);
        structureBlockEntity.e(true);
    }

    /*
     * WARNING - void declaration
     */
    public static TileEntityStructure a(GameTestHarnessInfo state, BlockPosition pos, EnumBlockRotation rotation, WorldServer world) {
        void blockPos5;
        BaseBlockPosition vec3i = world.q().b(new MinecraftKey(state.u())).orElseThrow(() -> new IllegalStateException("Missing test structure: " + state.u())).a();
        StructureBoundingBox boundingBox = GameTestHarnessStructures.b(pos, vec3i, rotation);
        if (rotation == EnumBlockRotation.a) {
            BlockPosition blockPos = pos;
        } else if (rotation == EnumBlockRotation.b) {
            BlockPosition blockPos2 = pos.b(vec3i.w() - 1, 0, 0);
        } else if (rotation == EnumBlockRotation.c) {
            BlockPosition blockPos3 = pos.b(vec3i.u() - 1, 0, vec3i.w() - 1);
        } else if (rotation == EnumBlockRotation.d) {
            BlockPosition blockPos4 = pos.b(0, 0, vec3i.u() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + rotation);
        }
        GameTestHarnessStructures.b(boundingBox, world);
        GameTestHarnessStructures.a(boundingBox, world);
        return GameTestHarnessStructures.b(state, blockPos5.d(), rotation, world);
    }

    private static void b(StructureBoundingBox box, WorldServer world) {
        box.b().forEach(chunkPos -> world.a(chunkPos.e, chunkPos.f, true));
    }

    public static void a(StructureBoundingBox area, WorldServer world) {
        int i2 = area.i() - 1;
        StructureBoundingBox boundingBox = new StructureBoundingBox(area.h() - 2, area.i() - 3, area.j() - 3, area.k() + 3, area.l() + 20, area.m() + 3);
        BlockPosition.a(boundingBox).forEach(pos -> GameTestHarnessStructures.a(i2, pos, world));
        world.m().a(boundingBox);
        world.a(boundingBox);
        AxisAlignedBB aABB = new AxisAlignedBB(boundingBox.h(), boundingBox.i(), boundingBox.j(), boundingBox.k(), boundingBox.l(), boundingBox.m());
        List<Entity> list = world.a(Entity.class, aABB, entity -> !(entity instanceof EntityHuman));
        list.forEach(Entity::am);
    }

    public static BlockPosition a(BlockPosition pos, BaseBlockPosition size, EnumBlockRotation rotation) {
        BlockPosition blockPos = pos.a(size).b(-1, -1, -1);
        return DefinedStructure.a(blockPos, EnumBlockMirror.a, rotation, pos);
    }

    public static StructureBoundingBox b(BlockPosition pos, BaseBlockPosition relativePos, EnumBlockRotation rotation) {
        BlockPosition blockPos = GameTestHarnessStructures.a(pos, relativePos, rotation);
        StructureBoundingBox boundingBox = StructureBoundingBox.a(pos, blockPos);
        int i2 = Math.min(boundingBox.h(), boundingBox.k());
        int j2 = Math.min(boundingBox.j(), boundingBox.m());
        return boundingBox.a(pos.u() - i2, 0, pos.w() - j2);
    }

    public static Optional<BlockPosition> a(BlockPosition pos, int radius, WorldServer world) {
        return GameTestHarnessStructures.c(pos, radius, world).stream().filter(structureBlockPos -> GameTestHarnessStructures.a(structureBlockPos, pos, world)).findFirst();
    }

    @Nullable
    public static BlockPosition b(BlockPosition pos, int radius, WorldServer world) {
        Comparator<BlockPosition> comparator = Comparator.comparingInt(posx -> posx.k(pos));
        Collection<BlockPosition> collection = GameTestHarnessStructures.c(pos, radius, world);
        Optional<BlockPosition> optional = collection.stream().min(comparator);
        return optional.orElse(null);
    }

    public static Collection<BlockPosition> c(BlockPosition pos, int radius, WorldServer world) {
        ArrayList collection = Lists.newArrayList();
        StructureBoundingBox boundingBox = new StructureBoundingBox(pos).a(radius);
        BlockPosition.a(boundingBox).forEach(blockPos -> {
            if (world.a_((BlockPosition)blockPos).a(Blocks.pa)) {
                collection.add(blockPos.i());
            }
        });
        return collection;
    }

    private static TileEntityStructure b(GameTestHarnessInfo state, BlockPosition pos, EnumBlockRotation rotation, WorldServer world) {
        world.b(pos, Blocks.pa.o());
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(pos);
        structureBlockEntity.a(BlockPropertyStructureMode.b);
        structureBlockEntity.a(rotation);
        structureBlockEntity.a(false);
        structureBlockEntity.a(new MinecraftKey(state.u()));
        structureBlockEntity.b(state.c());
        if (!structureBlockEntity.b(world)) {
            throw new RuntimeException("Failed to load structure info for test: " + state.c() + ". Structure name: " + state.u());
        }
        return structureBlockEntity;
    }

    private static void a(int altitude, BlockPosition pos, WorldServer world) {
        IBlockData blockState2;
        if (pos.v() < altitude) {
            IBlockData blockState = Blocks.b.o();
        } else {
            blockState2 = Blocks.a.o();
        }
        ArgumentTileLocation blockInput = new ArgumentTileLocation(blockState2, Collections.emptySet(), null);
        blockInput.a(world, pos, 2);
        world.b(pos, blockState2.b());
    }

    private static boolean a(BlockPosition structureBlockPos, BlockPosition pos, WorldServer world) {
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(structureBlockPos);
        return GameTestHarnessStructures.b(structureBlockEntity).b(pos);
    }
}

