/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class DynamicOpsNBT
implements DynamicOps<NBTBase> {
    public static final DynamicOpsNBT a = new DynamicOpsNBT();
    private static final String b = "";

    protected DynamicOpsNBT() {
    }

    public NBTBase a() {
        return NBTTagEnd.b;
    }

    public <U> U a(DynamicOps<U> dynamicOps, NBTBase tag) {
        switch (tag.b()) {
            case 0: {
                return (U)dynamicOps.empty();
            }
            case 1: {
                return (U)dynamicOps.createByte(((NBTNumber)tag).i());
            }
            case 2: {
                return (U)dynamicOps.createShort(((NBTNumber)tag).h());
            }
            case 3: {
                return (U)dynamicOps.createInt(((NBTNumber)tag).g());
            }
            case 4: {
                return (U)dynamicOps.createLong(((NBTNumber)tag).f());
            }
            case 5: {
                return (U)dynamicOps.createFloat(((NBTNumber)tag).k());
            }
            case 6: {
                return (U)dynamicOps.createDouble(((NBTNumber)tag).j());
            }
            case 7: {
                return (U)dynamicOps.createByteList(ByteBuffer.wrap(((NBTTagByteArray)tag).e()));
            }
            case 8: {
                return (U)dynamicOps.createString(tag.t_());
            }
            case 9: {
                return (U)this.convertList(dynamicOps, tag);
            }
            case 10: {
                return (U)this.convertMap(dynamicOps, tag);
            }
            case 11: {
                return (U)dynamicOps.createIntList(Arrays.stream(((NBTTagIntArray)tag).g()));
            }
            case 12: {
                return (U)dynamicOps.createLongList(Arrays.stream(((NBTTagLongArray)tag).g()));
            }
        }
        throw new IllegalStateException("Unknown tag type: " + tag);
    }

    public DataResult<Number> a(NBTBase tag) {
        if (tag instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)tag;
            return DataResult.success((Object)numericTag.l());
        }
        return DataResult.error(() -> "Not a number");
    }

    public NBTBase a(Number number) {
        return NBTTagDouble.a(number.doubleValue());
    }

    public NBTBase a(byte b2) {
        return NBTTagByte.a(b2);
    }

    public NBTBase a(short s2) {
        return NBTTagShort.a(s2);
    }

    public NBTBase a(int i2) {
        return NBTTagInt.a(i2);
    }

    public NBTBase a(long l2) {
        return NBTTagLong.a(l2);
    }

    public NBTBase a(float f2) {
        return NBTTagFloat.a(f2);
    }

    public NBTBase a(double d2) {
        return NBTTagDouble.a(d2);
    }

    public NBTBase a(boolean bl) {
        return NBTTagByte.a(bl);
    }

    public DataResult<String> b(NBTBase tag) {
        if (tag instanceof NBTTagString) {
            NBTTagString stringTag = (NBTTagString)tag;
            return DataResult.success((Object)stringTag.t_());
        }
        return DataResult.error(() -> "Not a string");
    }

    public NBTBase a(String string) {
        return NBTTagString.a(string);
    }

    public DataResult<NBTBase> a(NBTBase tag, NBTBase tag2) {
        return DynamicOpsNBT.k(tag).map(merger -> DataResult.success((Object)merger.a(tag2).a())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + tag, (Object)tag));
    }

    public DataResult<NBTBase> a(NBTBase tag, List<NBTBase> list) {
        return DynamicOpsNBT.k(tag).map(merger -> DataResult.success((Object)merger.a(list).a())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + tag, (Object)tag));
    }

    public DataResult<NBTBase> a(NBTBase tag, NBTBase tag2, NBTBase tag3) {
        if (!(tag instanceof NBTTagCompound) && !(tag instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + tag, (Object)tag);
        }
        if (!(tag2 instanceof NBTTagString)) {
            return DataResult.error(() -> "key is not a string: " + tag2, (Object)tag);
        }
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag2 = (NBTTagCompound)tag;
            compoundTag2.e().forEach(key -> compoundTag.a((String)key, compoundTag2.c((String)key)));
        }
        compoundTag.a(tag2.t_(), tag3);
        return DataResult.success((Object)compoundTag);
    }

    public DataResult<NBTBase> a(NBTBase tag, MapLike<NBTBase> mapLike) {
        if (!(tag instanceof NBTTagCompound) && !(tag instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + tag, (Object)tag);
        }
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag2 = (NBTTagCompound)tag;
            compoundTag2.e().forEach(key -> compoundTag.a((String)key, compoundTag2.c((String)key)));
        }
        ArrayList list = Lists.newArrayList();
        mapLike.entries().forEach(pair -> {
            NBTBase tag = (NBTBase)pair.getFirst();
            if (!(tag instanceof NBTTagString)) {
                list.add(tag);
                return;
            }
            compoundTag.a(tag.t_(), (NBTBase)pair.getSecond());
        });
        if (!list.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + list, (Object)compoundTag);
        }
        return DataResult.success((Object)compoundTag);
    }

    public DataResult<Stream<Pair<NBTBase, NBTBase>>> c(NBTBase tag) {
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            return DataResult.success(compoundTag.e().stream().map(key -> Pair.of((Object)this.a((String)key), (Object)compoundTag.c((String)key))));
        }
        return DataResult.error(() -> "Not a map: " + tag);
    }

    public DataResult<Consumer<BiConsumer<NBTBase, NBTBase>>> d(NBTBase tag) {
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            return DataResult.success(entryConsumer -> compoundTag.e().forEach(key -> entryConsumer.accept(this.a((String)key), compoundTag.c((String)key))));
        }
        return DataResult.error(() -> "Not a map: " + tag);
    }

    public DataResult<MapLike<NBTBase>> e(NBTBase tag) {
        if (tag instanceof NBTTagCompound) {
            final NBTTagCompound compoundTag = (NBTTagCompound)tag;
            return DataResult.success((Object)new MapLike<NBTBase>(){

                @Nullable
                public NBTBase a(NBTBase tag) {
                    return compoundTag.c(tag.t_());
                }

                @Nullable
                public NBTBase a(String string) {
                    return compoundTag.c(string);
                }

                public Stream<Pair<NBTBase, NBTBase>> entries() {
                    return compoundTag.e().stream().map(key -> Pair.of((Object)DynamicOpsNBT.this.a((String)key), (Object)compoundTag.c((String)key)));
                }

                @Override
                public String toString() {
                    return "MapLike[" + compoundTag + "]";
                }

                @Nullable
                public /* synthetic */ Object get(String string) {
                    return this.a(string);
                }

                @Nullable
                public /* synthetic */ Object get(Object object) {
                    return this.a((NBTBase)object);
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + tag);
    }

    public NBTBase a(Stream<Pair<NBTBase, NBTBase>> stream) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        stream.forEach(entry -> compoundTag.a(((NBTBase)entry.getFirst()).t_(), (NBTBase)entry.getSecond()));
        return compoundTag;
    }

    private static NBTBase a(NBTTagCompound nbt) {
        NBTBase tag;
        if (nbt.f() == 1 && (tag = nbt.c(b)) != null) {
            return tag;
        }
        return nbt;
    }

    public DataResult<Stream<NBTBase>> f(NBTBase tag) {
        if (tag instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)tag;
            if (listTag.f() == 10) {
                return DataResult.success(listTag.stream().map(nbt -> DynamicOpsNBT.a((NBTTagCompound)nbt)));
            }
            return DataResult.success(listTag.stream());
        }
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            return DataResult.success(collectionTag.stream().map(nbt -> nbt));
        }
        return DataResult.error(() -> "Not a list");
    }

    public DataResult<Consumer<Consumer<NBTBase>>> g(NBTBase tag) {
        if (tag instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)tag;
            if (listTag.f() == 10) {
                return DataResult.success(consumer -> listTag.forEach(nbt -> consumer.accept(DynamicOpsNBT.a((NBTTagCompound)nbt))));
            }
            return DataResult.success(listTag::forEach);
        }
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            return DataResult.success(collectionTag::forEach);
        }
        return DataResult.error(() -> "Not a list: " + tag);
    }

    public DataResult<ByteBuffer> h(NBTBase tag) {
        if (tag instanceof NBTTagByteArray) {
            NBTTagByteArray byteArrayTag = (NBTTagByteArray)tag;
            return DataResult.success((Object)ByteBuffer.wrap(byteArrayTag.e()));
        }
        return super.getByteBuffer((Object)tag);
    }

    public NBTBase a(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate().clear();
        byte[] bs = new byte[byteBuffer.capacity()];
        byteBuffer2.get(0, bs, 0, bs.length);
        return new NBTTagByteArray(bs);
    }

    public DataResult<IntStream> i(NBTBase tag) {
        if (tag instanceof NBTTagIntArray) {
            NBTTagIntArray intArrayTag = (NBTTagIntArray)tag;
            return DataResult.success((Object)Arrays.stream(intArrayTag.g()));
        }
        return super.getIntStream((Object)tag);
    }

    public NBTBase a(IntStream intStream) {
        return new NBTTagIntArray(intStream.toArray());
    }

    public DataResult<LongStream> j(NBTBase tag) {
        if (tag instanceof NBTTagLongArray) {
            NBTTagLongArray longArrayTag = (NBTTagLongArray)tag;
            return DataResult.success((Object)Arrays.stream(longArrayTag.g()));
        }
        return super.getLongStream((Object)tag);
    }

    public NBTBase a(LongStream longStream) {
        return new NBTTagLongArray(longStream.toArray());
    }

    public NBTBase b(Stream<NBTBase> stream) {
        return d.a.a(stream).a();
    }

    public NBTBase a(NBTBase tag, String string) {
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            NBTTagCompound compoundTag2 = new NBTTagCompound();
            compoundTag.e().stream().filter(k2 -> !Objects.equals(k2, string)).forEach(k2 -> compoundTag2.a((String)k2, compoundTag.c((String)k2)));
            return compoundTag2;
        }
        return tag;
    }

    @Override
    public String toString() {
        return "NBT";
    }

    public RecordBuilder<NBTBase> mapBuilder() {
        return new h();
    }

    private static Optional<f> k(NBTBase nbt) {
        if (nbt instanceof NBTTagEnd) {
            return Optional.of(d.a);
        }
        if (nbt instanceof NBTList) {
            NBTList collectionTag = (NBTList)nbt;
            if (collectionTag.isEmpty()) {
                return Optional.of(d.a);
            }
            if (collectionTag instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)collectionTag;
                return switch (listTag.f()) {
                    case 0 -> Optional.of(d.a);
                    case 10 -> Optional.of(new b(listTag));
                    default -> Optional.of(new c(listTag));
                };
            }
            if (collectionTag instanceof NBTTagByteArray) {
                NBTTagByteArray byteArrayTag = (NBTTagByteArray)collectionTag;
                return Optional.of(new a(byteArrayTag.e()));
            }
            if (collectionTag instanceof NBTTagIntArray) {
                NBTTagIntArray intArrayTag = (NBTTagIntArray)collectionTag;
                return Optional.of(new e(intArrayTag.g()));
            }
            if (collectionTag instanceof NBTTagLongArray) {
                NBTTagLongArray longArrayTag = (NBTTagLongArray)collectionTag;
                return Optional.of(new g(longArrayTag.g()));
            }
        }
        return Optional.empty();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.a((NBTBase)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.a(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.j((NBTBase)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.a(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.i((NBTBase)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.a(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.h((NBTBase)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.b(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.g((NBTBase)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.f((NBTBase)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.e((NBTBase)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.a(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.d((NBTBase)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.c((NBTBase)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.a((NBTBase)object, (MapLike<NBTBase>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.a((NBTBase)object, (NBTBase)object2, (NBTBase)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.a((NBTBase)object, list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.a((NBTBase)object, (NBTBase)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.a(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.b((NBTBase)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.a(bl);
    }

    public /* synthetic */ Object createDouble(double d2) {
        return this.a(d2);
    }

    public /* synthetic */ Object createFloat(float f2) {
        return this.a(f2);
    }

    public /* synthetic */ Object createLong(long l2) {
        return this.a(l2);
    }

    public /* synthetic */ Object createInt(int i2) {
        return this.a(i2);
    }

    public /* synthetic */ Object createShort(short s2) {
        return this.a(s2);
    }

    public /* synthetic */ Object createByte(byte b2) {
        return this.a(b2);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.a(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.a((NBTBase)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.a(dynamicOps, (NBTBase)object);
    }

    public /* synthetic */ Object empty() {
        return this.a();
    }

    static class d
    implements f {
        public static final d a = new d();

        private d() {
        }

        @Override
        @Override
        public f a(NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)nbt;
                return new b().a(compoundTag);
            }
            if (nbt instanceof NBTTagByte) {
                NBTTagByte byteTag = (NBTTagByte)nbt;
                return new a(byteTag.i());
            }
            if (nbt instanceof NBTTagInt) {
                NBTTagInt intTag = (NBTTagInt)nbt;
                return new e(intTag.g());
            }
            if (nbt instanceof NBTTagLong) {
                NBTTagLong longTag = (NBTTagLong)nbt;
                return new g(longTag.f());
            }
            return new c(nbt);
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagList();
        }
    }

    static interface f {
        public f a(NBTBase var1);

        default public f a(Iterable<NBTBase> nbts) {
            f listCollector = this;
            for (NBTBase tag : nbts) {
                listCollector = listCollector.a(tag);
            }
            return listCollector;
        }

        default public f a(Stream<NBTBase> nbts) {
            return this.a(nbts::iterator);
        }

        public NBTBase a();
    }

    class h
    extends RecordBuilder.AbstractStringBuilder<NBTBase, NBTTagCompound> {
        protected h() {
            super((DynamicOps)DynamicOpsNBT.this);
        }

        protected NBTTagCompound a() {
            return new NBTTagCompound();
        }

        protected NBTTagCompound a(String string, NBTBase tag, NBTTagCompound compoundTag) {
            compoundTag.a(string, tag);
            return compoundTag;
        }

        protected DataResult<NBTBase> a(NBTTagCompound compoundTag, NBTBase tag) {
            if (tag == null || tag == NBTTagEnd.b) {
                return DataResult.success((Object)compoundTag);
            }
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compoundTag2 = (NBTTagCompound)tag;
                NBTTagCompound compoundTag3 = new NBTTagCompound(Maps.newHashMap(compoundTag2.i()));
                for (Map.Entry<String, NBTBase> entry : compoundTag.i().entrySet()) {
                    compoundTag3.a(entry.getKey(), entry.getValue());
                }
                return DataResult.success((Object)compoundTag3);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + tag, (Object)tag);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.a(string, (NBTBase)object, (NBTTagCompound)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.a((NBTTagCompound)object, (NBTBase)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.a();
        }
    }

    static class b
    implements f {
        private final NBTTagList a = new NBTTagList();

        public b() {
        }

        public b(Collection<NBTBase> nbts) {
            this.a.addAll(nbts);
        }

        public b(IntArrayList list) {
            list.forEach(value -> this.a.add(net.minecraft.nbt.DynamicOpsNBT$b.c(NBTTagInt.a(value))));
        }

        public b(ByteArrayList list) {
            list.forEach(value -> this.a.add(net.minecraft.nbt.DynamicOpsNBT$b.c(NBTTagByte.a(value))));
        }

        public b(LongArrayList list) {
            list.forEach(value -> this.a.add(net.minecraft.nbt.DynamicOpsNBT$b.c(NBTTagLong.a(value))));
        }

        private static boolean a(NBTTagCompound nbt) {
            return nbt.f() == 1 && nbt.e(DynamicOpsNBT.b);
        }

        private static NBTBase b(NBTBase value) {
            NBTTagCompound compoundTag;
            if (value instanceof NBTTagCompound && !net.minecraft.nbt.DynamicOpsNBT$b.a(compoundTag = (NBTTagCompound)value)) {
                return compoundTag;
            }
            return net.minecraft.nbt.DynamicOpsNBT$b.c(value);
        }

        private static NBTTagCompound c(NBTBase value) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a(DynamicOpsNBT.b, value);
            return compoundTag;
        }

        @Override
        @Override
        public f a(NBTBase nbt) {
            this.a.add(net.minecraft.nbt.DynamicOpsNBT$b.b(nbt));
            return this;
        }

        @Override
        @Override
        public NBTBase a() {
            return this.a;
        }
    }

    static class c
    implements f {
        private final NBTTagList a = new NBTTagList();

        c(NBTBase nbt) {
            this.a.add(nbt);
        }

        c(NBTTagList nbt) {
            this.a.addAll(nbt);
        }

        @Override
        @Override
        public f a(NBTBase nbt) {
            if (nbt.b() != this.a.f()) {
                return new b().a(this.a).a(nbt);
            }
            this.a.add(nbt);
            return this;
        }

        @Override
        @Override
        public NBTBase a() {
            return this.a;
        }
    }

    static class a
    implements f {
        private final ByteArrayList a = new ByteArrayList();

        public a(byte value) {
            this.a.add(value);
        }

        public a(byte[] values) {
            this.a.addElements(0, values);
        }

        @Override
        @Override
        public f a(NBTBase nbt) {
            if (nbt instanceof NBTTagByte) {
                NBTTagByte byteTag = (NBTTagByte)nbt;
                this.a.add(byteTag.i());
                return this;
            }
            return new b(this.a).a(nbt);
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagByteArray(this.a.toByteArray());
        }
    }

    static class e
    implements f {
        private final IntArrayList a = new IntArrayList();

        public e(int value) {
            this.a.add(value);
        }

        public e(int[] values) {
            this.a.addElements(0, values);
        }

        @Override
        @Override
        public f a(NBTBase nbt) {
            if (nbt instanceof NBTTagInt) {
                NBTTagInt intTag = (NBTTagInt)nbt;
                this.a.add(intTag.g());
                return this;
            }
            return new b(this.a).a(nbt);
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagIntArray(this.a.toIntArray());
        }
    }

    static class g
    implements f {
        private final LongArrayList a = new LongArrayList();

        public g(long value) {
            this.a.add(value);
        }

        public g(long[] values) {
            this.a.addElements(0, values);
        }

        @Override
        @Override
        public f a(NBTBase nbt) {
            if (nbt instanceof NBTTagLong) {
                NBTTagLong longTag = (NBTTagLong)nbt;
                this.a.add(longTag.f());
                return this;
            }
            return new b(this.a).a(nbt);
        }

        @Override
        @Override
        public NBTBase a() {
            return new NBTTagLongArray(this.a.toLongArray());
        }
    }
}

