/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;
import org.spigotmc.LimitStream;

public class NBTCompressedStreamTools {
    private static final OpenOption[] a = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static NBTTagCompound a(Path path, NBTReadLimiter tagSizeTracker) throws IOException {
        NBTTagCompound nbttagcompound;
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);){
            nbttagcompound = NBTCompressedStreamTools.a(inputstream, tagSizeTracker);
        }
        return nbttagcompound;
    }

    private static DataInputStream a(InputStream stream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(stream)));
    }

    private static DataOutputStream a(OutputStream stream) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream)));
    }

    public static NBTTagCompound a(InputStream stream, NBTReadLimiter tagSizeTracker) throws IOException {
        NBTTagCompound nbttagcompound;
        try (DataInputStream datainputstream = NBTCompressedStreamTools.a(stream);){
            nbttagcompound = NBTCompressedStreamTools.a(datainputstream, tagSizeTracker);
        }
        return nbttagcompound;
    }

    public static void a(Path path, StreamTagVisitor scanner, NBTReadLimiter tracker) throws IOException {
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);){
            NBTCompressedStreamTools.a(inputstream, scanner, tracker);
        }
    }

    public static void a(InputStream stream, StreamTagVisitor scanner, NBTReadLimiter tracker) throws IOException {
        try (DataInputStream datainputstream = NBTCompressedStreamTools.a(stream);){
            NBTCompressedStreamTools.a((DataInput)datainputstream, scanner, tracker);
        }
    }

    public static void a(NBTTagCompound nbt, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, a);
             BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(outputstream);){
            NBTCompressedStreamTools.a(nbt, bufferedoutputstream);
        }
    }

    public static void a(NBTTagCompound nbt, OutputStream stream) throws IOException {
        try (DataOutputStream dataoutputstream = NBTCompressedStreamTools.a(stream);){
            NBTCompressedStreamTools.a(nbt, (DataOutput)dataoutputstream);
        }
    }

    public static void b(NBTTagCompound nbt, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, a);
             BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(outputstream);
             DataOutputStream dataoutputstream = new DataOutputStream(bufferedoutputstream);){
            NBTCompressedStreamTools.a(nbt, (DataOutput)dataoutputstream);
        }
    }

    @Nullable
    public static NBTTagCompound a(Path path) throws IOException {
        NBTTagCompound nbttagcompound;
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             DataInputStream datainputstream = new DataInputStream(inputstream);){
            nbttagcompound = NBTCompressedStreamTools.a(datainputstream, NBTReadLimiter.a());
        }
        return nbttagcompound;
    }

    public static NBTTagCompound a(DataInput input) throws IOException {
        return NBTCompressedStreamTools.a(input, NBTReadLimiter.a());
    }

    public static NBTTagCompound a(DataInput input, NBTReadLimiter tracker) throws IOException {
        NBTBase nbtbase;
        if (input instanceof ByteBufInputStream) {
            input = new DataInputStream(new LimitStream((InputStream)((Object)input), tracker));
        }
        if ((nbtbase = NBTCompressedStreamTools.c(input, tracker)) instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void a(NBTTagCompound nbt, DataOutput output) throws IOException {
        NBTCompressedStreamTools.c(nbt, output);
    }

    public static void a(DataInput input, StreamTagVisitor scanner, NBTReadLimiter tracker) throws IOException {
        NBTTagType<?> nbttagtype = NBTTagTypes.a(input.readByte());
        if (nbttagtype == NBTTagEnd.a) {
            if (scanner.b(NBTTagEnd.a) == StreamTagVisitor.b.a) {
                scanner.a();
            }
        } else {
            switch (scanner.b(nbttagtype)) {
                default: {
                    break;
                }
                case b: {
                    NBTTagString.a(input);
                    nbttagtype.b(input, tracker);
                    break;
                }
                case a: {
                    NBTTagString.a(input);
                    nbttagtype.a(input, scanner, tracker);
                }
            }
        }
    }

    public static NBTBase b(DataInput input, NBTReadLimiter tracker) throws IOException {
        byte b0 = input.readByte();
        return b0 == 0 ? NBTTagEnd.b : NBTCompressedStreamTools.a(input, tracker, b0);
    }

    public static void a(NBTBase nbt, DataOutput output) throws IOException {
        output.writeByte(nbt.b());
        if (nbt.b() != 0) {
            nbt.a(output);
        }
    }

    public static void b(NBTBase nbt, DataOutput output) throws IOException {
        output.writeByte(nbt.b());
        if (nbt.b() != 0) {
            output.writeUTF("");
            nbt.a(output);
        }
    }

    public static void c(NBTBase nbt, DataOutput output) throws IOException {
        NBTCompressedStreamTools.b(nbt, new a(output));
    }

    private static NBTBase c(DataInput input, NBTReadLimiter tracker) throws IOException {
        byte b0 = input.readByte();
        if (b0 == 0) {
            return NBTTagEnd.b;
        }
        NBTTagString.a(input);
        return NBTCompressedStreamTools.a(input, tracker, b0);
    }

    private static NBTBase a(DataInput input, NBTReadLimiter tracker, byte typeId) {
        try {
            return NBTTagTypes.a(typeId).c(input, tracker);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.a(ioexception, "Loading NBT data");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("NBT Tag");
            crashreportsystemdetails.a("Tag type", typeId);
            throw new ReportedNbtException(crashreport);
        }
    }

    public static class a
    extends DelegateDataOutput {
        public a(DataOutput delegate) {
            super(delegate);
        }

        @Override
        public void writeUTF(String s2) throws IOException {
            try {
                super.writeUTF(s2);
            }
            catch (UTFDataFormatException utfdataformatexception) {
                SystemUtils.a("Failed to write NBT String", (Throwable)utfdataformatexception);
                super.writeUTF("");
            }
        }
    }
}

