/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import top.leavesmc.leaves.util.ArrayConstants;

public class NBTTagCompound
implements NBTBase {
    public static final Codec<NBTTagCompound> a = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        NBTTagCompound compoundTag;
        NBTBase tag = dynamic.convert(DynamicOpsNBT.a).getValue();
        return tag instanceof NBTTagCompound ? DataResult.success((Object)((compoundTag = (NBTTagCompound)tag) == dynamic.getValue() ? compoundTag.h() : compoundTag)) : DataResult.error(() -> "Not a compound tag: " + tag);
    }, nbt -> new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.h()));
    private static final int c = 48;
    private static final int w = 32;
    public static final NBTTagType<NBTTagCompound> b = new NBTTagType.b<NBTTagCompound>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NBTTagCompound a(DataInput dataInput, NBTReadLimiter nbtAccounter) throws IOException {
            NBTTagCompound var3;
            nbtAccounter.b();
            try {
                var3 = 1.d(dataInput, nbtAccounter);
            }
            finally {
                nbtAccounter.c();
            }
            return var3;
        }

        private static NBTTagCompound d(DataInput input, NBTReadLimiter tracker) throws IOException {
            byte b2;
            tracker.b(48L);
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(8, 0.8f);
            while ((b2 = input.readByte()) != 0) {
                NBTBase tag;
                String string = 1.e(input, tracker);
                if (map.put((Object)string, (Object)(tag = NBTTagCompound.a(NBTTagTypes.a(b2), string, input, tracker))) != null) continue;
                tracker.b(36L);
            }
            return new NBTTagCompound((Map<String, NBTBase>)map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter tracker) throws IOException {
            StreamTagVisitor.b var4;
            tracker.b();
            try {
                var4 = 1.c(input, visitor, tracker);
            }
            finally {
                tracker.c();
            }
            return var4;
        }

        private static StreamTagVisitor.b c(DataInput input, StreamTagVisitor visitor, NBTReadLimiter tracker) throws IOException {
            byte b2;
            tracker.b(48L);
            block13: while ((b2 = input.readByte()) != 0) {
                NBTTagType<?> tagType = NBTTagTypes.a(b2);
                switch (visitor.a(tagType)) {
                    case d: {
                        return StreamTagVisitor.b.c;
                    }
                    case c: {
                        NBTTagString.a(input);
                        tagType.b(input, tracker);
                        break block13;
                    }
                    case b: {
                        NBTTagString.a(input);
                        tagType.b(input, tracker);
                        continue block13;
                    }
                    default: {
                        String string = 1.e(input, tracker);
                        switch (visitor.a(tagType, string)) {
                            case d: {
                                return StreamTagVisitor.b.c;
                            }
                            case c: {
                                tagType.b(input, tracker);
                                break block13;
                            }
                            case b: {
                                tagType.b(input, tracker);
                                continue block13;
                            }
                        }
                        tracker.b(36L);
                        switch (tagType.a(input, visitor, tracker)) {
                            case c: {
                                return StreamTagVisitor.b.c;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (b2 != 0) {
                while ((b2 = input.readByte()) != 0) {
                    NBTTagString.a(input);
                    NBTTagTypes.a(b2).b(input, tracker);
                }
            }
            return visitor.b();
        }

        private static String e(DataInput input, NBTReadLimiter tracker) throws IOException {
            String string = input.readUTF();
            tracker.b(28L);
            tracker.a(2L, string.length());
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void b(DataInput input, NBTReadLimiter tracker) throws IOException {
            tracker.b();
            try {
                byte b2;
                while ((b2 = input.readByte()) != 0) {
                    NBTTagString.a(input);
                    NBTTagTypes.a(b2).b(input, tracker);
                }
            }
            finally {
                tracker.c();
            }
        }

        @Override
        public String a() {
            return "COMPOUND";
        }

        @Override
        public String b() {
            return "TAG_Compound";
        }
    };
    public final Map<String, NBTBase> x;

    protected NBTTagCompound(Map<String, NBTBase> entries) {
        this.x = entries;
    }

    public NBTTagCompound() {
        this((Map<String, NBTBase>)new Object2ObjectOpenHashMap(8, 0.8f));
    }

    @Override
    public void a(DataOutput output) throws IOException {
        for (String string : this.x.keySet()) {
            NBTBase tag = this.x.get(string);
            NBTTagCompound.a(string, tag, output);
        }
        output.writeByte(0);
    }

    @Override
    public int a() {
        int i2 = 48;
        for (Map.Entry<String, NBTBase> entry : this.x.entrySet()) {
            i2 += 28 + 2 * entry.getKey().length();
            i2 += 36;
            i2 += entry.getValue().a();
        }
        return i2;
    }

    public Set<String> e() {
        return this.x.keySet();
    }

    @Override
    public byte b() {
        return 10;
    }

    public NBTTagType<NBTTagCompound> c() {
        return b;
    }

    public int f() {
        return this.x.size();
    }

    @Nullable
    public NBTBase a(String key, NBTBase element) {
        return this.x.put(key, element);
    }

    public void a(String key, byte value) {
        this.x.put(key, NBTTagByte.a(value));
    }

    public void a(String key, short value) {
        this.x.put(key, NBTTagShort.a(value));
    }

    public void a(String key, int value) {
        this.x.put(key, NBTTagInt.a(value));
    }

    public void a(String key, long value) {
        this.x.put(key, NBTTagLong.a(value));
    }

    public void a(String key, UUID value) {
        if (this.b(key + "Most", 99) && this.b(key + "Least", 99)) {
            this.x.remove(key + "Most");
            this.x.remove(key + "Least");
        }
        this.x.put(key, GameProfileSerializer.a(value));
    }

    public UUID a(String key) {
        if (!this.b(key, 11) && this.b(key + "Most", 99) && this.b(key + "Least", 99)) {
            return new UUID(this.i(key + "Most"), this.i(key + "Least"));
        }
        return GameProfileSerializer.a(this.c(key));
    }

    public boolean b(String key) {
        if (this.b(key + "Most", 99) && this.b(key + "Least", 99)) {
            return true;
        }
        NBTBase tag = this.c(key);
        return tag != null && tag.c() == NBTTagIntArray.a && ((NBTTagIntArray)tag).g().length == 4;
    }

    public void a(String key, float value) {
        this.x.put(key, NBTTagFloat.a(value));
    }

    public void a(String key, double value) {
        this.x.put(key, NBTTagDouble.a(value));
    }

    public void a(String key, String value) {
        this.x.put(key, NBTTagString.a(value));
    }

    public void a(String key, byte[] value) {
        this.x.put(key, new NBTTagByteArray(value));
    }

    public void a(String key, List<Byte> value) {
        this.x.put(key, new NBTTagByteArray(value));
    }

    public void a(String key, int[] value) {
        this.x.put(key, new NBTTagIntArray(value));
    }

    public void b(String key, List<Integer> value) {
        this.x.put(key, new NBTTagIntArray(value));
    }

    public void a(String key, long[] value) {
        this.x.put(key, new NBTTagLongArray(value));
    }

    public void c(String key, List<Long> value) {
        this.x.put(key, new NBTTagLongArray(value));
    }

    public void a(String key, boolean value) {
        this.x.put(key, NBTTagByte.a(value));
    }

    @Nullable
    public NBTBase c(String key) {
        return this.x.get(key);
    }

    public byte d(String key) {
        NBTBase tag = this.x.get(key);
        return tag == null ? (byte)0 : tag.b();
    }

    public boolean e(String key) {
        return this.x.containsKey(key);
    }

    public boolean b(String key, int type) {
        byte i2 = this.d(key);
        return i2 == type || type == 99 && (i2 == 1 || i2 == 2 || i2 == 3 || i2 == 4 || i2 == 5 || i2 == 6);
    }

    public byte f(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).i();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short g(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int h(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long i(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float j(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).k();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double k(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).j();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String l(String key) {
        try {
            if (this.b(key, 8)) {
                return this.x.get(key).t_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] m(String key) {
        try {
            if (this.b(key, 7)) {
                return ((NBTTagByteArray)this.x.get(key)).e();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.a(key, NBTTagByteArray.a, var3));
        }
        return ArrayConstants.emptyByteArray;
    }

    public int[] n(String key) {
        try {
            if (this.b(key, 11)) {
                return ((NBTTagIntArray)this.x.get(key)).g();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.a(key, NBTTagIntArray.a, var3));
        }
        return ArrayConstants.emptyIntArray;
    }

    public long[] o(String key) {
        try {
            if (this.b(key, 12)) {
                return ((NBTTagLongArray)this.x.get(key)).g();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.a(key, NBTTagLongArray.a, var3));
        }
        return ArrayConstants.emptyLongArray;
    }

    public NBTTagCompound p(String key) {
        try {
            if (this.b(key, 10)) {
                return (NBTTagCompound)this.x.get(key);
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.a(key, b, var3));
        }
        return new NBTTagCompound();
    }

    public NBTTagList c(String key, int type) {
        try {
            if (this.d(key) == 9) {
                NBTTagList listTag = (NBTTagList)this.x.get(key);
                if (!listTag.isEmpty() && listTag.f() != type) {
                    return new NBTTagList();
                }
                return listTag;
            }
        }
        catch (ClassCastException var4) {
            throw new ReportedException(this.a(key, NBTTagList.a, var4));
        }
        return new NBTTagList();
    }

    public boolean q(String key) {
        return this.f(key) != 0;
    }

    public void r(String key) {
        this.x.remove(key);
    }

    @Override
    public String toString() {
        return this.t_();
    }

    public boolean g() {
        return this.x.isEmpty();
    }

    private CrashReport a(String key, NBTTagType<?> reader, ClassCastException exception) {
        CrashReport crashReport = CrashReport.a(exception, "Reading NBT data");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Corrupt NBT tag", 1);
        crashReportCategory.a("Tag type found", () -> this.x.get(key).c().a());
        crashReportCategory.a("Tag type expected", reader::a);
        crashReportCategory.a("Tag name", key);
        return crashReport;
    }

    public NBTTagCompound h() {
        ObjectIterator iterator;
        Object2ObjectOpenHashMap ret = new Object2ObjectOpenHashMap(this.x.size(), 0.8f);
        ObjectIterator objectIterator = iterator = this.x instanceof Object2ObjectOpenHashMap ? ((Object2ObjectOpenHashMap)this.x).object2ObjectEntrySet().fastIterator() : this.x.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put((Object)((String)entry.getKey()), (Object)((NBTBase)entry.getValue()).d());
        }
        return new NBTTagCompound((Map<String, NBTBase>)ret);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof NBTTagCompound && Objects.equals(this.x, ((NBTTagCompound)object).x);
    }

    public int hashCode() {
        return this.x.hashCode();
    }

    private static void a(String key, NBTBase element, DataOutput output) throws IOException {
        output.writeByte(element.b());
        if (element.b() != 0) {
            output.writeUTF(key);
            element.a(output);
        }
    }

    static NBTBase a(NBTTagType<?> reader, String key, DataInput input, NBTReadLimiter tracker) {
        try {
            return reader.c(input, tracker);
        }
        catch (IOException var7) {
            CrashReport crashReport = CrashReport.a(var7, "Loading NBT data");
            CrashReportSystemDetails crashReportCategory = crashReport.a("NBT Tag");
            crashReportCategory.a("Tag name", key);
            crashReportCategory.a("Tag type", reader.a());
            throw new ReportedNbtException(crashReport);
        }
    }

    public NBTTagCompound a(NBTTagCompound source) {
        for (String string : source.x.keySet()) {
            NBTBase tag = source.x.get(string);
            if (tag.b() == 10) {
                if (this.b(string, 10)) {
                    NBTTagCompound compoundTag = this.p(string);
                    compoundTag.a((NBTTagCompound)tag);
                    continue;
                }
                this.a(string, tag.d());
                continue;
            }
            this.a(string, tag.d());
        }
        return this;
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    protected Map<String, NBTBase> i() {
        return Collections.unmodifiableMap(this.x);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        block14: for (Map.Entry<String, NBTBase> entry : this.x.entrySet()) {
            NBTBase tag = entry.getValue();
            NBTTagType<?> tagType = tag.c();
            StreamTagVisitor.a entryResult = visitor.a(tagType);
            switch (entryResult) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                case b: {
                    continue block14;
                }
            }
            entryResult = visitor.a(tagType, entry.getKey());
            switch (entryResult) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                case b: {
                    continue block14;
                }
            }
            StreamTagVisitor.b valueResult = tag.a(visitor);
            switch (valueResult) {
                case c: {
                    return StreamTagVisitor.b.c;
                }
                case b: {
                    return visitor.b();
                }
            }
        }
        return visitor.b();
    }
}

