/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;
import top.leavesmc.leaves.util.ArrayConstants;

public class NBTTagIntArray
extends NBTList<NBTTagInt> {
    private static final int b = 24;
    public static final NBTTagType<NBTTagIntArray> a = new NBTTagType.b<NBTTagIntArray>(){

        public NBTTagIntArray a(DataInput input, NBTReadLimiter tracker) throws IOException {
            return new NBTTagIntArray(1.d(input, tracker));
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter tracker) throws IOException {
            return visitor.a(1.d(input, tracker));
        }

        private static int[] d(DataInput input, NBTReadLimiter tracker) throws IOException {
            tracker.b(24L);
            int i2 = input.readInt();
            Preconditions.checkArgument((i2 < 0x1000000 ? 1 : 0) != 0);
            tracker.a(4L, i2);
            int[] aint = new int[i2];
            for (int j2 = 0; j2 < i2; ++j2) {
                aint[j2] = input.readInt();
            }
            return aint;
        }

        @Override
        public void b(DataInput input, NBTReadLimiter tracker) throws IOException {
            input.skipBytes(input.readInt() * 4);
        }

        @Override
        public String a() {
            return "INT[]";
        }

        @Override
        public String b() {
            return "TAG_Int_Array";
        }
    };
    private int[] c;

    public NBTTagIntArray(int[] value) {
        this.c = value;
    }

    public NBTTagIntArray(List<Integer> value) {
        this(NBTTagIntArray.a(value));
    }

    private static int[] a(List<Integer> list) {
        int[] aint = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Integer integer = list.get(i2);
            aint[i2] = integer == null ? 0 : integer;
        }
        return aint;
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeInt(this.c.length);
        for (int k2 : this.c) {
            output.writeInt(k2);
        }
    }

    @Override
    public int a() {
        return 24 + 4 * this.c.length;
    }

    @Override
    public byte b() {
        return 11;
    }

    public NBTTagType<NBTTagIntArray> c() {
        return a;
    }

    @Override
    public String toString() {
        return this.t_();
    }

    public NBTTagIntArray e() {
        int[] aint = new int[this.c.length];
        System.arraycopy(this.c, 0, aint, 0, this.c.length);
        return new NBTTagIntArray(aint);
    }

    @Override
    public boolean equals(Object object) {
        return this == object ? true : object instanceof NBTTagIntArray && Arrays.equals(this.c, ((NBTTagIntArray)object).c);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    public int[] g() {
        return this.c;
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagInt a(int i2) {
        return NBTTagInt.a(this.c[i2]);
    }

    public NBTTagInt a(int i2, NBTTagInt nbttagint) {
        int j2 = this.c[i2];
        this.c[i2] = nbttagint.g();
        return NBTTagInt.a(j2);
    }

    public void b(int i2, NBTTagInt nbttagint) {
        this.c = ArrayUtils.add((int[])this.c, (int)i2, (int)nbttagint.g());
    }

    @Override
    public boolean a(int index, NBTBase element) {
        if (element instanceof NBTNumber) {
            this.c[index] = ((NBTNumber)element).g();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int index, NBTBase element) {
        if (element instanceof NBTNumber) {
            this.c = ArrayUtils.add((int[])this.c, (int)index, (int)((NBTNumber)element).g());
            return true;
        }
        return false;
    }

    public NBTTagInt b(int i2) {
        int j2 = this.c[i2];
        this.c = ArrayUtils.remove((int[])this.c, (int)i2);
        return NBTTagInt.a(j2);
    }

    @Override
    public byte f() {
        return 3;
    }

    @Override
    public void clear() {
        this.c = ArrayConstants.emptyIntArray;
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.c);
    }
}

