/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 8;
    private static final ByteCollection c = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final EnumChatFormat d = EnumChatFormat.l;
    private static final EnumChatFormat e = EnumChatFormat.k;
    private static final EnumChatFormat f = EnumChatFormat.g;
    private static final EnumChatFormat g = EnumChatFormat.m;
    private static final Pattern h = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String i = String.valueOf(':');
    private static final String j = String.valueOf(',');
    private static final String k = "[";
    private static final String l = "]";
    private static final String m = ";";
    private static final String n = " ";
    private static final String o = "{";
    private static final String p = "}";
    private static final String q = "\n";
    private final String r;
    private final int s;
    private IChatBaseComponent t = CommonComponents.a;

    public TextComponentTagVisitor(String prefix, int indentationLevel) {
        this.r = prefix;
        this.s = indentationLevel;
    }

    public IChatBaseComponent a(NBTBase element) {
        element.a(this);
        return this.t;
    }

    @Override
    @Override
    public void a(NBTTagString element) {
        String string = NBTTagString.b(element.t_());
        String string2 = string.substring(0, 1);
        IChatMutableComponent component = IChatBaseComponent.b(string.substring(1, string.length() - 1)).a(e);
        this.t = IChatBaseComponent.b(string2).b(component).f(string2);
    }

    @Override
    @Override
    public void a(NBTTagByte element) {
        IChatMutableComponent component = IChatBaseComponent.b("b").a(g);
        this.t = IChatBaseComponent.b(String.valueOf(element.l())).b(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagShort element) {
        IChatMutableComponent component = IChatBaseComponent.b("s").a(g);
        this.t = IChatBaseComponent.b(String.valueOf(element.l())).b(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagInt element) {
        this.t = IChatBaseComponent.b(String.valueOf(element.l())).a(f);
    }

    @Override
    @Override
    public void a(NBTTagLong element) {
        IChatMutableComponent component = IChatBaseComponent.b("L").a(g);
        this.t = IChatBaseComponent.b(String.valueOf(element.l())).b(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagFloat element) {
        IChatMutableComponent component = IChatBaseComponent.b("f").a(g);
        this.t = IChatBaseComponent.b(String.valueOf(element.k())).b(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagDouble element) {
        IChatMutableComponent component = IChatBaseComponent.b("d").a(g);
        this.t = IChatBaseComponent.b(String.valueOf(element.j())).b(component).a(f);
    }

    @Override
    @Override
    public void a(NBTTagByteArray element) {
        IChatMutableComponent component = IChatBaseComponent.b("B").a(g);
        IChatMutableComponent mutableComponent = IChatBaseComponent.b(k).b(component).f(m);
        byte[] bs = element.e();
        for (int i2 = 0; i2 < bs.length; ++i2) {
            IChatMutableComponent mutableComponent2 = IChatBaseComponent.b(String.valueOf(bs[i2])).a(f);
            mutableComponent.f(n).b(mutableComponent2).b(component);
            if (i2 == bs.length - 1) continue;
            mutableComponent.f(j);
        }
        mutableComponent.f(l);
        this.t = mutableComponent;
    }

    @Override
    @Override
    public void a(NBTTagIntArray element) {
        IChatMutableComponent component = IChatBaseComponent.b("I").a(g);
        IChatMutableComponent mutableComponent = IChatBaseComponent.b(k).b(component).f(m);
        int[] is = element.g();
        for (int i2 = 0; i2 < is.length; ++i2) {
            mutableComponent.f(n).b(IChatBaseComponent.b(String.valueOf(is[i2])).a(f));
            if (i2 == is.length - 1) continue;
            mutableComponent.f(j);
        }
        mutableComponent.f(l);
        this.t = mutableComponent;
    }

    @Override
    @Override
    public void a(NBTTagLongArray element) {
        IChatMutableComponent component = IChatBaseComponent.b("L").a(g);
        IChatMutableComponent mutableComponent = IChatBaseComponent.b(k).b(component).f(m);
        long[] ls = element.g();
        for (int i2 = 0; i2 < ls.length; ++i2) {
            IChatMutableComponent component2 = IChatBaseComponent.b(String.valueOf(ls[i2])).a(f);
            mutableComponent.f(n).b(component2).b(component);
            if (i2 == ls.length - 1) continue;
            mutableComponent.f(j);
        }
        mutableComponent.f(l);
        this.t = mutableComponent;
    }

    @Override
    @Override
    public void a(NBTTagList element) {
        if (element.isEmpty()) {
            this.t = IChatBaseComponent.b("[]");
            return;
        }
        if (c.contains(element.f()) && element.size() <= 8) {
            String string = j + n;
            IChatMutableComponent mutableComponent = IChatBaseComponent.b(k);
            for (int i2 = 0; i2 < element.size(); ++i2) {
                if (i2 != 0) {
                    mutableComponent.f(string);
                }
                mutableComponent.b(new TextComponentTagVisitor(this.r, this.s).a(element.k(i2)));
            }
            mutableComponent.f(l);
            this.t = mutableComponent;
            return;
        }
        IChatMutableComponent mutableComponent2 = IChatBaseComponent.b(k);
        if (!this.r.isEmpty()) {
            mutableComponent2.f(q);
        }
        for (int j2 = 0; j2 < element.size(); ++j2) {
            IChatMutableComponent mutableComponent3 = IChatBaseComponent.b(Strings.repeat((String)this.r, (int)(this.s + 1)));
            mutableComponent3.b(new TextComponentTagVisitor(this.r, this.s + 1).a(element.k(j2)));
            if (j2 != element.size() - 1) {
                mutableComponent3.f(j).f(this.r.isEmpty() ? n : q);
            }
            mutableComponent2.b(mutableComponent3);
        }
        if (!this.r.isEmpty()) {
            mutableComponent2.f(q).f(Strings.repeat((String)this.r, (int)this.s));
        }
        mutableComponent2.f(l);
        this.t = mutableComponent2;
    }

    @Override
    @Override
    public void a(NBTTagCompound compound) {
        if (compound.g()) {
            this.t = IChatBaseComponent.b("{}");
            return;
        }
        IChatMutableComponent mutableComponent = IChatBaseComponent.b(o);
        Collection<String> collection = compound.e();
        if (a.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(compound.e());
            Collections.sort(list);
            collection = list;
        }
        if (!this.r.isEmpty()) {
            mutableComponent.f(q);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IChatMutableComponent mutableComponent2 = IChatBaseComponent.b(Strings.repeat((String)this.r, (int)(this.s + 1))).b(TextComponentTagVisitor.a(string)).f(i).f(n).b(new TextComponentTagVisitor(this.r, this.s + 1).a(compound.c(string)));
            if (iterator.hasNext()) {
                mutableComponent2.f(j).f(this.r.isEmpty() ? n : q);
            }
            mutableComponent.b(mutableComponent2);
        }
        if (!this.r.isEmpty()) {
            mutableComponent.f(q).f(Strings.repeat((String)this.r, (int)this.s));
        }
        mutableComponent.f(p);
        this.t = mutableComponent;
    }

    protected static IChatBaseComponent a(String name) {
        if (h.matcher(name).matches()) {
            return IChatBaseComponent.b(name).a(d);
        }
        String string = NBTTagString.b(name);
        String string2 = string.substring(0, 1);
        IChatMutableComponent component = IChatBaseComponent.b(string.substring(1, string.length() - 1)).a(d);
        return IChatBaseComponent.b(string2).b(component).f(string2);
    }

    @Override
    @Override
    public void a(NBTTagEnd element) {
        this.t = CommonComponents.a;
    }
}

