/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent;
import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.network.ConnectionEvent;
import io.papermc.paper.util.IntervalledCounter;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketFlowValidator;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SampleLogger;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.event.player.PlayerQuitEvent;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float j = 0.75f;
    private static final Logger k = LogUtils.getLogger();
    public static final Marker a = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker b = SystemUtils.a(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), (? super T marker) -> marker.add(a));
    public static final Marker c = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), (? super T marker) -> marker.add(b));
    public static final Marker d = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_SENT"), (? super T marker) -> marker.add(b));
    public static final AttributeKey<EnumProtocol.a<?>> e = AttributeKey.valueOf((String)"serverbound_protocol");
    public static final AttributeKey<EnumProtocol.a<?>> f = AttributeKey.valueOf((String)"clientbound_protocol");
    public static final Supplier<NioEventLoopGroup> g = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(k)).build()));
    public static final Supplier<EpollEventLoopGroup> h = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(k)).build()));
    public static final Supplier<DefaultEventLoopGroup> i = Suppliers.memoize(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(k)).build()));
    private final EnumProtocolDirection l;
    private final Queue<WrappedConsumer> m = Queues.newConcurrentLinkedQueue();
    public Channel n;
    public SocketAddress o;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    @Nullable
    private volatile PacketListener p;
    @Nullable
    private volatile PacketListener q;
    @Nullable
    private IChatBaseComponent r;
    private boolean s;
    private boolean t;
    private int u;
    private int v;
    private float w;
    private float x;
    private int y;
    private boolean z;
    @Nullable
    private volatile IChatBaseComponent A;
    @Nullable
    BandwidthDebugMonitor B;
    public String hostname = "";
    public int protocolVersion;
    public InetSocketAddress virtualHost;
    private static boolean enableExplicitFlush = Boolean.getBoolean("paper.explicit-flush");
    public boolean isPending = true;
    public boolean queueImmunity;
    protected final Object PACKET_LIMIT_LOCK = new Object();
    @Nullable
    protected final IntervalledCounter allPacketCounts;
    protected final Map<Class<? extends Packet<?>>, IntervalledCounter> packetSpecificLimits;
    private boolean stopReadingPackets;
    private static final int MAX_PER_TICK = GlobalConfiguration.get().misc.maxJoinsPerTick;
    private static int joinAttemptsThisTick;
    private static int currTick;

    public final EntityPlayer getPlayer() {
        PacketListener packetListener = this.q;
        if (packetListener instanceof PlayerConnection) {
            PlayerConnection impl = (PlayerConnection)packetListener;
            return impl.e;
        }
        packetListener = this.q;
        if (packetListener instanceof ServerCommonPacketListenerImpl) {
            ServerCommonPacketListenerImpl impl = (ServerCommonPacketListenerImpl)packetListener;
            CraftPlayer player = impl.getCraftPlayer();
            return player == null ? null : player.getHandle();
        }
        return null;
    }

    private void killForPacketSpam() {
        this.b(new ClientboundDisconnectPacket(PaperAdventure.asVanilla(GlobalConfiguration.get().packetLimiter.kickMessage)), PacketSendListener.a(() -> this.a(PaperAdventure.asVanilla(GlobalConfiguration.get().packetLimiter.kickMessage))), true);
        this.o();
        this.stopReadingPackets = true;
    }

    public NetworkManager(EnumProtocolDirection side) {
        this.allPacketCounts = GlobalConfiguration.get().packetLimiter.allPackets.isEnabled() ? new IntervalledCounter((long)(GlobalConfiguration.get().packetLimiter.allPackets.interval() * 1.0E9)) : null;
        this.packetSpecificLimits = new HashMap();
        this.l = side;
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        super.channelActive(channelhandlercontext);
        this.n = channelhandlercontext.channel();
        this.o = this.n.remoteAddress();
        this.preparing = false;
        if (this.A != null) {
            this.a(this.A);
        }
    }

    public static void a(Channel channel) {
        channel.attr(e).set(EnumProtocol.a.b(EnumProtocolDirection.a));
        channel.attr(f).set(EnumProtocol.a.b(EnumProtocolDirection.b));
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.a(IChatBaseComponent.c("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        Throwable throwable2;
        if (throwable instanceof EncoderException && (throwable2 = throwable.getCause()) instanceof PacketEncoder.PacketTooLargeException) {
            PacketEncoder.PacketTooLargeException packetTooLargeException = (PacketEncoder.PacketTooLargeException)throwable2;
            Packet<?> packet = packetTooLargeException.getPacket();
            Attribute codecDataAttribute = channelhandlercontext.channel().attr(packetTooLargeException.codecKey);
            if (packet.packetTooLarge(this)) {
                ProtocolSwapHandler.a(codecDataAttribute, packet);
                return;
            }
            if (packet.b()) {
                k.debug("Skipping packet due to errors", throwable.getCause());
                ProtocolSwapHandler.a(codecDataAttribute, packet);
                return;
            }
            throwable = throwable.getCause();
        }
        if (throwable instanceof SkipEncodeException) {
            k.debug("Skipping packet due to errors", throwable.getCause());
        } else {
            boolean flag = !this.z;
            this.z = true;
            if (this.n.isOpen()) {
                EntityPlayer player = this.getPlayer();
                if (throwable instanceof TimeoutException) {
                    k.debug("Timeout", throwable);
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.TIMED_OUT;
                    }
                    this.a(IChatBaseComponent.c("disconnect.timeout"));
                } else {
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("disconnect.genericReason", new Object[]{"Internal Exception: " + throwable});
                    if (player != null) {
                        player.quitReason = PlayerQuitEvent.QuitReason.ERRONEOUS_STATE;
                    }
                    if (flag) {
                        k.debug("Failed to sent packet", throwable);
                        if (this.i() == EnumProtocolDirection.b) {
                            EnumProtocol enumprotocol = ((EnumProtocol.a)this.n.attr(f).get()).a();
                            Packet<PacketLoginOutListener> packet = enumprotocol == EnumProtocol.d ? new PacketLoginOutDisconnect(ichatmutablecomponent) : new ClientboundDisconnectPacket(ichatmutablecomponent);
                            this.a(packet, PacketSendListener.a(() -> this.a(ichatmutablecomponent)));
                        } else {
                            this.a(ichatmutablecomponent);
                        }
                        this.o();
                    } else {
                        k.debug("Double fault", throwable);
                        this.a(ichatmutablecomponent);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            TraceUtil.printStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ChannelHandlerContext channelhandlercontext, Packet<?> packet) {
        if (this.n.isOpen()) {
            PacketListener packetlistener = this.q;
            if (packetlistener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (this.stopReadingPackets) {
                return;
            }
            if (this.allPacketCounts != null || GlobalConfiguration.get().packetLimiter.overrides.containsKey(packet.getClass())) {
                long time = System.nanoTime();
                Object object = this.PACKET_LIMIT_LOCK;
                synchronized (object) {
                    if (this.allPacketCounts != null) {
                        this.allPacketCounts.updateAndAdd(1L, time);
                        if (this.allPacketCounts.getRate() >= GlobalConfiguration.get().packetLimiter.allPackets.maxPacketRate()) {
                            this.killForPacketSpam();
                            return;
                        }
                    }
                    for (Class<?> check = packet.getClass(); check != Object.class; check = check.getSuperclass()) {
                        GlobalConfiguration.PacketLimiter.PacketLimit packetSpecificLimit = GlobalConfiguration.get().packetLimiter.overrides.get(check);
                        if (packetSpecificLimit == null || !packetSpecificLimit.isEnabled()) continue;
                        IntervalledCounter counter = this.packetSpecificLimits.computeIfAbsent(check, clazz -> new IntervalledCounter((long)(packetSpecificLimit.interval() * 1.0E9)));
                        counter.updateAndAdd(1L, time);
                        if (!(counter.getRate() >= packetSpecificLimit.maxPacketRate())) continue;
                        switch (packetSpecificLimit.action()) {
                            case DROP: {
                                return;
                            }
                            case KICK: {
                                String playerName;
                                String deobfedPacketName = ObfHelper.INSTANCE.deobfClassName(check.getName());
                                PacketListener packetListener = this.q;
                                if (packetListener instanceof ServerCommonPacketListenerImpl) {
                                    ServerCommonPacketListenerImpl impl = (ServerCommonPacketListenerImpl)packetListener;
                                    playerName = impl.k().getName();
                                } else {
                                    playerName = this.a(MinecraftServer.getServer().bj());
                                }
                                k.warn("{} kicked for packet spamming: {}", (Object)playerName, (Object)deobfedPacketName.substring(deobfedPacketName.lastIndexOf(".") + 1));
                                this.killForPacketSpam();
                                return;
                            }
                        }
                    }
                }
            }
            if (packetlistener.a(packet)) {
                try {
                    NetworkManager.a(packet, packetlistener);
                }
                catch (CancelledPacketHandleException time) {
                }
                catch (ServerStopRejectedExecutionException time) {
                }
                catch (RejectedExecutionException rejectedexecutionexception) {
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException classcastexception) {
                    k.error("Received {} that couldn't be processed", packet.getClass(), (Object)classcastexception);
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_packet"));
                }
                ++this.u;
            }
        }
    }

    private static <T extends PacketListener> void a(Packet<T> packet, PacketListener listener) {
        packet.a(listener);
    }

    public void a() {
        this.n.config().setAutoRead(false);
    }

    public void b() {
        this.n.config().setAutoRead(true);
    }

    public void a(PacketListener packetListener) {
        Validate.notNull((Object)packetListener, (String)"packetListener", (Object[])new Object[0]);
        EnumProtocolDirection enumprotocoldirection = packetListener.a();
        if (enumprotocoldirection != this.l) {
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + this.l + ", but listener is " + enumprotocoldirection);
        }
        EnumProtocol enumprotocol = packetListener.b();
        EnumProtocol enumprotocol1 = ((EnumProtocol.a)this.n.attr(NetworkManager.a(enumprotocoldirection)).get()).a();
        if (enumprotocol1 != enumprotocol) {
            throw new IllegalStateException("Trying to set listener for protocol " + enumprotocol.a() + ", but current " + enumprotocoldirection + " protocol is " + enumprotocol1.a());
        }
        this.q = packetListener;
        this.p = null;
    }

    public void setListenerForce(PacketListener packetListener) {
        Validate.notNull((Object)packetListener, (String)"packetListener", (Object[])new Object[0]);
        this.q = packetListener;
        this.p = null;
    }

    public void b(PacketListener packetListener) {
        if (this.q != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.l != EnumProtocolDirection.a || packetListener.a() != EnumProtocolDirection.a || packetListener.b() != EnumProtocol.a) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.q = packetListener;
    }

    public void a(String address, int port, PacketStatusOutListener listener) {
        this.a(address, port, listener, ClientIntent.a);
    }

    public void a(String address, int port, PacketLoginOutListener listener) {
        this.a(address, port, listener, ClientIntent.b);
    }

    private void a(String address, int port, PacketListener listener, ClientIntent intent) {
        this.p = listener;
        this.a((NetworkManager networkmanager) -> {
            networkmanager.a(intent);
            this.a(listener);
            networkmanager.b(new PacketHandshakingInSetProtocol(SharedConstants.b().e(), address, port, intent), null, true);
        });
    }

    public void a(ClientIntent intent) {
        this.n.attr(f).set(intent.b().b(EnumProtocolDirection.b));
    }

    public void a(Packet<?> packet) {
        this.a(packet, (PacketSendListener)null);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener callbacks) {
        this.a(packet, callbacks, true);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
        boolean connected = this.k();
        if (!connected && !this.preparing) {
            return;
        }
        packet.onPacketDispatch(this.getPlayer());
        if (connected && (InnerUtil.canSendImmediate(this, packet) || MCUtil.isMainThread() && packet.isReady() && this.m.isEmpty() && (packet.getExtraPackets() == null || packet.getExtraPackets().isEmpty()))) {
            this.b(packet, callbacks, flush);
        } else {
            boolean hasExtraPackets;
            List<Packet<?>> extraPackets = InnerUtil.buildExtraPackets(packet);
            boolean bl = hasExtraPackets = extraPackets != null && !extraPackets.isEmpty();
            if (!hasExtraPackets) {
                this.m.add(new PacketSendAction(packet, callbacks, flush));
            } else {
                ArrayList<PacketSendAction> actions = new ArrayList<PacketSendAction>(1 + extraPackets.size());
                actions.add(new PacketSendAction(packet, null, false));
                int i2 = 0;
                int len = extraPackets.size();
                while (i2 < len) {
                    Packet<?> extraPacket = extraPackets.get(i2);
                    boolean end = ++i2 == len;
                    actions.add(new PacketSendAction(extraPacket, end ? callbacks : null, end));
                }
                this.m.addAll(actions);
            }
            this.flushQueue();
        }
    }

    public void a(Consumer<NetworkManager> task) {
        if (this.k()) {
            this.flushQueue();
            task.accept(this);
        } else {
            this.m.add(new WrappedConsumer(task));
        }
    }

    private void b(Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
        ++this.v;
        if (this.n.eventLoop().inEventLoop()) {
            this.c(packet, callbacks, flush);
        } else {
            this.n.eventLoop().execute(() -> this.c(packet, callbacks, flush));
        }
    }

    private void c(Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
        EntityPlayer player = this.getPlayer();
        if (!this.k()) {
            packet.onPacketDispatchFinish(player, null);
            return;
        }
        try {
            ChannelFuture channelfuture;
            ChannelFuture channelFuture2 = channelfuture = flush ? this.n.writeAndFlush(packet) : this.n.write(packet);
            if (callbacks != null) {
                channelfuture.addListener(future -> {
                    if (future.isSuccess()) {
                        callbacks.a();
                    } else {
                        Packet<?> packet1 = callbacks.b();
                        if (packet1 != null) {
                            ChannelFuture channelfuture1 = this.n.writeAndFlush(packet1);
                            channelfuture1.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                        }
                    }
                });
            }
            if (packet.hasFinishListener()) {
                channelfuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> packet.onPacketDispatchFinish(player, (ChannelFuture)channelFuture)));
            }
            channelfuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
        catch (Exception e2) {
            k.error("NetworkException: {}", (Object)player, (Object)e2);
            this.a(IChatBaseComponent.a("disconnect.genericReason", new Object[]{"Internal Exception: " + e2.getMessage()}));
            packet.onPacketDispatchFinish(player, null);
        }
    }

    public void c() {
        if (this.k()) {
            this.s();
        } else {
            this.m.add(new WrappedConsumer(NetworkManager::s));
        }
    }

    private void s() {
        if (this.n.eventLoop().inEventLoop()) {
            this.n.flush();
        } else {
            this.n.eventLoop().execute(() -> this.n.flush());
        }
    }

    private static AttributeKey<EnumProtocol.a<?>> a(EnumProtocolDirection side) {
        return switch (side) {
            case EnumProtocolDirection.b -> f;
            case EnumProtocolDirection.a -> e;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushQueue() {
        if (!this.k()) {
            return true;
        }
        if (MCUtil.isMainThread()) {
            return this.processQueue();
        }
        if (this.isPending) {
            Queue<WrappedConsumer> queue = this.m;
            synchronized (queue) {
                return this.processQueue();
            }
        }
        return false;
    }

    private boolean processQueue() {
        if (this.m.isEmpty()) {
            return true;
        }
        Iterator iterator = this.m.iterator();
        while (iterator.hasNext()) {
            WrappedConsumer queued = (WrappedConsumer)iterator.next();
            if (queued == null) {
                return true;
            }
            if (queued.isConsumed()) continue;
            if (queued instanceof PacketSendAction) {
                PacketSendAction packetSendAction = (PacketSendAction)queued;
                Packet<?> packet = packetSendAction.packet;
                if (!packet.isReady()) {
                    return false;
                }
            }
            iterator.remove();
            if (!queued.tryMarkConsumed()) continue;
            queued.accept(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void d() {
        block11: {
            TickablePacketListener tickablepacketlistener;
            block12: {
                PacketListener packetlistener;
                this.flushQueue();
                if (currTick != MinecraftServer.currentTick) {
                    currTick = MinecraftServer.currentTick;
                    joinAttemptsThisTick = 0;
                }
                if (!((packetlistener = this.q) instanceof TickablePacketListener)) break block11;
                tickablepacketlistener = (TickablePacketListener)packetlistener;
                PacketListener packetListener = this.q;
                if (!(packetListener instanceof LoginListener)) break block12;
                LoginListener loginPacketListener = (LoginListener)packetListener;
                if (loginPacketListener.h == LoginListener.EnumProtocolState.e && joinAttemptsThisTick++ >= MAX_PER_TICK) break block11;
            }
            PlayerConnectionUtils.packetProcessing.push(this.q);
            try {
                tickablepacketlistener.e();
            }
            finally {
                PlayerConnectionUtils.packetProcessing.pop();
            }
        }
        if (!this.k() && !this.t) {
            this.p();
        }
        if (this.n != null && enableExplicitFlush) {
            this.n.eventLoop().execute(() -> this.n.flush());
        }
        if (this.y++ % 20 == 0) {
            this.e();
        }
        if (this.B != null) {
            this.B.a();
        }
    }

    protected void e() {
        this.x = MathHelper.i(0.75f, this.v, this.x);
        this.w = MathHelper.i(0.75f, this.u, this.w);
        this.v = 0;
        this.u = 0;
    }

    public SocketAddress f() {
        return this.o;
    }

    public String a(boolean logIps) {
        return this.o == null ? "local" : (logIps ? this.o.toString() : "IP hidden");
    }

    public void a(IChatBaseComponent disconnectReason) {
        this.preparing = false;
        this.clearPacketQueue();
        if (this.n == null) {
            this.A = disconnectReason;
        }
        if (this.k()) {
            this.n.close();
            this.r = disconnectReason;
        }
    }

    public boolean g() {
        return this.n instanceof LocalChannel || this.n instanceof LocalServerChannel;
    }

    public EnumProtocolDirection h() {
        return this.l;
    }

    public EnumProtocolDirection i() {
        return this.l.a();
    }

    public static NetworkManager a(InetSocketAddress address, boolean useEpoll, @Nullable SampleLogger packetSizeLog) {
        NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        if (packetSizeLog != null) {
            networkmanager.a(packetSizeLog);
        }
        ChannelFuture channelfuture = NetworkManager.a(address, useEpoll, networkmanager);
        channelfuture.syncUninterruptibly();
        return networkmanager;
    }

    public static ChannelFuture a(InetSocketAddress address, boolean useEpoll, final NetworkManager connection) {
        EventLoopGroup eventloopgroup;
        Class<NioSocketChannel> oclass;
        if (Epoll.isAvailable() && useEpoll) {
            oclass = EpollSocketChannel.class;
            eventloopgroup = (EventLoopGroup)h.get();
        } else {
            oclass = NioSocketChannel.class;
            eventloopgroup = (EventLoopGroup)g.get();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventloopgroup)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                NetworkManager.a(channel);
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                NetworkManager.a(channelpipeline, EnumProtocolDirection.b, connection.B);
                connection.a(channelpipeline);
            }
        })).channel(oclass)).connect(address.getAddress(), address.getPort());
    }

    public static void a(ChannelPipeline pipeline, EnumProtocolDirection side, @Nullable BandwidthDebugMonitor packetSizeLogger) {
        EnumProtocolDirection enumprotocoldirection1 = side.a();
        AttributeKey<EnumProtocol.a<?>> attributekey = NetworkManager.a(side);
        AttributeKey<EnumProtocol.a<?>> attributekey1 = NetworkManager.a(enumprotocoldirection1);
        pipeline.addLast("splitter", (ChannelHandler)new PacketSplitter(packetSizeLogger)).addLast("decoder", (ChannelHandler)new PacketDecoder(attributekey)).addLast("prepender", (ChannelHandler)new PacketPrepender()).addLast("encoder", (ChannelHandler)new PacketEncoder(attributekey1)).addLast("unbundler", (ChannelHandler)new PacketBundleUnpacker(attributekey1)).addLast("bundler", (ChannelHandler)new PacketBundlePacker(attributekey));
    }

    public void a(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast("packet_handler", (ChannelHandler)this);
    }

    private static void b(ChannelPipeline pipeline, EnumProtocolDirection side) {
        EnumProtocolDirection enumprotocoldirection1 = side.a();
        AttributeKey<EnumProtocol.a<?>> attributekey = NetworkManager.a(side);
        AttributeKey<EnumProtocol.a<?>> attributekey1 = NetworkManager.a(enumprotocoldirection1);
        pipeline.addLast("validator", (ChannelHandler)new PacketFlowValidator(attributekey, attributekey1));
    }

    public static void a(ChannelPipeline pipeline, EnumProtocolDirection side) {
        NetworkManager.b(pipeline, side);
    }

    public static NetworkManager a(SocketAddress address) {
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)i.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                NetworkManager.a(channel);
                ChannelPipeline channelpipeline = channel.pipeline();
                NetworkManager.a(channelpipeline, EnumProtocolDirection.b);
                networkmanager.a(channelpipeline);
            }
        })).channel(LocalChannel.class)).connect(address).syncUninterruptibly();
        return networkmanager;
    }

    public void setupEncryption(SecretKey key) throws CryptographyException {
        if (!this.s) {
            try {
                VelocityCipher decryption = ((VelocityCipherFactory)Natives.cipher.get()).forDecryption(key);
                VelocityCipher encryption = ((VelocityCipherFactory)Natives.cipher.get()).forEncryption(key);
                this.s = true;
                this.n.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(decryption));
                this.n.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(encryption));
            }
            catch (GeneralSecurityException e2) {
                throw new CryptographyException(e2);
            }
        }
    }

    public boolean j() {
        return this.s;
    }

    public boolean k() {
        return this.n != null && this.n.isOpen();
    }

    public boolean l() {
        return this.n == null;
    }

    @Nullable
    public PacketListener m() {
        return this.q;
    }

    @Nullable
    public IChatBaseComponent n() {
        return this.r;
    }

    public void o() {
        if (this.n != null) {
            this.n.config().setAutoRead(false);
        }
    }

    public void a(int compressionThreshold, boolean rejectsBadPackets) {
        if (compressionThreshold >= 0) {
            VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(GlobalConfiguration.get().misc.compressionLevel.or(-1));
            if (this.n.pipeline().get("decompress") instanceof PacketDecompressor) {
                ((PacketDecompressor)this.n.pipeline().get("decompress")).a(compressionThreshold, rejectsBadPackets);
            } else {
                this.n.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new PacketDecompressor(compressor, compressionThreshold, rejectsBadPackets));
            }
            if (this.n.pipeline().get("compress") instanceof PacketCompressor) {
                ((PacketCompressor)this.n.pipeline().get("compress")).a(compressionThreshold);
            } else {
                this.n.pipeline().addBefore("encoder", "compress", (ChannelHandler)new PacketCompressor(compressor, compressionThreshold));
            }
            this.n.pipeline().fireUserEventTriggered((Object)ConnectionEvent.COMPRESSION_THRESHOLD_SET);
        } else {
            if (this.n.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.n.pipeline().remove("decompress");
            }
            if (this.n.pipeline().get("compress") instanceof PacketCompressor) {
                this.n.pipeline().remove("compress");
            }
            this.n.pipeline().fireUserEventTriggered((Object)ConnectionEvent.COMPRESSION_DISABLED);
        }
    }

    public void p() {
        if (this.n != null && !this.n.isOpen() && !this.t) {
            PacketListener packetlistener1;
            this.t = true;
            PacketListener packetlistener = this.m();
            PacketListener packetListener = packetlistener1 = packetlistener != null ? packetlistener : this.p;
            if (packetlistener1 != null) {
                IChatBaseComponent ichatbasecomponent = Objects.requireNonNullElseGet(this.n(), () -> IChatBaseComponent.c("multiplayer.disconnect.generic"));
                packetlistener1.a(ichatbasecomponent);
            }
            this.clearPacketQueue();
            PacketListener packetListener2 = this.m();
            if (packetListener2 instanceof ServerCommonPacketListenerImpl) {
                ServerCommonPacketListenerImpl commonPacketListener = (ServerCommonPacketListenerImpl)packetListener2;
                GameProfile profile = commonPacketListener.k();
                new PlayerConnectionCloseEvent(profile.getId(), profile.getName(), ((InetSocketAddress)this.o).getAddress(), false).callEvent();
            } else if (packetListener2 instanceof LoginListener) {
                LoginListener loginListener = (LoginListener)packetListener2;
                switch (loginListener.h) {
                    case e: 
                    case f: 
                    case g: 
                    case h: {
                        GameProfile profile = loginListener.k;
                        new PlayerConnectionCloseEvent(profile.getId(), profile.getName(), ((InetSocketAddress)this.o).getAddress(), false).callEvent();
                    }
                }
            }
        }
    }

    public float q() {
        return this.w;
    }

    public float r() {
        return this.x;
    }

    public void a(SampleLogger log) {
        this.B = new BandwidthDebugMonitor(log);
    }

    public void clearPacketQueue() {
        EntityPlayer player = this.getPlayer();
        for (Consumer consumer : this.m) {
            if (!(consumer instanceof PacketSendAction)) continue;
            PacketSendAction packetSendAction = (PacketSendAction)consumer;
            Packet<?> packet = packetSendAction.packet;
            if (!packet.hasFinishListener()) continue;
            packet.onPacketDispatchFinish(player, null);
        }
        this.m.clear();
    }

    private static class InnerUtil {
        private InnerUtil() {
        }

        @Nullable
        private static List<Packet<?>> buildExtraPackets(Packet<?> packet) {
            List<Packet<?>> extra = packet.getExtraPackets();
            if (extra == null || extra.isEmpty()) {
                return null;
            }
            ArrayList ret = new ArrayList(1 + extra.size());
            InnerUtil.buildExtraPackets0(extra, ret);
            return ret;
        }

        private static void buildExtraPackets0(List<Packet<?>> extraPackets, List<Packet<?>> into) {
            for (Packet<?> extra : extraPackets) {
                into.add(extra);
                List<Packet<?>> extraExtra = extra.getExtraPackets();
                if (extraExtra == null || extraExtra.isEmpty()) continue;
                InnerUtil.buildExtraPackets0(extraExtra, into);
            }
        }

        private static boolean canSendImmediate(NetworkManager networkManager, Packet<?> packet) {
            return networkManager.isPending || networkManager.q.b() != EnumProtocol.b || packet instanceof ClientboundKeepAlivePacket || packet instanceof ClientboundPlayerChatPacket || packet instanceof ClientboundSystemChatPacket || packet instanceof PacketPlayOutTabComplete || packet instanceof ClientboundSetTitleTextPacket || packet instanceof ClientboundSetSubtitleTextPacket || packet instanceof ClientboundSetActionBarTextPacket || packet instanceof ClientboundSetTitlesAnimationPacket || packet instanceof ClientboundClearTitlesPacket || packet instanceof PacketPlayOutNamedSoundEffect || packet instanceof PacketPlayOutEntitySound || packet instanceof PacketPlayOutStopSound || packet instanceof PacketPlayOutWorldParticles || packet instanceof PacketPlayOutBoss;
        }
    }

    private static final class PacketSendAction
    extends WrappedConsumer {
        private final Packet<?> packet;

        private PacketSendAction(Packet<?> packet, @Nullable PacketSendListener packetSendListener, boolean flush) {
            super(connection -> connection.b(packet, packetSendListener, flush));
            this.packet = packet;
        }
    }

    private static class WrappedConsumer
    implements Consumer<NetworkManager> {
        private final Consumer<NetworkManager> delegate;
        private final AtomicBoolean consumed = new AtomicBoolean(false);

        private WrappedConsumer(Consumer<NetworkManager> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(NetworkManager connection) {
            this.delegate.accept(connection);
        }

        public boolean tryMarkConsumed() {
            return this.consumed.compareAndSet(false, true);
        }

        public boolean isConsumed() {
            return this.consumed.get();
        }
    }
}

