/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.VarInt;

public class Utf8String {
    public static String a(ByteBuf buf, int length) {
        int i2 = ByteBufUtil.utf8MaxBytes((int)length);
        int j2 = VarInt.a(buf);
        if (j2 > i2) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + j2 + " > " + i2 + ")");
        }
        if (j2 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        int k2 = buf.readableBytes();
        if (j2 > k2) {
            throw new DecoderException("Not enough bytes in buffer, expected " + j2 + ", but got " + k2);
        }
        String string = buf.toString(buf.readerIndex(), j2, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + j2);
        if (string.length() > length) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + string.length() + " > " + length + ")");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(ByteBuf buf, CharSequence string, int length) {
        if (string.length() > length) {
            throw new EncoderException("String too big (was " + string.length() + " characters, max " + length + ")");
        }
        int i2 = ByteBufUtil.utf8MaxBytes((CharSequence)string);
        ByteBuf byteBuf = buf.alloc().buffer(i2);
        try {
            int j2 = ByteBufUtil.writeUtf8((ByteBuf)byteBuf, (CharSequence)string);
            int k2 = ByteBufUtil.utf8MaxBytes((int)length);
            if (j2 > k2) {
                throw new EncoderException("String too big (was " + j2 + " bytes encoded, max " + k2 + ")");
            }
            VarInt.a(buf, j2);
            buf.writeBytes(byteBuf);
        }
        finally {
            byteBuf.release();
        }
    }
}

