/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;

public class ComponentSerialization {
    public static final Codec<IChatBaseComponent> a = ExtraCodecs.a("Component", ComponentSerialization::a);
    public static final Codec<IChatBaseComponent> b = ExtraCodecs.c.flatXmap(json -> a.parse((DynamicOps)JsonOps.INSTANCE, json), text -> a.encodeStart((DynamicOps)JsonOps.INSTANCE, text));
    private static final Map<Locale, Codec<IChatBaseComponent>> LOCALIZED_CODECS = new ConcurrentHashMap<Locale, Codec<IChatBaseComponent>>();

    private static IChatMutableComponent a(List<IChatBaseComponent> texts) {
        IChatMutableComponent mutableComponent = texts.get(0).f();
        for (int i2 = 1; i2 < texts.size(); ++i2) {
            mutableComponent.b(texts.get(i2));
        }
        return mutableComponent;
    }

    public static <T extends INamable, E> MapCodec<E> a(T[] types, Function<T, MapCodec<? extends E>> typeToCodec, Function<E, T> valueToType, String dispatchingKey) {
        a<Object> mapCodec = new a<Object>(Stream.of(types).map(typeToCodec).toList(), object -> (MapEncoder)typeToCodec.apply((INamable)valueToType.apply(object)));
        Codec codec = INamable.b(() -> types);
        MapCodec mapCodec2 = codec.dispatchMap(dispatchingKey, valueToType, type -> ((MapCodec)typeToCodec.apply(type)).codec());
        b<Object> mapCodec3 = new b<Object>(dispatchingKey, mapCodec2, mapCodec);
        return ExtraCodecs.a(mapCodec3, mapCodec2);
    }

    public static Codec<IChatBaseComponent> localizedCodec(@org.checkerframework.checker.nullness.qual.Nullable Locale locale) {
        if (locale == null) {
            return a;
        }
        return LOCALIZED_CODECS.computeIfAbsent(locale, loc -> ExtraCodecs.a("Component", (Codec<T> selfCodec) -> ComponentSerialization.createCodec((Codec<IChatBaseComponent>)selfCodec, loc)));
    }

    private static Codec<IChatBaseComponent> a(Codec<IChatBaseComponent> selfCodec) {
        return ComponentSerialization.createCodec(selfCodec, null);
    }

    private static Codec<IChatBaseComponent> createCodec(Codec<IChatBaseComponent> selfCodec, final @Nullable Locale locale) {
        Codec codec;
        INamable[] types = new ComponentContents.a[]{LiteralContents.b, TranslatableContents.c, KeybindContents.b, ScoreContents.c, SelectorContents.b, NbtContents.b};
        MapCodec mapCodec = ComponentSerialization.a((INamable[])types, ComponentContents.a::a, ComponentContents::a, (String)"type");
        final Codec origCodec = codec = RecordCodecBuilder.create(instance -> instance.group((App)mapCodec.forGetter(IChatBaseComponent::b), (App)ExtraCodecs.a(ExtraCodecs.a(selfCodec.listOf()), "extra", List.of()).forGetter(IChatBaseComponent::c), (App)ChatModifier.ChatModifierSerializer.a.forGetter(IChatBaseComponent::a)).apply((Applicative)instance, IChatMutableComponent::new));
        codec = new Codec<IChatBaseComponent>(){

            public <T> DataResult<Pair<IChatBaseComponent, T>> decode(DynamicOps<T> ops, T input) {
                return origCodec.decode(ops, input);
            }

            public <T> DataResult<T> encode(IChatBaseComponent input, DynamicOps<T> ops, T prefix) {
                Component adventureComponent;
                if (input instanceof AdventureComponent) {
                    AdventureComponent adv = (AdventureComponent)input;
                    adventureComponent = adv.adventure$component();
                } else if (locale != null && input.b() instanceof TranslatableContents && PaperAdventure.hasAnyTranslations()) {
                    adventureComponent = PaperAdventure.asAdventure(input);
                } else {
                    return origCodec.encode((Object)input, ops, prefix);
                }
                return PaperAdventure.localizedCodec(locale).encode((Object)adventureComponent, ops, prefix);
            }

            public String toString() {
                return origCodec.toString() + "[AdventureComponentAware]";
            }
        };
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, ExtraCodecs.a(selfCodec.listOf())), (Codec)codec).xmap(either -> either.map(either2 -> either2.map(IChatBaseComponent::b, ComponentSerialization::a), text -> text), text -> {
            String string = text.d();
            return string != null ? Either.left(Either.left(string)) : Either.right(text);
        });
    }

    static class a<T>
    extends MapCodec<T> {
        private final List<MapCodec<? extends T>> a;
        private final Function<T, MapEncoder<? extends T>> b;

        public a(List<MapCodec<? extends T>> codecs, Function<T, MapEncoder<? extends T>> codecGetter) {
            this.a = codecs;
            this.b = codecGetter;
        }

        public <S> DataResult<T> decode(DynamicOps<S> dynamicOps, MapLike<S> mapLike) {
            for (MapDecoder mapDecoder : this.a) {
                DataResult dataResult = mapDecoder.decode(dynamicOps, mapLike);
                if (!dataResult.result().isPresent()) continue;
                return dataResult;
            }
            return DataResult.error(() -> "No matching codec found");
        }

        public <S> RecordBuilder<S> encode(T object, DynamicOps<S> dynamicOps, RecordBuilder<S> recordBuilder) {
            MapEncoder<? extends T> mapEncoder = this.b.apply(object);
            return mapEncoder.encode(object, dynamicOps, recordBuilder);
        }

        public <S> Stream<S> keys(DynamicOps<S> dynamicOps) {
            return this.a.stream().flatMap(codec -> codec.keys(dynamicOps)).distinct();
        }

        public String toString() {
            return "FuzzyCodec[" + this.a + "]";
        }
    }

    static class b<T>
    extends MapCodec<T> {
        private final String a;
        private final MapCodec<T> b;
        private final MapCodec<T> c;

        public b(String dispatchingKey, MapCodec<T> withKeyCodec, MapCodec<T> withoutKeyCodec) {
            this.a = dispatchingKey;
            this.b = withKeyCodec;
            this.c = withoutKeyCodec;
        }

        public <O> DataResult<T> decode(DynamicOps<O> dynamicOps, MapLike<O> mapLike) {
            return mapLike.get(this.a) != null ? this.b.decode(dynamicOps, mapLike) : this.c.decode(dynamicOps, mapLike);
        }

        public <O> RecordBuilder<O> encode(T object, DynamicOps<O> dynamicOps, RecordBuilder<O> recordBuilder) {
            return this.c.encode(object, dynamicOps, recordBuilder);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> dynamicOps) {
            return Stream.concat(this.b.keys(dynamicOps), this.c.keys(dynamicOps)).distinct();
        }
    }
}

